/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementTask;
import org.hibernate.orm.tooling.gradle.metamodel.JpaMetamodelGenerationTask;

public class HibernateOrmPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        project.getLogger().debug("Adding Hibernate extensions to the build [{}]", (Object)project.getPath());
        HibernateOrmSpec ormDsl = (HibernateOrmSpec)project.getExtensions().create("hibernate", HibernateOrmSpec.class, new Object[]{project});
        EnhancementTask.apply(ormDsl, (SourceSet)ormDsl.getSourceSetProperty().get(), project);
        JpaMetamodelGenerationTask.apply(ormDsl, (SourceSet)ormDsl.getSourceSetProperty().get(), project);
    }
}

