/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.enhance;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskState;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementHelper;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementSpec;

public class EnhancementTask
extends DefaultTask {
    public static final String DSL_NAME = "hibernateEnhance";
    private final EnhancementSpec enhancementDsl;
    private final DirectoryProperty javaCompileOutputDirectory;
    private final DirectoryProperty outputDirectory;

    public static void apply(HibernateOrmSpec ormDsl, SourceSet mainSourceSet, Project project) {
        EnhancementTask enhancementTask = (EnhancementTask)project.getTasks().create(DSL_NAME, EnhancementTask.class, new Object[]{ormDsl, mainSourceSet, project});
        enhancementTask.setGroup("hibernate");
        enhancementTask.setDescription("Performs Hibernate ORM enhancement of the project's compiled classes");
        String compileJavaTaskName = mainSourceSet.getCompileJavaTaskName();
        Task compileJavaTask = project.getTasks().getByName(compileJavaTaskName);
        enhancementTask.dependsOn(new Object[]{compileJavaTask});
        compileJavaTask.finalizedBy(new Object[]{enhancementTask});
    }

    @Inject
    public EnhancementTask(HibernateOrmSpec ormSpec, SourceSet mainSourceSet, Project project) {
        this.enhancementDsl = ormSpec.getEnhancementSpec();
        this.javaCompileOutputDirectory = mainSourceSet.getJava().getDestinationDirectory();
        this.outputDirectory = project.getObjects().directoryProperty();
        this.outputDirectory.set(project.getLayout().getBuildDirectory().dir("tmp/hibernateEnhancement"));
        final AtomicBoolean didCompileRun = new AtomicBoolean(false);
        final TaskExecutionGraph taskGraph = project.getGradle().getTaskGraph();
        taskGraph.addTaskExecutionListener((TaskExecutionListener)new TaskExecutionAdapter(){

            public void afterExecute(Task task, TaskState state) {
                super.afterExecute(task, state);
                if ("compileJava".equals(task.getName()) && state.getDidWork()) {
                    didCompileRun.set(true);
                }
                taskGraph.removeTaskExecutionListener((TaskExecutionListener)this);
            }
        });
        this.getOutputs().upToDateWhen(task -> !didCompileRun.get());
    }

    @InputDirectory
    @Incremental
    public DirectoryProperty getJavaCompileDirectory() {
        return this.javaCompileOutputDirectory;
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void enhanceClasses(InputChanges inputChanges) {
        if (!this.enhancementDsl.hasAnythingToDo()) {
            return;
        }
        if (!inputChanges.isIncremental()) {
            this.getProject().getLogger().debug("EnhancementTask inputs were not incremental");
        }
        if (((Boolean)this.enhancementDsl.getEnableExtendedEnhancement().get()).booleanValue()) {
            this.getProject().getLogger().info("Performing extended enhancement");
        }
        EnhancementHelper.enhance(this.javaCompileOutputDirectory, inputChanges, this.enhancementDsl, this.getProject());
    }
}

