/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.HibernateVersion;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementTask;
import org.hibernate.orm.tooling.gradle.metamodel.JpaMetamodelGenerationTask;

public class HibernateOrmPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        project.getLogger().debug("Adding Hibernate extensions to the build [{}]", (Object)project.getPath());
        HibernateOrmSpec ormDsl = (HibernateOrmSpec)project.getExtensions().create("hibernate", HibernateOrmSpec.class, new Object[]{project});
        Configuration hibernateOrm = (Configuration)project.getConfigurations().maybeCreate("hibernateOrm");
        project.getDependencies().add("hibernateOrm", (Object)project.provider(() -> "org.hibernate.orm:hibernate-core:" + HibernateVersion.version));
        project.getConfigurations().getByName("implementation").extendsFrom(new Configuration[]{hibernateOrm});
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        assert (javaPluginConvention != null);
        SourceSetContainer sourceSets = javaPluginConvention.getSourceSets();
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        EnhancementTask.apply(ormDsl, mainSourceSet, project);
        JpaMetamodelGenerationTask.apply(ormDsl, mainSourceSet, project);
        project.getDependencies().add("implementation", (Object)project.provider(() -> "org.hibernate.orm:hibernate-core:" + (String)ormDsl.getHibernateVersionProperty().get()));
    }
}

