/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel.model;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.orm.tooling.gradle.metamodel.JpaMetamodelGenerationSpec;
import org.hibernate.orm.tooling.gradle.metamodel.model.MetamodelClass;
import org.hibernate.orm.tooling.gradle.metamodel.model.ObjectFactory;

public class JpaStaticMetamodelGenerator {
    private final JpaMetamodelGenerationSpec spec;
    private final MetadataImplementor metadata;
    private final Directory generationOutputDirectory;
    private final ObjectFactory objectFactory;
    private final Set<String> processedDomainTypeNames = new HashSet<String>();

    public static void processMetamodel(PersistenceUnitInfo persistenceUnitInfo, JpaMetamodelGenerationSpec spec) {
        EntityManagerFactoryBuilder target = Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitInfo)persistenceUnitInfo, Collections.emptyMap());
        try {
            new JpaStaticMetamodelGenerator(spec, target.metadata()).process();
        }
        finally {
            target.cancel();
        }
    }

    private JpaStaticMetamodelGenerator(JpaMetamodelGenerationSpec spec, MetadataImplementor metadata) {
        this.spec = spec;
        this.metadata = metadata;
        this.generationOutputDirectory = (Directory)spec.getGenerationOutputDirectory().get();
        this.objectFactory = new ObjectFactory(metadata);
    }

    private void process() {
        Collection entityBindings;
        Set mappedSuperclasses = this.metadata.getMappedSuperclassMappingsCopy();
        if (mappedSuperclasses != null) {
            mappedSuperclasses.forEach(this::handleMappedClass);
        }
        if ((entityBindings = this.metadata.getEntityBindings()) != null) {
            entityBindings.forEach(this::handlePersistentClass);
        }
    }

    private void handleMappedClass(MappedSuperclass mappingDescriptor) {
        MetamodelClass metamodelClass = this.objectFactory.metamodelClass(mappingDescriptor);
        this.handleManagedClass(metamodelClass, mappingDescriptor.getDeclaredPropertyIterator());
    }

    private void handlePersistentClass(PersistentClass persistentClass) {
        MetamodelClass metamodelClass = this.objectFactory.metamodelClass(persistentClass);
        this.handleManagedClass(metamodelClass, persistentClass.getDeclaredPropertyIterator());
    }

    private void handleManagedClass(MetamodelClass metamodelClass, Iterator<Property> propertyIterator) {
        if (!this.processedDomainTypeNames.add(metamodelClass.getDomainClassName())) {
            return;
        }
        propertyIterator.forEachRemaining(property -> metamodelClass.addAttribute(this.objectFactory.attribute((Property)property, property.getValue(), metamodelClass, this::handleEmbeddable)));
        String replaced = metamodelClass.getMetamodelClassName().replace('.', '/');
        String metamodelClassJavaFileName = replaced + ".java";
        RegularFile metamodelClassJavaFile = this.generationOutputDirectory.file(metamodelClassJavaFileName);
        File metamodelClassJavaFileAsFile = metamodelClassJavaFile.getAsFile();
        metamodelClass.writeToFile(metamodelClassJavaFileAsFile, this.spec);
    }

    private void handleEmbeddable(Component embeddedValueMapping) {
        MetamodelClass metamodelClass = this.objectFactory.metamodelClass(embeddedValueMapping);
        this.handleManagedClass(metamodelClass, embeddedValueMapping.getPropertyIterator());
    }
}

