/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.metamodel.model;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Locale;
import org.hibernate.orm.tooling.gradle.metamodel.model.MetamodelAttribute;
import org.hibernate.orm.tooling.gradle.metamodel.model.MetamodelClass;

public abstract class AttributeSupport
implements MetamodelAttribute {
    private final MetamodelClass metamodelClass;
    private final String name;
    private final Class<?> javaType;

    public AttributeSupport(MetamodelClass metamodelClass, String name, Class<?> javaType) {
        this.metamodelClass = metamodelClass;
        this.name = name;
        this.javaType = javaType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getAttributeJavaType() {
        return this.javaType;
    }

    public String getOwnerDomainClassName() {
        return this.metamodelClass.getMetamodelClassName();
    }

    @Override
    public void renderJpaMembers(BufferedWriter writer) {
        try {
            writer.write("    public static volatile ");
            this.renderAttributeType(writer);
            writer.write(" " + this.name);
            writer.write(59);
            writer.write(13);
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem writing attribute `" + this.metamodelClass.getMetamodelClassName() + "#" + this.name + "` to output stream", e);
        }
    }

    public abstract void renderAttributeType(BufferedWriter var1) throws IOException;

    protected String format(String pattern, Object ... args) {
        return String.format(Locale.ROOT, pattern, args);
    }

    @Override
    public void renderNameConstant(BufferedWriter writer) {
        try {
            writer.write("    public static final String ");
            writer.write(this.getName().toUpperCase(Locale.ROOT));
            writer.write(" = \"" + this.getName() + "\";");
            writer.write(13);
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem writing attribute `" + this.metamodelClass.getMetamodelClassName() + "#" + this.name + "` to output stream", e);
        }
    }
}

