/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.hibernate.orm.tooling.gradle.HibernateVersion;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementSpec;
import org.hibernate.orm.tooling.gradle.metamodel.JpaMetamodelGenerationSpec;

public abstract class HibernateOrmSpec
implements ExtensionAware {
    public static final String HIBERNATE = "hibernate";
    public static final String DSL_NAME = "hibernate";
    private final Property<String> hibernateVersionProperty;
    private final Property<Boolean> supportEnhancementProperty;
    private final Property<Boolean> supportJpaMetamodelProperty;
    private final EnhancementSpec enhancementDsl;
    private final JpaMetamodelGenerationSpec jpaMetamodelDsl;

    @Inject
    public HibernateOrmSpec(Project project) {
        this.hibernateVersionProperty = project.getObjects().property(String.class);
        this.hibernateVersionProperty.convention((Object)HibernateVersion.version);
        this.supportEnhancementProperty = project.getObjects().property(Boolean.class);
        this.supportEnhancementProperty.convention((Object)true);
        this.supportJpaMetamodelProperty = project.getObjects().property(Boolean.class);
        this.supportJpaMetamodelProperty.convention((Object)true);
        this.enhancementDsl = (EnhancementSpec)this.getExtensions().create("enhancement", EnhancementSpec.class, new Object[]{this, project});
        this.jpaMetamodelDsl = (JpaMetamodelGenerationSpec)this.getExtensions().create("jpaMetamodel", JpaMetamodelGenerationSpec.class, new Object[]{this, project});
    }

    public Property<String> getHibernateVersionProperty() {
        return this.hibernateVersionProperty;
    }

    public void hibernateVersion(String version) {
        this.setHibernateVersion(version);
    }

    public void setHibernateVersion(String version) {
        this.hibernateVersionProperty.set((Object)version);
    }

    public Property<Boolean> getSupportEnhancementProperty() {
        return this.supportEnhancementProperty;
    }

    public void disableEnhancement() {
        this.supportEnhancementProperty.set((Object)false);
    }

    public Property<Boolean> getSupportJpaMetamodelProperty() {
        return this.supportJpaMetamodelProperty;
    }

    public void disableJpaMetamodel() {
        this.supportJpaMetamodelProperty.set((Object)false);
    }

    public EnhancementSpec getEnhancementSpec() {
        return this.enhancementDsl;
    }

    public void enhancement(Action<EnhancementSpec> action) {
        action.execute((Object)this.enhancementDsl);
    }

    public JpaMetamodelGenerationSpec getJpaMetamodelSpec() {
        return this.jpaMetamodelDsl;
    }

    public void jpaMetamodel(Action<JpaMetamodelGenerationSpec> action) {
        action.execute((Object)this.jpaMetamodelDsl);
    }

    public abstract ExtensionContainer getExtensions();
}

