/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities;

import org.hibernate.envers.ModificationStore;

public class PropertyData {
    private final String name;
    private final String beanName;
    private final String accessType;
    private final ModificationStore store;
    private boolean usingModifiedFlag;
    private String modifiedFlagName;

    public PropertyData(String newName, PropertyData propertyData) {
        this.name = newName;
        this.beanName = propertyData.beanName;
        this.accessType = propertyData.accessType;
        this.store = propertyData.store;
    }

    public PropertyData(String name, String beanName, String accessType, ModificationStore store) {
        this.name = name;
        this.beanName = beanName;
        this.accessType = accessType;
        this.store = store;
    }

    public PropertyData(String name, String beanName, String accessType, ModificationStore store, boolean usingModifiedFlag, String modifiedFlagName) {
        this(name, beanName, accessType, store);
        this.usingModifiedFlag = usingModifiedFlag;
        this.modifiedFlagName = modifiedFlagName;
    }

    public String getName() {
        return this.name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public ModificationStore getStore() {
        return this.store;
    }

    public boolean isUsingModifiedFlag() {
        return this.usingModifiedFlag;
    }

    public String getModifiedFlagPropertyName() {
        return this.modifiedFlagName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyData that = (PropertyData)o;
        if (this.accessType != null ? !this.accessType.equals(that.accessType) : that.accessType != null) {
            return false;
        }
        if (this.beanName != null ? !this.beanName.equals(that.beanName) : that.beanName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.store != that.store) {
            return false;
        }
        return this.usingModifiedFlag == that.usingModifiedFlag;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.beanName != null ? this.beanName.hashCode() : 0);
        result = 31 * result + (this.accessType != null ? this.accessType.hashCode() : 0);
        result = 31 * result + (this.store != null ? this.store.hashCode() : 0);
        result = 31 * result + (this.usingModifiedFlag ? 1 : 0);
        return result;
    }
}

