/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.reflection.java.generics;

import java.lang.reflect.Type;
import junit.framework.TestCase;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironmentFactory;
import org.hibernate.annotations.common.reflection.java.generics.TypeUtils;
import org.hibernate.annotations.common.test.reflection.java.generics.Dad;
import org.hibernate.annotations.common.test.reflection.java.generics.Son;

public class TypeUtilsTest
extends TestCase {
    TypeEnvironmentFactory env = new TypeEnvironmentFactory();
    TypeEnvironment dadContext = this.env.getEnvironment(Dad.class);
    TypeEnvironment sonContext = this.env.getEnvironment(Son.class);

    public void testAClassIsAlwaysFullyResolved() throws Exception {
        TypeUtilsTest.assertTrue((boolean)TypeUtils.isResolved(Dad.class));
    }

    private Type getPropertyFromDad(String propertyName) throws NoSuchMethodException {
        return Dad.class.getMethod(propertyName, new Class[0]).getGenericReturnType();
    }

    public void testKnowsWhetherAParametricTypeIsFullyResolved() throws Exception {
        Type simpleType = this.getPropertyFromDad("returnsGeneric");
        TypeUtilsTest.assertFalse((boolean)TypeUtils.isResolved((Type)this.dadContext.bind(simpleType)));
        TypeUtilsTest.assertTrue((boolean)TypeUtils.isResolved((Type)this.sonContext.bind(simpleType)));
    }

    public void testKnowsWhetherAnArrayTypeIsFullyResolved() throws Exception {
        Type arrayType = this.getPropertyFromDad("getArrayProperty");
        TypeUtilsTest.assertFalse((boolean)TypeUtils.isResolved((Type)this.dadContext.bind(arrayType)));
        TypeUtilsTest.assertTrue((boolean)TypeUtils.isResolved((Type)this.sonContext.bind(arrayType)));
    }

    public void testKnowsWhetherATypeIsSimple() throws Exception {
        TypeUtilsTest.assertTrue((boolean)TypeUtils.isSimple(String.class));
        TypeUtilsTest.assertFalse((boolean)TypeUtils.isSimple(new String[1].getClass()));
        TypeUtilsTest.assertFalse((boolean)TypeUtils.isSimple((Type)this.getPropertyFromDad("getNongenericCollectionProperty")));
        TypeUtilsTest.assertFalse((boolean)TypeUtils.isSimple((Type)this.getPropertyFromDad("getGenericCollectionProperty")));
    }
}

