/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.reflection.java;

import java.io.Serializable;
import java.util.List;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.test.reflection.java.Sex;
import org.hibernate.annotations.common.test.reflection.java.XAnnotatedElementTestCase;
import org.hibernate.annotations.common.test.reflection.java.generics.Dad;
import org.hibernate.annotations.common.test.reflection.java.generics.Grandpa;
import org.hibernate.annotations.common.test.reflection.java.generics.Language;
import org.hibernate.annotations.common.test.reflection.java.generics.Son;

public class JavaXClassTest
extends XAnnotatedElementTestCase {
    ReflectionManager factory = new JavaReflectionManager();
    XClass fatherAsSeenFromSon = this.factory.toXClass(Son.class).getSuperclass();
    XClass grandpa = this.factory.toXClass(Grandpa.class);

    public void testHasAPointOfViewClass() {
        XClass sameView = this.factory.toXClass(Son.class).getSuperclass();
        XClass differentView = this.factory.toXClass(Dad.class);
        JavaXClassTest.assertSame((String)"Should be the same instance: same owner", (Object)sameView, (Object)this.fatherAsSeenFromSon);
        JavaXClassTest.assertNotSame((String)"Should be a different instance: different owner", (Object)differentView, (Object)this.fatherAsSeenFromSon);
        JavaXClassTest.assertEquals((String)".equals() should show equality", (Object)sameView, (Object)differentView);
    }

    public void testHasAName() {
        JavaXClassTest.assertSame((Object)"org.hibernate.annotations.common.test.reflection.java.generics.Dad", (Object)this.fatherAsSeenFromSon.getName());
    }

    public void testHasASuperclass() {
        JavaXClassTest.assertEquals((Object)this.grandpa, (Object)this.fatherAsSeenFromSon.getSuperclass());
    }

    public void testSuperSuperClass() {
        JavaXClassTest.assertEquals((Object)this.factory.toXClass(Object.class), (Object)this.grandpa.getSuperclass());
        JavaXClassTest.assertEquals(null, (Object)this.grandpa.getSuperclass().getSuperclass());
    }

    public void testHasInterfaces() {
        XClass[] interfaces = this.fatherAsSeenFromSon.getSuperclass().getInterfaces();
        JavaXClassTest.assertEquals((int)2, (int)interfaces.length);
        JavaXClassTest.assertTrue((boolean)this.factory.equals(interfaces[0], Serializable.class));
        JavaXClassTest.assertTrue((boolean)this.factory.equals(interfaces[1], Language.class));
    }

    public void testCanBeAssignableFromAnotherXClass() {
        JavaXClassTest.assertFalse((boolean)this.fatherAsSeenFromSon.isAssignableFrom(this.grandpa));
        JavaXClassTest.assertTrue((boolean)this.grandpa.isAssignableFrom(this.fatherAsSeenFromSon));
    }

    public void testExtractsPublicFieldsAsProperties() {
        List fieldProperties = this.fatherAsSeenFromSon.getDeclaredProperties("field");
        JavaXClassTest.assertEquals((int)1, (int)fieldProperties.size());
    }

    public void testExtractsPublicMethodsAsProperties() {
        List methodProperties = this.fatherAsSeenFromSon.getDeclaredProperties("property");
        JavaXClassTest.assertEquals((int)9, (int)methodProperties.size());
    }

    public void testCanBeAbstract() {
        JavaXClassTest.assertFalse((boolean)this.fatherAsSeenFromSon.isAbstract());
        JavaXClassTest.assertTrue((boolean)this.factory.toXClass(Grandpa.class).isAbstract());
    }

    public void testCanBeAPrimitive() {
        JavaXClassTest.assertFalse((boolean)this.fatherAsSeenFromSon.isPrimitive());
        JavaXClassTest.assertTrue((boolean)this.factory.toXClass(Integer.TYPE).isPrimitive());
    }

    public void testCanBeAnEnum() {
        JavaXClassTest.assertFalse((boolean)this.fatherAsSeenFromSon.isEnum());
        JavaXClassTest.assertTrue((boolean)this.factory.toXClass(Sex.class).isEnum());
    }

    @Override
    protected XAnnotatedElement getConcreteInstance() {
        return this.factory.toXClass(Dad.class);
    }
}

