/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.xjc;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.OutputDirectory;
import org.hibernate.build.gradle.xjc.SchemaDescriptor;
import org.hibernate.build.gradle.xjc.SchemaDescriptorFactory;

public class XjcExtension {
    public static final String REGISTRATION_NAME = "xjc";
    private final DirectoryProperty outputDirectory;
    private final NamedDomainObjectContainer<SchemaDescriptor> schemas;

    @Inject
    public XjcExtension(Project project) {
        this.outputDirectory = project.getObjects().directoryProperty();
        this.outputDirectory.convention(project.getLayout().getBuildDirectory().dir("generated-src/xjc/main"));
        this.schemas = project.container(SchemaDescriptor.class, (NamedDomainObjectFactory)new SchemaDescriptorFactory(this, project));
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    public NamedDomainObjectContainer<SchemaDescriptor> schemas(Closure closure) {
        return this.schemas.configure(closure);
    }

    public final NamedDomainObjectContainer<SchemaDescriptor> getSchemas() {
        return this.schemas;
    }
}

