/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.xjc;

import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.build.gradle.xjc.SchemaDescriptor;
import org.hibernate.build.gradle.xjc.XjcExtension;
import org.hibernate.build.gradle.xjc.XjcTask;

public class SchemaDescriptorFactory
implements NamedDomainObjectFactory<SchemaDescriptor> {
    private final XjcExtension xjcExtension;
    private final Project project;

    public SchemaDescriptorFactory(XjcExtension xjcExtension, Project project) {
        this.xjcExtension = xjcExtension;
        this.project = project;
    }

    public SchemaDescriptor create(String name) {
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(name, this.project);
        XjcTask xjcTask = (XjcTask)this.project.getTasks().create(SchemaDescriptorFactory.determineXjcTaskName(schemaDescriptor), XjcTask.class);
        xjcTask.getXsdFile().set((Provider)schemaDescriptor.getXsdFile());
        xjcTask.getXjcBindingFile().set((Provider)schemaDescriptor.getXjcBindingFile());
        xjcTask.getXjcExtensions().set(schemaDescriptor.___xjcExtensions());
        xjcTask.getOutputDirectory().convention(this.xjcExtension.getOutputDirectory().dir(name));
        SourceSet mainSourceSet = (SourceSet)((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().findByName("main");
        mainSourceSet.getJava().srcDir((Object)xjcTask.getOutputDirectory());
        this.project.getTasks().getByName("xjc").dependsOn(new Object[]{xjcTask});
        return schemaDescriptor;
    }

    private static String determineXjcTaskName(SchemaDescriptor schemaDescriptor) {
        assert (schemaDescriptor.getName() != null);
        char initialLetterCap = Character.toUpperCase(schemaDescriptor.getName().charAt(0));
        String rest = schemaDescriptor.getName().substring(1);
        return "xjc" + initialLetterCap + rest;
    }
}

