/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.xjc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;

public class SchemaDescriptor
implements Named {
    private final String name;
    private final Project project;
    private final RegularFileProperty xsdFile;
    private final RegularFileProperty xjcBindingFile;
    private SetProperty<String> xjcExtensions;

    public SchemaDescriptor(String name, Project project) {
        this.name = name;
        this.project = project;
        this.xsdFile = project.getObjects().fileProperty();
        this.xjcBindingFile = project.getObjects().fileProperty();
        this.xjcExtensions = project.getObjects().setProperty(String.class);
    }

    public final String getName() {
        return this.name;
    }

    @InputFile
    public RegularFileProperty getXsdFile() {
        return this.xsdFile;
    }

    public void setXsdFile(Object reference) {
        this.xsdFile.set(this.project.file(reference));
    }

    public void xsdFile(Object reference) {
        this.setXsdFile(reference);
    }

    @InputFile
    public RegularFileProperty getXjcBindingFile() {
        return this.xjcBindingFile;
    }

    public void setXjcBindingFile(Object reference) {
        this.xjcBindingFile.set(this.project.file(reference));
    }

    public void xjcBindingFile(Object reference) {
        this.setXjcBindingFile(reference);
    }

    @Input
    public SetProperty<String> ___xjcExtensions() {
        return this.xjcExtensions;
    }

    public Set<String> getXjcExtensions() {
        return (Set)this.xjcExtensions.get();
    }

    public void setXjcExtensions(Set<String> xjcExtensions) {
        this.xjcExtensions.set(xjcExtensions);
    }

    public void setXjcExtensions(String ... xjcExtensions) {
        this.xjcExtensions(xjcExtensions);
    }

    public void xjcExtensions(String ... xjcExtensions) {
        this.setXjcExtensions(new HashSet<String>(Arrays.asList(xjcExtensions)));
    }
}

