/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.io;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileMatchers {
    @Factory
    public static Matcher<File> anExistingDirectory() {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                boolean result = actual.isDirectory();
                if (!result) {
                    mismatchDescription.appendText("was a File that either didn't exist, or was not a directory");
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("a File representing a directory that exists");
            }
        };
    }

    @Factory
    public static Matcher<File> anExistingFileOrDirectory() {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                boolean exists = actual.exists();
                if (!exists) {
                    mismatchDescription.appendText("was a File that did not exist");
                }
                return exists;
            }

            public void describeTo(Description description) {
                description.appendText("a file or directory that exists");
            }
        };
    }

    @Factory
    public static Matcher<File> anExistingFile() {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                boolean result = actual.isFile();
                if (!result) {
                    mismatchDescription.appendText("was a File that either didn't exist, or was a directory");
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("a File representing a file that exists");
            }
        };
    }

    @Factory
    public static Matcher<File> aReadableFile() {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                boolean result = actual.canRead();
                if (!result) {
                    mismatchDescription.appendText("was a File that could not be read");
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("a File that can be read");
            }
        };
    }

    @Factory
    public static Matcher<File> aWritableFile() {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                boolean result = actual.canWrite();
                if (!result) {
                    mismatchDescription.appendText("was a File that could not be written to");
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("a writable File");
            }
        };
    }

    @Factory
    public static Matcher<File> aFileWithSize(long size) {
        return FileMatchers.aFileWithSize((Matcher<Long>)IsEqual.equalTo((Object)size));
    }

    @Factory
    public static Matcher<File> aFileWithSize(final Matcher<Long> size) {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                long length = actual.length();
                boolean result = size.matches((Object)length);
                if (!result) {
                    mismatchDescription.appendText("was a File whose size ");
                    size.describeMismatch((Object)length, mismatchDescription);
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("a File whose size is ").appendDescriptionOf((SelfDescribing)size);
            }
        };
    }

    @Factory
    public static Matcher<File> aFileNamed(final Matcher<String> name) {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                String actualName = actual.getName();
                boolean result = name.matches((Object)actualName);
                if (!result) {
                    mismatchDescription.appendText("was a File whose name ");
                    name.describeMismatch((Object)actualName, mismatchDescription);
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("a File whose name is ").appendDescriptionOf((SelfDescribing)name);
            }
        };
    }

    @Factory
    public static Matcher<File> aFileWithCanonicalPath(final Matcher<String> path) {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                try {
                    String canonicalPath = actual.getCanonicalPath();
                    boolean result = path.matches((Object)canonicalPath);
                    if (!result) {
                        mismatchDescription.appendText("was a File whose canonical path ");
                        path.describeMismatch((Object)canonicalPath, mismatchDescription);
                    }
                    return result;
                }
                catch (IOException e) {
                    mismatchDescription.appendText("was a File whose canonical path was underivable (exception: ").appendValue((Object)e).appendText(")");
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("a File whose canonical path is ").appendDescriptionOf((SelfDescribing)path);
            }
        };
    }

    @Factory
    public static Matcher<File> aFileWithAbsolutePath(final Matcher<String> path) {
        return new TypeSafeDiagnosingMatcher<File>(){

            public boolean matchesSafely(File actual, Description mismatchDescription) {
                String absolute = actual.getAbsolutePath();
                boolean result = path.matches((Object)absolute);
                if (!result) {
                    mismatchDescription.appendText("was a File whose absolute path ");
                    path.describeMismatch((Object)absolute, mismatchDescription);
                }
                return result;
            }

            public void describeTo(Description description) {
                description.appendText("a File whose absolute path is ").appendDescriptionOf((SelfDescribing)path);
            }
        };
    }
}

