/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIn<T>
extends BaseMatcher<T> {
    private final Collection<T> collection;

    public IsIn(Collection<T> collection) {
        this.collection = collection;
    }

    public IsIn(T[] elements) {
        this.collection = Arrays.asList(elements);
    }

    public boolean matches(Object o) {
        return this.collection.contains(o);
    }

    public void describeTo(Description buffer) {
        buffer.appendText("one of ");
        buffer.appendValueList("{", ", ", "}", this.collection);
    }

    @Deprecated
    @Factory
    public static <T> Matcher<T> isIn(Collection<T> collection) {
        return IsIn.in(collection);
    }

    @Factory
    public static <T> Matcher<T> in(Collection<T> collection) {
        return new IsIn<T>(collection);
    }

    @Deprecated
    @Factory
    public static <T> Matcher<T> isIn(T[] elements) {
        return IsIn.in(elements);
    }

    @Factory
    public static <T> Matcher<T> in(T[] elements) {
        return new IsIn<T>(elements);
    }

    @Deprecated
    @Factory
    public static <T> Matcher<T> isOneOf(T ... elements) {
        return IsIn.oneOf(elements);
    }

    @Factory
    public static <T> Matcher<T> oneOf(T ... elements) {
        return IsIn.in(elements);
    }
}

