/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "tk" locale.
 */
public class LocalizedNamesImpl_tk extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "TM",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "UM",
        "VI",
        "AX",
        "AL",
        "DZ",
        "AS",
        "US",
        "AD",
        "AI",
        "AO",
        "AQ",
        "AG",
        "AR",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "AC",
        "AE",
        "UN",
        "GB",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "IO",
        "VG",
        "BN",
        "BF",
        "BI",
        "BT",
        "BV",
        "TD",
        "CZ",
        "CL",
        "DK",
        "QO",
        "KP",
        "MP",
        "DG",
        "DM",
        "DO",
        "ET",
        "EC",
        "GQ",
        "ER",
        "AM",
        "EE",
        "IR",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "TF",
        "GF",
        "PF",
        "GA",
        "HT",
        "GM",
        "GH",
        "GY",
        "KZ",
        "DE",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "EH",
        "ZA",
        "GS",
        "KR",
        "SS",
        "GP",
        "GT",
        "GN",
        "GW",
        "KG",
        "HM",
        "IN",
        "HR",
        "CN",
        "ID",
        "JO",
        "IE",
        "IS",
        "ES",
        "IT",
        "JE",
        "DJ",
        "CV",
        "KH",
        "CM",
        "CA",
        "IC",
        "BQ",
        "QA",
        "KY",
        "KE",
        "SH",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "CK",
        "KW",
        "CW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LI",
        "LT",
        "LB",
        "LY",
        "LU",
        "MG",
        "MO",
        "MK",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "IM",
        "CF",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "ME",
        "MZ",
        "EG",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "OM",
        "AF",
        "UZ",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "CX",
        "RW",
        "RO",
        "RU",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "BL",
        "SN",
        "MF",
        "PM",
        "KN",
        "LC",
        "VC",
        "RS",
        "EA",
        "SC",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "SJ",
        "LK",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SL",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "NC",
        "NZ",
        "TC",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "WF",
        "UY",
        "VU",
        "VA",
        "VE",
        "HU",
        "VN",
        "XA",
        "XB",
        "JM",
        "JP",
        "YE",
        "EU",
        "EZ",
        "IQ",
        "IL",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dünýä");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Demirgazyk Amerika");
    namesMap.put("005", "Günorta Amerika");
    namesMap.put("009", "Okeaniýa");
    namesMap.put("011", "Günbatar Afrika");
    namesMap.put("013", "Orta Amerika");
    namesMap.put("014", "Gündogar Afrika");
    namesMap.put("015", "Demirgazyk Afrika");
    namesMap.put("017", "Orta Afrika");
    namesMap.put("018", "Afrikanyň günorta sebitleri");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerikanyň demirgazyk ýurtlary");
    namesMap.put("029", "Karib basseýni");
    namesMap.put("030", "Gündogar Aziýa");
    namesMap.put("034", "Günorta Aziýa");
    namesMap.put("035", "Günorta-gündogar Aziýa");
    namesMap.put("039", "Günorta Ýewropa");
    namesMap.put("053", "Awstralaziýa");
    namesMap.put("054", "Melaneziýa");
    namesMap.put("057", "Mikroneziýa sebti");
    namesMap.put("061", "Polineziýa");
    namesMap.put("142", "Aziýa");
    namesMap.put("143", "Merkezi Aziýa");
    namesMap.put("145", "Günbatar Aziýa");
    namesMap.put("150", "Ýewropa");
    namesMap.put("151", "Gündogar Ýewropa");
    namesMap.put("154", "Demirgazyk Ýewropa");
    namesMap.put("155", "Günbatar Ýewropa");
    namesMap.put("202", "Saharadan aşakdaky Afrika");
    namesMap.put("419", "Latyn Amerikasy");
    namesMap.put("AC", "Beýgeliş adasy");
    namesMap.put("AE", "Birleşen Arap Emirlikleri");
    namesMap.put("AF", "Owganystan");
    namesMap.put("AG", "Antigua we Barbuda");
    namesMap.put("AI", "Angilýa");
    namesMap.put("AL", "Albaniýa");
    namesMap.put("AM", "Ermenistan");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AS", "Amerikan Samoasy");
    namesMap.put("AT", "Awstriýa");
    namesMap.put("AU", "Awstraliýa");
    namesMap.put("AX", "Aland adalary");
    namesMap.put("AZ", "Azerbaýjan");
    namesMap.put("BA", "Bosniýa we Gersegowina");
    namesMap.put("BD", "Bangladeş");
    namesMap.put("BE", "Belgiýa");
    namesMap.put("BF", "Burkina-Faso");
    namesMap.put("BG", "Bolgariýa");
    namesMap.put("BH", "Bahreýn");
    namesMap.put("BL", "Sen-Bartelemi");
    namesMap.put("BN", "Bruneý");
    namesMap.put("BO", "Boliwiýa");
    namesMap.put("BQ", "Karib Niderlandlary");
    namesMap.put("BR", "Braziliýa");
    namesMap.put("BS", "Bagama adalary");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Buwe adasy");
    namesMap.put("BZ", "Beliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokos (Kiling) adalary");
    namesMap.put("CD", "Kongo - Kinşasa");
    namesMap.put("CF", "Merkezi Afrika Respublikasy");
    namesMap.put("CG", "Kongo - Brazzawil");
    namesMap.put("CH", "Şweýsariýa");
    namesMap.put("CI", "Kot-d’Iwuar");
    namesMap.put("CK", "Kuk adalary");
    namesMap.put("CL", "Çili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Hytaý");
    namesMap.put("CO", "Kolumbiýa");
    namesMap.put("CP", "Klipperton adasy");
    namesMap.put("CR", "Kosta-Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kabo-Werde");
    namesMap.put("CW", "Kýurasao");
    namesMap.put("CX", "Roždestwo adasy");
    namesMap.put("CY", "Kipr");
    namesMap.put("CZ", "Çehiýa");
    namesMap.put("DE", "Germaniýa");
    namesMap.put("DG", "Diýego-Garsiýa");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Daniýa");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikan Respublikasy");
    namesMap.put("DZ", "Alžir");
    namesMap.put("EA", "Seuta we Melilýa");
    namesMap.put("EC", "Ekwador");
    namesMap.put("EE", "Estoniýa");
    namesMap.put("EG", "Müsür");
    namesMap.put("EH", "Günbatar Sahara");
    namesMap.put("ER", "Eritreýa");
    namesMap.put("ES", "Ispaniýa");
    namesMap.put("ET", "Efiopiýa");
    namesMap.put("EU", "Ýewropa Bileleşigi");
    namesMap.put("EZ", "Ýewro sebiti");
    namesMap.put("FI", "Finlýandiýa");
    namesMap.put("FK", "Folklend adalary");
    namesMap.put("FM", "Mikroneziýa");
    namesMap.put("FO", "Farer adalary");
    namesMap.put("FR", "Fransiýa");
    namesMap.put("GB", "Birleşen Patyşalyk");
    namesMap.put("GE", "Gruziýa");
    namesMap.put("GF", "Fransuz Gwianasy");
    namesMap.put("GG", "Gernsi");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Grenlandiýa");
    namesMap.put("GM", "Gambiýa");
    namesMap.put("GN", "Gwineýa");
    namesMap.put("GP", "Gwadelupa");
    namesMap.put("GQ", "Ekwatorial Gwineýa");
    namesMap.put("GR", "Gresiýa");
    namesMap.put("GS", "Günorta Georgiýa we Günorta Sendwiç adasy");
    namesMap.put("GT", "Gwatemala");
    namesMap.put("GW", "Gwineýa-Bisau");
    namesMap.put("GY", "Gaýana");
    namesMap.put("HK", "Gonkong AAS Hytaý");
    namesMap.put("HM", "Herd we Makdonald adalary");
    namesMap.put("HN", "Gonduras");
    namesMap.put("HR", "Horwatiýa");
    namesMap.put("HT", "Gaiti");
    namesMap.put("HU", "Wengriýa");
    namesMap.put("IC", "Kanar adalary");
    namesMap.put("ID", "Indoneziýa");
    namesMap.put("IE", "Irlandiýa");
    namesMap.put("IL", "Ysraýyl");
    namesMap.put("IM", "Men adasy");
    namesMap.put("IN", "Hindistan");
    namesMap.put("IO", "Britaniýanyň Hindi okeanyndaky territoriýalary");
    namesMap.put("IQ", "Yrak");
    namesMap.put("IR", "Eýran");
    namesMap.put("IS", "Islandiýa");
    namesMap.put("IT", "Italiýa");
    namesMap.put("JE", "Jersi");
    namesMap.put("JM", "Ýamaýka");
    namesMap.put("JO", "Iordaniýa");
    namesMap.put("JP", "Ýaponiýa");
    namesMap.put("KE", "Keniýa");
    namesMap.put("KG", "Gyrgyzystan");
    namesMap.put("KH", "Kamboja");
    namesMap.put("KM", "Komor adalary");
    namesMap.put("KN", "Sent-Kits we Newis");
    namesMap.put("KP", "Demirgazyk Koreýa");
    namesMap.put("KR", "Günorta Koreýa");
    namesMap.put("KW", "Kuweýt");
    namesMap.put("KY", "Kaýman adalary");
    namesMap.put("KZ", "Gazagystan");
    namesMap.put("LB", "Liwan");
    namesMap.put("LC", "Sent-Lýusiýa");
    namesMap.put("LI", "Lihtenşteýn");
    namesMap.put("LK", "Şri-Lanka");
    namesMap.put("LR", "Liberiýa");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwa");
    namesMap.put("LU", "Lýuksemburg");
    namesMap.put("LV", "Latwiýa");
    namesMap.put("LY", "Liwiýa");
    namesMap.put("MA", "Marokko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldowa");
    namesMap.put("MF", "Sen-Marten");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Marşall adalary");
    namesMap.put("MK", "Makedoniýa");
    namesMap.put("MM", "Mýanma (Burma)");
    namesMap.put("MN", "Mongoliýa");
    namesMap.put("MO", "Makau AAS Hytaý");
    namesMap.put("MP", "Demirgazyk Mariana adalary");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MR", "Mawritaniýa");
    namesMap.put("MS", "Monserrat");
    namesMap.put("MU", "Mawrikiý");
    namesMap.put("MV", "Maldiwler");
    namesMap.put("MX", "Meksika");
    namesMap.put("MY", "Malaýziýa");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibiýa");
    namesMap.put("NC", "Täze Kaledoniýa");
    namesMap.put("NF", "Norfolk adasy");
    namesMap.put("NG", "Nigeriýa");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Niderlandlar");
    namesMap.put("NO", "Norwegiýa");
    namesMap.put("NZ", "Täze Zelandiýa");
    namesMap.put("PF", "Fransuz Polineziýasy");
    namesMap.put("PG", "Papua - Täze Gwineýa");
    namesMap.put("PH", "Filippinler");
    namesMap.put("PL", "Polşa");
    namesMap.put("PM", "Sen-Pýer we Mikelon");
    namesMap.put("PN", "Pitkern adalary");
    namesMap.put("PR", "Puerto-Riko");
    namesMap.put("PS", "Palestina territoriýasy");
    namesMap.put("PT", "Portugaliýa");
    namesMap.put("PY", "Paragwaý");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Daşky Okeaniýa");
    namesMap.put("RE", "Reýunýon");
    namesMap.put("RO", "Rumyniýa");
    namesMap.put("RS", "Serbiýa");
    namesMap.put("RU", "Russiýa");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saud Arabystany");
    namesMap.put("SB", "Solomon adalary");
    namesMap.put("SC", "Seýşel adalary");
    namesMap.put("SE", "Şwesiýa");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Keramatly Ýelena adasy");
    namesMap.put("SI", "Sloweniýa");
    namesMap.put("SJ", "Şpisbergen we Ýan-Maýen");
    namesMap.put("SK", "Slowakiýa");
    namesMap.put("SL", "Sýerra-Leone");
    namesMap.put("SM", "San-Marino");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinam");
    namesMap.put("SS", "Günorta Sudan");
    namesMap.put("ST", "San-Tome we Prinsipi");
    namesMap.put("SV", "Salwador");
    namesMap.put("SX", "Sint-Marten");
    namesMap.put("SY", "Siriýa");
    namesMap.put("SZ", "Swazilend");
    namesMap.put("TA", "Tristan-da-Kunýa");
    namesMap.put("TC", "Terks we Kaýkos adalary");
    namesMap.put("TD", "Çad");
    namesMap.put("TF", "Fransuz günorta territoriýalary");
    namesMap.put("TH", "Taýland");
    namesMap.put("TJ", "Täjigistan");
    namesMap.put("TM", "Türkmenistan");
    namesMap.put("TN", "Tunis");
    namesMap.put("TR", "Türkiýe");
    namesMap.put("TT", "Trinidad we Tobago");
    namesMap.put("TV", "Tuwalu");
    namesMap.put("TW", "Taýwan");
    namesMap.put("TZ", "Tanzaniýa");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "ABŞ-nyň daşarky adalary");
    namesMap.put("UN", "Birleşen Milletler Guramasy");
    namesMap.put("US", "Amerikanyň Birleşen Ştatlary");
    namesMap.put("UY", "Urugwaý");
    namesMap.put("UZ", "Özbegistan");
    namesMap.put("VA", "Watikan");
    namesMap.put("VC", "Sent-Winsent we Grenadinler");
    namesMap.put("VE", "Wenesuela");
    namesMap.put("VG", "Britan Wirgin adalary");
    namesMap.put("VI", "ABŞ-nyň Wirgin adalary");
    namesMap.put("VN", "Wýetnam");
    namesMap.put("VU", "Wanuatu");
    namesMap.put("WF", "Uollis we Futuna");
    namesMap.put("XK", "Kosowo");
    namesMap.put("YE", "Ýemen");
    namesMap.put("YT", "Maýotta");
    namesMap.put("ZA", "Günorta Afrika");
    namesMap.put("ZM", "Zambiýa");
    namesMap.put("ZZ", "Näbelli sebit");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dünýä",
        "002": "Afrika",
        "003": "Demirgazyk Amerika",
        "005": "Günorta Amerika",
        "009": "Okeaniýa",
        "011": "Günbatar Afrika",
        "013": "Orta Amerika",
        "014": "Gündogar Afrika",
        "015": "Demirgazyk Afrika",
        "017": "Orta Afrika",
        "018": "Afrikanyň günorta sebitleri",
        "019": "Amerika",
        "021": "Amerikanyň demirgazyk ýurtlary",
        "029": "Karib basseýni",
        "030": "Gündogar Aziýa",
        "034": "Günorta Aziýa",
        "035": "Günorta-gündogar Aziýa",
        "039": "Günorta Ýewropa",
        "053": "Awstralaziýa",
        "054": "Melaneziýa",
        "057": "Mikroneziýa sebti",
        "061": "Polineziýa",
        "142": "Aziýa",
        "143": "Merkezi Aziýa",
        "145": "Günbatar Aziýa",
        "150": "Ýewropa",
        "151": "Gündogar Ýewropa",
        "154": "Demirgazyk Ýewropa",
        "155": "Günbatar Ýewropa",
        "202": "Saharadan aşakdaky Afrika",
        "419": "Latyn Amerikasy",
        "AC": "Beýgeliş adasy",
        "AE": "Birleşen Arap Emirlikleri",
        "AF": "Owganystan",
        "AG": "Antigua we Barbuda",
        "AI": "Angilýa",
        "AL": "Albaniýa",
        "AM": "Ermenistan",
        "AQ": "Antarktika",
        "AS": "Amerikan Samoasy",
        "AT": "Awstriýa",
        "AU": "Awstraliýa",
        "AX": "Aland adalary",
        "AZ": "Azerbaýjan",
        "BA": "Bosniýa we Gersegowina",
        "BD": "Bangladeş",
        "BE": "Belgiýa",
        "BF": "Burkina-Faso",
        "BG": "Bolgariýa",
        "BH": "Bahreýn",
        "BL": "Sen-Bartelemi",
        "BN": "Bruneý",
        "BO": "Boliwiýa",
        "BQ": "Karib Niderlandlary",
        "BR": "Braziliýa",
        "BS": "Bagama adalary",
        "BT": "Butan",
        "BV": "Buwe adasy",
        "BZ": "Beliz",
        "CA": "Kanada",
        "CC": "Kokos (Kiling) adalary",
        "CD": "Kongo - Kinşasa",
        "CF": "Merkezi Afrika Respublikasy",
        "CG": "Kongo - Brazzawil",
        "CH": "Şweýsariýa",
        "CI": "Kot-d’Iwuar",
        "CK": "Kuk adalary",
        "CL": "Çili",
        "CM": "Kamerun",
        "CN": "Hytaý",
        "CO": "Kolumbiýa",
        "CP": "Klipperton adasy",
        "CR": "Kosta-Rika",
        "CU": "Kuba",
        "CV": "Kabo-Werde",
        "CW": "Kýurasao",
        "CX": "Roždestwo adasy",
        "CY": "Kipr",
        "CZ": "Çehiýa",
        "DE": "Germaniýa",
        "DG": "Diýego-Garsiýa",
        "DJ": "Jibuti",
        "DK": "Daniýa",
        "DM": "Dominika",
        "DO": "Dominikan Respublikasy",
        "DZ": "Alžir",
        "EA": "Seuta we Melilýa",
        "EC": "Ekwador",
        "EE": "Estoniýa",
        "EG": "Müsür",
        "EH": "Günbatar Sahara",
        "ER": "Eritreýa",
        "ES": "Ispaniýa",
        "ET": "Efiopiýa",
        "EU": "Ýewropa Bileleşigi",
        "EZ": "Ýewro sebiti",
        "FI": "Finlýandiýa",
        "FK": "Folklend adalary",
        "FM": "Mikroneziýa",
        "FO": "Farer adalary",
        "FR": "Fransiýa",
        "GB": "Birleşen Patyşalyk",
        "GE": "Gruziýa",
        "GF": "Fransuz Gwianasy",
        "GG": "Gernsi",
        "GH": "Gana",
        "GL": "Grenlandiýa",
        "GM": "Gambiýa",
        "GN": "Gwineýa",
        "GP": "Gwadelupa",
        "GQ": "Ekwatorial Gwineýa",
        "GR": "Gresiýa",
        "GS": "Günorta Georgiýa we Günorta Sendwiç adasy",
        "GT": "Gwatemala",
        "GW": "Gwineýa-Bisau",
        "GY": "Gaýana",
        "HK": "Gonkong AAS Hytaý",
        "HM": "Herd we Makdonald adalary",
        "HN": "Gonduras",
        "HR": "Horwatiýa",
        "HT": "Gaiti",
        "HU": "Wengriýa",
        "IC": "Kanar adalary",
        "ID": "Indoneziýa",
        "IE": "Irlandiýa",
        "IL": "Ysraýyl",
        "IM": "Men adasy",
        "IN": "Hindistan",
        "IO": "Britaniýanyň Hindi okeanyndaky territoriýalary",
        "IQ": "Yrak",
        "IR": "Eýran",
        "IS": "Islandiýa",
        "IT": "Italiýa",
        "JE": "Jersi",
        "JM": "Ýamaýka",
        "JO": "Iordaniýa",
        "JP": "Ýaponiýa",
        "KE": "Keniýa",
        "KG": "Gyrgyzystan",
        "KH": "Kamboja",
        "KM": "Komor adalary",
        "KN": "Sent-Kits we Newis",
        "KP": "Demirgazyk Koreýa",
        "KR": "Günorta Koreýa",
        "KW": "Kuweýt",
        "KY": "Kaýman adalary",
        "KZ": "Gazagystan",
        "LB": "Liwan",
        "LC": "Sent-Lýusiýa",
        "LI": "Lihtenşteýn",
        "LK": "Şri-Lanka",
        "LR": "Liberiýa",
        "LS": "Lesoto",
        "LT": "Litwa",
        "LU": "Lýuksemburg",
        "LV": "Latwiýa",
        "LY": "Liwiýa",
        "MA": "Marokko",
        "MC": "Monako",
        "MD": "Moldowa",
        "MF": "Sen-Marten",
        "MG": "Madagaskar",
        "MH": "Marşall adalary",
        "MK": "Makedoniýa",
        "MM": "Mýanma (Burma)",
        "MN": "Mongoliýa",
        "MO": "Makau AAS Hytaý",
        "MP": "Demirgazyk Mariana adalary",
        "MQ": "Martinika",
        "MR": "Mawritaniýa",
        "MS": "Monserrat",
        "MU": "Mawrikiý",
        "MV": "Maldiwler",
        "MX": "Meksika",
        "MY": "Malaýziýa",
        "MZ": "Mozambik",
        "NA": "Namibiýa",
        "NC": "Täze Kaledoniýa",
        "NF": "Norfolk adasy",
        "NG": "Nigeriýa",
        "NI": "Nikaragua",
        "NL": "Niderlandlar",
        "NO": "Norwegiýa",
        "NZ": "Täze Zelandiýa",
        "PF": "Fransuz Polineziýasy",
        "PG": "Papua - Täze Gwineýa",
        "PH": "Filippinler",
        "PL": "Polşa",
        "PM": "Sen-Pýer we Mikelon",
        "PN": "Pitkern adalary",
        "PR": "Puerto-Riko",
        "PS": "Palestina territoriýasy",
        "PT": "Portugaliýa",
        "PY": "Paragwaý",
        "QA": "Katar",
        "QO": "Daşky Okeaniýa",
        "RE": "Reýunýon",
        "RO": "Rumyniýa",
        "RS": "Serbiýa",
        "RU": "Russiýa",
        "RW": "Ruanda",
        "SA": "Saud Arabystany",
        "SB": "Solomon adalary",
        "SC": "Seýşel adalary",
        "SE": "Şwesiýa",
        "SG": "Singapur",
        "SH": "Keramatly Ýelena adasy",
        "SI": "Sloweniýa",
        "SJ": "Şpisbergen we Ýan-Maýen",
        "SK": "Slowakiýa",
        "SL": "Sýerra-Leone",
        "SM": "San-Marino",
        "SO": "Somali",
        "SR": "Surinam",
        "SS": "Günorta Sudan",
        "ST": "San-Tome we Prinsipi",
        "SV": "Salwador",
        "SX": "Sint-Marten",
        "SY": "Siriýa",
        "SZ": "Swazilend",
        "TA": "Tristan-da-Kunýa",
        "TC": "Terks we Kaýkos adalary",
        "TD": "Çad",
        "TF": "Fransuz günorta territoriýalary",
        "TH": "Taýland",
        "TJ": "Täjigistan",
        "TM": "Türkmenistan",
        "TN": "Tunis",
        "TR": "Türkiýe",
        "TT": "Trinidad we Tobago",
        "TV": "Tuwalu",
        "TW": "Taýwan",
        "TZ": "Tanzaniýa",
        "UA": "Ukraina",
        "UM": "ABŞ-nyň daşarky adalary",
        "UN": "Birleşen Milletler Guramasy",
        "US": "Amerikanyň Birleşen Ştatlary",
        "UY": "Urugwaý",
        "UZ": "Özbegistan",
        "VA": "Watikan",
        "VC": "Sent-Winsent we Grenadinler",
        "VE": "Wenesuela",
        "VG": "Britan Wirgin adalary",
        "VI": "ABŞ-nyň Wirgin adalary",
        "VN": "Wýetnam",
        "VU": "Wanuatu",
        "WF": "Uollis we Futuna",
        "XK": "Kosowo",
        "YE": "Ýemen",
        "YT": "Maýotta",
        "ZA": "Günorta Afrika",
        "ZM": "Zambiýa",
        "ZZ": "Näbelli sebit"
    };
  }-*/;
}
