/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapperupgrade;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public abstract class WrapperUpgradeDomainObject {
    final String name;
    private final Property<String> repo;
    private final Property<String> dir;
    private final Property<String> baseBranch;
    private final Options options;

    @Inject
    public WrapperUpgradeDomainObject(String name, ObjectFactory objects) {
        this.name = name;
        this.repo = objects.property(String.class);
        this.dir = objects.property(String.class).convention((Object)".");
        this.baseBranch = objects.property(String.class).convention((Object)"main");
        this.options = (Options)objects.newInstance(Options.class, new Object[0]);
    }

    public Property<String> getRepo() {
        return this.repo;
    }

    public Property<String> getDir() {
        return this.dir;
    }

    public Property<String> getBaseBranch() {
        return this.baseBranch;
    }

    public Options getOptions() {
        return this.options;
    }

    public void options(Action<Options> action) {
        action.execute((Object)this.options);
    }

    public static class Options {
        private final ListProperty<String> gitCommitExtraArgs;
        private final Property<Boolean> allowPreRelease;
        private final ListProperty<String> labels;
        private final ListProperty<String> assignees;
        private final ListProperty<String> reviewers;
        private final Property<Boolean> recreateClosedPullRequest;

        @Inject
        public Options(ObjectFactory objects) {
            this.gitCommitExtraArgs = objects.listProperty(String.class);
            this.allowPreRelease = objects.property(Boolean.class);
            this.labels = objects.listProperty(String.class);
            this.assignees = objects.listProperty(String.class);
            this.reviewers = objects.listProperty(String.class);
            this.recreateClosedPullRequest = objects.property(Boolean.class);
        }

        public ListProperty<String> getGitCommitExtraArgs() {
            return this.gitCommitExtraArgs;
        }

        public Property<Boolean> getAllowPreRelease() {
            return this.allowPreRelease;
        }

        public ListProperty<String> getAssignees() {
            return this.assignees;
        }

        public ListProperty<String> getReviewers() {
            return this.reviewers;
        }

        public ListProperty<String> getLabels() {
            return this.labels;
        }

        public Property<Boolean> getRecreateClosedPullRequest() {
            return this.recreateClosedPullRequest;
        }
    }
}

