/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.toolchains.foojay;

import java.net.URI;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainDownload;
import org.gradle.jvm.toolchain.JavaToolchainRequest;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.platform.Architecture;
import org.gradle.platform.BuildPlatform;
import org.gradle.platform.OperatingSystem;
import org.gradle.toolchains.foojay.FoojayApi;
import org.gradle.toolchains.foojay.FoojayToolchainResolver;
import org.gradle.toolchains.foojay.Links;
import org.gradle.toolchains.foojay.Package;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gradle/toolchains/foojay/FoojayToolchainResolver;", "Lorg/gradle/jvm/toolchain/JavaToolchainResolver;", "()V", "api", "Lorg/gradle/toolchains/foojay/FoojayApi;", "resolve", "Ljava/util/Optional;", "Lorg/gradle/jvm/toolchain/JavaToolchainDownload;", "request", "Lorg/gradle/jvm/toolchain/JavaToolchainRequest;", "foojay-resolver"})
public abstract class FoojayToolchainResolver
implements JavaToolchainResolver {
    @NotNull
    private final FoojayApi api = new FoojayApi();

    @NotNull
    public Optional<JavaToolchainDownload> resolve(@NotNull JavaToolchainRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        JavaToolchainSpec javaToolchainSpec = request.getJavaToolchainSpec();
        Intrinsics.checkNotNullExpressionValue((Object)javaToolchainSpec, (String)"request.javaToolchainSpec");
        JavaToolchainSpec spec = javaToolchainSpec;
        BuildPlatform buildPlatform = request.getBuildPlatform();
        Intrinsics.checkNotNullExpressionValue((Object)buildPlatform, (String)"request.buildPlatform");
        BuildPlatform platform = buildPlatform;
        Object object = spec.getLanguageVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"spec.languageVersion.get()");
        JavaLanguageVersion javaLanguageVersion = (JavaLanguageVersion)object;
        Object object2 = spec.getVendor().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"spec.vendor.get()");
        JvmVendorSpec jvmVendorSpec = (JvmVendorSpec)object2;
        Object object3 = spec.getImplementation().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"spec.implementation.get()");
        JvmImplementation jvmImplementation = (JvmImplementation)object3;
        OperatingSystem operatingSystem = platform.getOperatingSystem();
        Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"platform.operatingSystem");
        Architecture architecture = platform.getArchitecture();
        Intrinsics.checkNotNullExpressionValue((Object)architecture, (String)"platform.architecture");
        Package package_ = this.api.toPackage(javaLanguageVersion, jvmVendorSpec, jvmImplementation, operatingSystem, architecture);
        Links links = package_ != null ? package_.getLinks() : null;
        URI uri = this.api.toUri(links);
        Optional<JavaToolchainDownload> optional = Optional.ofNullable(uri).map(resolve.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(uri).map(Java\u2026olchainDownload::fromUri)");
        return optional;
    }
}

