/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.toolchains.foojay;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.platform.Architecture;
import org.gradle.platform.OperatingSystem;
import org.gradle.toolchains.foojay.Package;
import org.gradle.toolchains.foojay.PackagesKt;
import org.gradle.toolchains.foojay.PackagesResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0019\u001a\u00020\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\u00a8\u0006\u001a"}, d2={"architectures32Bit", "", "", "getArchitectures32Bit", "()Ljava/util/Set;", "architectures64Bit", "getArchitectures64Bit", "architecturesArm64Bit", "getArchitecturesArm64Bit", "handledArchiveTypes", "getHandledArchiveTypes", "hasHandledArchiveType", "", "p", "Lorg/gradle/toolchains/foojay/Package;", "map", "os", "Lorg/gradle/platform/OperatingSystem;", "match", "packages", "", "architecture", "Lorg/gradle/platform/Architecture;", "matches", "parsePackages", "json", "foojay-resolver"})
@SourceDebugExtension(value={"SMAP\npackages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 packages.kt\norg/gradle/toolchains/foojay/PackagesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n766#2:66\n857#2,2:67\n766#2:69\n857#2,2:70\n*S KotlinDebug\n*F\n+ 1 packages.kt\norg/gradle/toolchains/foojay/PackagesKt\n*L\n19#1:66\n19#1:67,2\n20#1:69\n20#1:70,2\n*E\n"})
public final class PackagesKt {
    @NotNull
    private static final Set<String> architectures32Bit;
    @NotNull
    private static final Set<String> architectures64Bit;
    @NotNull
    private static final Set<String> architecturesArm64Bit;
    @NotNull
    private static final Set<String> handledArchiveTypes;

    @NotNull
    public static final Set<String> getArchitectures32Bit() {
        return architectures32Bit;
    }

    @NotNull
    public static final Set<String> getArchitectures64Bit() {
        return architectures64Bit;
    }

    @NotNull
    public static final Set<String> getArchitecturesArm64Bit() {
        return architecturesArm64Bit;
    }

    @NotNull
    public static final Set<String> getHandledArchiveTypes() {
        return handledArchiveTypes;
    }

    @NotNull
    public static final List<Package> parsePackages(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ((PackagesResult)new Gson().fromJson(json, PackagesResult.class)).getResult();
    }

    @Nullable
    public static final Package match(@NotNull List<Package> packages, @NotNull Architecture architecture) {
        Package p;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        Iterable $this$filter$iv = packages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p = (Package)element$iv$iv;
            boolean bl = false;
            if (!PackagesKt.matches(p, architecture)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p = (Package)element$iv$iv;
            boolean bl = false;
            if (!PackagesKt.hasHandledArchiveType(p)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Function1[] function1Array = new Function1[]{(Function1)match.candidates.3.INSTANCE, (Function1)match.candidates.4.INSTANCE};
        List candidates2 = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        return (Package)CollectionsKt.firstOrNull((List)candidates2);
    }

    @NotNull
    public static final String map(@NotNull OperatingSystem os) {
        String string;
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1: {
                string = "linux";
                break;
            }
            case 2: {
                string = "linux";
                break;
            }
            case 3: {
                string = "windows";
                break;
            }
            case 4: {
                string = "macos";
                break;
            }
            case 5: {
                string = "solaris";
                break;
            }
            case 6: {
                string = "linux";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private static final boolean matches(Package p, Architecture architecture) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$1[architecture.ordinal()]) {
            case 1: {
                bl = architectures32Bit.contains(p.getArchitecture());
                break;
            }
            case 2: {
                bl = architectures64Bit.contains(p.getArchitecture());
                break;
            }
            case 3: {
                bl = architecturesArm64Bit.contains(p.getArchitecture());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean hasHandledArchiveType(Package p) {
        return handledArchiveTypes.contains(p.getArchive_type());
    }

    static {
        Object[] objectArray = new String[]{"x32", "i386", "x86"};
        architectures32Bit = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"x64", "x86_64", "amd64", "ia64"};
        architectures64Bit = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"aarch64", "arm64"};
        architecturesArm64Bit = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"tar", "tar.gz", "tgz", "zip"};
        handledArchiveTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OperatingSystem.values().length];
            try {
                nArray[OperatingSystem.LINUX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.UNIX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.WINDOWS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.MAC_OS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.SOLARIS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperatingSystem.FREE_BSD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Architecture.values().length];
            try {
                nArray[Architecture.X86.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.AARCH64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

