/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.lang.reflect.Constructor;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.BaseJunitTestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.TestFrameworkProvider;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;

final class Junit5TestFrameworkStrategy
extends BaseJunitTestFrameworkStrategy {
    private final boolean isSpock2Used;

    public Junit5TestFrameworkStrategy(boolean isSpock2Used) {
        this.isSpock2Used = isSpock2Used;
    }

    @Override
    public TestFramework createRetrying(TestFrameworkTemplate template, TestFramework testFramework, TestNames failedTests, Set<String> testClassesSeenInCurrentRound) {
        DefaultTestFilter failedTestsFilter = this.testFilterFor(failedTests, this.isSpock2Used, template, testClassesSeenInCurrentRound);
        return Junit5TestFrameworkProvider.testFrameworkProvider(template, testFramework).testFrameworkFor(failedTestsFilter);
    }

    static class Junit5TestFrameworkProvider {
        Junit5TestFrameworkProvider() {
        }

        static TestFrameworkProvider testFrameworkProvider(TestFrameworkTemplate template, TestFramework testFramework) {
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("8.0")) {
                return new TestFrameworkProvider.ProviderForCurrentGradleVersion(testFramework);
            }
            return new ProviderForGradleOlderThanV8(template);
        }

        static class ProviderForGradleOlderThanV8
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            ProviderForGradleOlderThanV8(TestFrameworkTemplate template) {
                this.template = template;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter failedTestsFilter) {
                JUnitPlatformTestFramework retryTestFramework = ProviderForGradleOlderThanV8.newInstance(failedTestsFilter);
                ProviderForGradleOlderThanV8.copyOptions((JUnitPlatformOptions)this.template.task.getTestFramework().getOptions(), retryTestFramework.getOptions());
                return retryTestFramework;
            }

            private static JUnitPlatformTestFramework newInstance(DefaultTestFilter failedTestsFilter) {
                try {
                    Class<JUnitPlatformTestFramework> jUnitPlatformTestFrameworkClass = JUnitPlatformTestFramework.class;
                    Constructor constructor = jUnitPlatformTestFrameworkClass.getConstructor(DefaultTestFilter.class);
                    return (JUnitPlatformTestFramework)constructor.newInstance(failedTestsFilter);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            private static void copyOptions(JUnitPlatformOptions source, JUnitPlatformOptions target) {
                target.setIncludeEngines(source.getIncludeEngines());
                target.setExcludeEngines(source.getExcludeEngines());
                target.setIncludeTags(source.getIncludeTags());
                target.setExcludeTags(source.getExcludeTags());
            }
        }
    }
}

