/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import org.gradle.testretry.org.objectweb.asm.MethodVisitor;

final class TestNgClassVisitor
extends TestsReader.Visitor<ClassInfo> {
    private static final List<String> LIFECYCLE_ANNOTATION_DESCRIPTORS = Arrays.asList("Lorg/testng/annotations/BeforeClass;", "Lorg/testng/annotations/BeforeTest;", "Lorg/testng/annotations/AfterTest;", "Lorg/testng/annotations/AfterClass;");
    private String currentMethod;
    private final ClassInfo classInfo = new ClassInfo();
    private final TestNGMethodVisitor methodVisitor = new TestNGMethodVisitor();

    TestNgClassVisitor() {
    }

    @Override
    public ClassInfo getResult() {
        return this.classInfo;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.currentMethod = name;
        return this.methodVisitor;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classInfo.superClass = superName.replace('/', '.');
    }

    private final class TestNGTestDependsOnAnnotationVisitor
    extends AnnotationVisitor {
        public TestNGTestDependsOnAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(String name, Object value) {
            TestNgClassVisitor.this.classInfo.dependsOn.compute(TestNgClassVisitor.this.currentMethod, (m, acc) -> {
                if (acc == null) {
                    acc = new ArrayList<String>();
                }
                acc.add((String)value);
                return acc;
            });
            TestNgClassVisitor.this.classInfo.dependedOn.compute((String)value, (m, acc) -> {
                if (acc == null) {
                    acc = new ArrayList<String>();
                }
                acc.add(TestNgClassVisitor.this.currentMethod);
                return acc;
            });
        }
    }

    private final class TestNGTestAnnotationVisitor
    extends AnnotationVisitor {
        private final TestNGTestDependsOnAnnotationVisitor dependsOnAnnotationVisitor;

        public TestNGTestAnnotationVisitor() {
            super(458752);
            this.dependsOnAnnotationVisitor = new TestNGTestDependsOnAnnotationVisitor();
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if ("dependsOnMethods".equals(name)) {
                return this.dependsOnAnnotationVisitor;
            }
            return null;
        }
    }

    private final class TestNGMethodVisitor
    extends MethodVisitor {
        private final TestNGTestAnnotationVisitor testAnnotationVisitor;

        public TestNGMethodVisitor() {
            super(458752);
            this.testAnnotationVisitor = new TestNGTestAnnotationVisitor();
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.contains("org/testng/annotations/Test")) {
                return this.testAnnotationVisitor;
            }
            if (LIFECYCLE_ANNOTATION_DESCRIPTORS.contains(descriptor)) {
                TestNgClassVisitor.this.classInfo.lifecycleMethods.add(TestNgClassVisitor.this.currentMethod);
            }
            return null;
        }
    }

    static final class ClassInfo {
        private final Map<String, List<String>> dependsOn = new HashMap<String, List<String>>();
        private final Map<String, List<String>> dependedOn = new HashMap<String, List<String>>();
        private final Set<String> lifecycleMethods = new HashSet<String>();
        private String superClass;

        ClassInfo() {
        }

        Set<String> dependsOn(String method) {
            HashSet<String> dependentChain = new HashSet<String>();
            List<String> search = Collections.singletonList(method);
            while (!search.isEmpty()) {
                search = search.stream().flatMap(upstream -> this.dependsOn.getOrDefault(upstream, Collections.emptyList()).stream()).filter(upstream -> !dependentChain.contains(upstream)).collect(Collectors.toList());
                dependentChain.addAll(search);
            }
            search = Collections.singletonList(method);
            while (!search.isEmpty()) {
                search = search.stream().flatMap(downstream -> this.dependedOn.getOrDefault(downstream, Collections.emptyList()).stream()).filter(downstream -> !dependentChain.contains(downstream)).collect(Collectors.toList());
                dependentChain.addAll(search);
            }
            return dependentChain;
        }

        @Nullable
        public String getSuperClass() {
            return this.superClass;
        }

        public Set<String> getLifecycleMethods() {
            return this.lifecycleMethods;
        }
    }
}

