/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;
import org.gradle.testretry.internal.executer.TestFilterBuilder;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.BaseJunitTestFrameworkStrategy;

final class Junit5TestFrameworkStrategy
extends BaseJunitTestFrameworkStrategy {
    Junit5TestFrameworkStrategy() {
    }

    @Override
    public TestFramework createRetrying(TestFrameworkTemplate template, TestNames failedTests) {
        TestFilterBuilder filters = template.filterBuilder();
        this.addFilters(filters, template.testsReader, failedTests, false);
        JUnitPlatformTestFramework newFramework = new JUnitPlatformTestFramework(filters.build());
        this.copyTestOptions((JUnitPlatformOptions)template.task.getTestFramework().getOptions(), newFramework.getOptions());
        return newFramework;
    }

    private void copyTestOptions(JUnitPlatformOptions source, JUnitPlatformOptions target) {
        target.setIncludeEngines(source.getIncludeEngines());
        target.setExcludeEngines(source.getExcludeEngines());
        target.setIncludeTags(source.getIncludeTags());
        target.setExcludeTags(source.getExcludeTags());
    }
}

