/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class TestNames {
    private final Map<String, Set<String>> map = new HashMap<String, Set<String>>();

    public void add(String className, String testName) {
        this.map.computeIfAbsent(className, ignored -> new HashSet()).add(testName);
    }

    public void remove(String className, Predicate<? super String> predicate) {
        Set<String> testNames = this.map.get(className);
        if (testNames != null) {
            testNames.removeIf(predicate);
            if (testNames.isEmpty()) {
                this.map.remove(className);
            }
        }
    }

    public boolean remove(String className, String testName) {
        Set<String> testNames = this.map.get(className);
        if (testNames == null) {
            return false;
        }
        if (testNames.remove(testName)) {
            if (testNames.isEmpty()) {
                this.map.remove(className);
            }
            return true;
        }
        return false;
    }

    public Stream<Map.Entry<String, Set<String>>> stream() {
        return this.map.entrySet().stream();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.stream().mapToInt(s -> ((Set)s.getValue()).size()).sum();
    }
}

