/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer;

import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testretry.internal.config.TestRetryTaskExtensionAdapter;
import org.gradle.testretry.internal.executer.RetryTestResultProcessor;
import org.gradle.testretry.internal.executer.RoundResult;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import org.gradle.testretry.internal.filter.AnnotationInspectorImpl;
import org.gradle.testretry.internal.filter.RetryFilter;

public final class RetryTestExecuter
implements TestExecuter<JvmTestExecutionSpec> {
    private final TestRetryTaskExtensionAdapter extension;
    private final TestExecuter<JvmTestExecutionSpec> delegate;
    private final Test testTask;
    private final TestFrameworkTemplate frameworkTemplate;
    private RoundResult lastResult;

    public RetryTestExecuter(Test task, TestRetryTaskExtensionAdapter extension, TestExecuter<JvmTestExecutionSpec> delegate, Instantiator instantiator, ObjectFactory objectFactory, Set<File> testClassesDir, Set<File> resolvedClasspath) {
        this.extension = extension;
        this.delegate = delegate;
        this.testTask = task;
        this.frameworkTemplate = new TestFrameworkTemplate(this.testTask, instantiator, objectFactory, testClassesDir, resolvedClasspath);
    }

    public void execute(JvmTestExecutionSpec spec, TestResultProcessor testResultProcessor) {
        int maxRetries = this.extension.getMaxRetries();
        int maxFailures = this.extension.getMaxFailures();
        boolean failOnPassedAfterRetry = this.extension.getFailOnPassedAfterRetry();
        if (maxRetries <= 0) {
            this.delegate.execute((TestExecutionSpec)spec, testResultProcessor);
            return;
        }
        TestFrameworkStrategy testFrameworkStrategy = TestFrameworkStrategy.of(spec.getTestFramework());
        RetryFilter filter = new RetryFilter(new AnnotationInspectorImpl(this.frameworkTemplate.testsReader), this.extension.getIncludeClasses(), this.extension.getIncludeAnnotationClasses(), this.extension.getExcludeClasses(), this.extension.getExcludeAnnotationClasses());
        RetryTestResultProcessor retryTestResultProcessor = new RetryTestResultProcessor(testFrameworkStrategy, filter, this.frameworkTemplate.testsReader, testResultProcessor, maxFailures);
        int retryCount = 0;
        JvmTestExecutionSpec testExecutionSpec = spec;
        while (true) {
            RoundResult result;
            this.delegate.execute((TestExecutionSpec)testExecutionSpec, (TestResultProcessor)retryTestResultProcessor);
            this.lastResult = result = retryTestResultProcessor.getResult();
            if (this.extension.getSimulateNotRetryableTest() || !result.nonRetriedTests.isEmpty()) {
                this.testTask.setIgnoreFailures(true);
                break;
            }
            if (result.failedTests.isEmpty()) {
                if (retryCount <= 0 || result.hasRetryFilteredFailures || failOnPassedAfterRetry) break;
                this.testTask.setIgnoreFailures(true);
                break;
            }
            if (result.lastRound) break;
            TestFramework retryTestFramework = testFrameworkStrategy.createRetrying(this.frameworkTemplate, result.failedTests);
            testExecutionSpec = this.createRetryJvmExecutionSpec(spec, retryTestFramework);
            retryTestResultProcessor.reset(++retryCount == maxRetries);
        }
    }

    public void failWithNonRetriedTestsIfAny() {
        if (this.extension.getSimulateNotRetryableTest() || this.hasNonRetriedTests()) {
            throw new IllegalStateException("org.gradle.test-retry was unable to retry the following test methods, which is unexpected. Please file a bug report at https://github.com/gradle/test-retry-gradle-plugin/issues" + this.lastResult.nonRetriedTests.stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(methodName -> "   " + (String)entry.getKey() + "#" + methodName)).collect(Collectors.joining("\n", "\n", "\n")));
        }
    }

    private boolean hasNonRetriedTests() {
        return this.lastResult != null && !this.lastResult.nonRetriedTests.isEmpty();
    }

    private JvmTestExecutionSpec createRetryJvmExecutionSpec(JvmTestExecutionSpec spec, TestFramework retryTestFramework) {
        if (TestFrameworkStrategy.gradleVersionIsAtLeast("6.4")) {
            return new JvmTestExecutionSpec(retryTestFramework, spec.getClasspath(), spec.getModulePath(), spec.getCandidateClassFiles(), spec.isScanForTestClasses(), spec.getTestClassesDirs(), spec.getPath(), spec.getIdentityPath(), spec.getForkEvery(), spec.getJavaForkOptions(), spec.getMaxParallelForks(), spec.getPreviousFailedTestClasses());
        }
        return new JvmTestExecutionSpec(retryTestFramework, spec.getClasspath(), spec.getCandidateClassFiles(), spec.isScanForTestClasses(), spec.getTestClassesDirs(), spec.getPath(), spec.getIdentityPath(), spec.getForkEvery(), spec.getJavaForkOptions(), spec.getMaxParallelForks(), spec.getPreviousFailedTestClasses());
    }

    public void stopNow() {
        this.delegate.stopNow();
    }
}

