/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testretry.TestRetryTaskExtension;
import org.gradle.testretry.internal.config.DefaultTestRetryTaskExtension;
import org.gradle.testretry.internal.config.TestRetryTaskExtensionAdapter;
import org.gradle.testretry.internal.executer.RetryTestExecuter;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;

public final class TestTaskConfigurer {
    private TestTaskConfigurer() {
    }

    public static void configureTestTask(Test test, ObjectFactory objectFactory, ProviderFactory providerFactory) {
        VersionNumber gradleVersion = VersionNumber.parse((String)test.getProject().getGradle().getGradleVersion());
        TestRetryTaskExtension extension = (TestRetryTaskExtension)objectFactory.newInstance(DefaultTestRetryTaskExtension.class, new Object[0]);
        TestRetryTaskExtensionAdapter adapter = new TestRetryTaskExtensionAdapter(providerFactory, extension, gradleVersion);
        test.getInputs().property("retry.failOnPassedAfterRetry", adapter.getFailOnPassedAfterRetryInput());
        Provider<Boolean> isDeactivatedByTestDistributionPlugin = TestTaskConfigurer.shouldTestRetryPluginBeDeactivated(test, objectFactory, providerFactory, gradleVersion);
        test.getInputs().property("isDeactivatedByTestDistributionPlugin", isDeactivatedByTestDistributionPlugin);
        test.getExtensions().add(TestRetryTaskExtension.class, "retry", (Object)extension);
        test.doFirst((Action)new ConditionalTaskAction(isDeactivatedByTestDistributionPlugin, new InitTaskAction(adapter, objectFactory)));
        test.doLast((Action)new ConditionalTaskAction(isDeactivatedByTestDistributionPlugin, new FinalizeTaskAction()));
    }

    private static Provider<Boolean> shouldTestRetryPluginBeDeactivated(Test test, ObjectFactory objectFactory, ProviderFactory providerFactory, VersionNumber gradleVersion) {
        Provider result = providerFactory.provider(() -> TestTaskConfigurer.callShouldTestRetryPluginBeDeactivated(test));
        if (TestTaskConfigurer.supportsPropertyConventions(gradleVersion)) {
            Property property = objectFactory.property(Boolean.class).convention(result);
            if (TestTaskConfigurer.supportsFinalizeValueOnRead(gradleVersion)) {
                property.finalizeValueOnRead();
            }
            result = property;
        }
        return result;
    }

    public static boolean supportsPropertyConventions(VersionNumber gradleVersion) {
        return gradleVersion.compareTo(VersionNumber.parse((String)"5.1")) >= 0;
    }

    private static boolean supportsFinalizeValueOnRead(VersionNumber gradleVersion) {
        return gradleVersion.compareTo(VersionNumber.parse((String)"6.1")) >= 0;
    }

    private static boolean callShouldTestRetryPluginBeDeactivated(Test test) {
        Object distributionExtension = test.getExtensions().findByName("distribution");
        if (distributionExtension == null) {
            return false;
        }
        try {
            Method result = TestTaskConfigurer.makeAccessible(distributionExtension.getClass().getMethod("shouldTestRetryPluginBeDeactivated", new Class[0]));
            return (Boolean)TestTaskConfigurer.invoke(result, distributionExtension, new Object[0]);
        }
        catch (Exception e) {
            test.getLogger().warn("Failed to determine whether test-retry plugin should be deactivated from distribution extension", (Throwable)e);
            return false;
        }
    }

    private static RetryTestExecuter createRetryTestExecuter(Test task, TestRetryTaskExtensionAdapter extension, ObjectFactory objectFactory) {
        TestExecuter<JvmTestExecutionSpec> delegate = TestTaskConfigurer.getTestExecuter(task);
        Instantiator instantiator = (Instantiator)TestTaskConfigurer.invoke(TestTaskConfigurer.declaredMethod(AbstractTestTask.class, "getInstantiator", new Class[0]), task, new Object[0]);
        return new RetryTestExecuter(task, extension, delegate, instantiator, objectFactory, task.getTestClassesDirs().getFiles(), task.getClasspath().getFiles());
    }

    private static TestExecuter<JvmTestExecutionSpec> getTestExecuter(Test task) {
        return (TestExecuter)TestTaskConfigurer.invoke(TestTaskConfigurer.declaredMethod(Test.class, "createTestExecuter", new Class[0]), task, new Object[0]);
    }

    private static void setTestExecuter(Test task, RetryTestExecuter retryTestExecuter) {
        TestTaskConfigurer.invoke(TestTaskConfigurer.declaredMethod(Test.class, "setTestExecuter", TestExecuter.class), task, retryTestExecuter);
    }

    private static Method declaredMethod(Class<?> type, String methodName, Class<?> ... paramTypes) {
        try {
            return TestTaskConfigurer.makeAccessible(type.getDeclaredMethod(methodName, paramTypes));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    private static <T> T invoke(Method method, Object instance, Object ... args) {
        try {
            Object result;
            Object cast = result = method.invoke(instance, args);
            return (T)cast;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InitTaskAction
    implements Action<Test> {
        private final TestRetryTaskExtensionAdapter adapter;
        private final ObjectFactory objectFactory;

        public InitTaskAction(TestRetryTaskExtensionAdapter adapter, ObjectFactory objectFactory) {
            this.adapter = adapter;
            this.objectFactory = objectFactory;
        }

        public void execute(@NotNull Test task) {
            RetryTestExecuter retryTestExecuter = TestTaskConfigurer.createRetryTestExecuter(task, this.adapter, this.objectFactory);
            TestTaskConfigurer.setTestExecuter(task, retryTestExecuter);
        }
    }

    private static class FinalizeTaskAction
    implements Action<Test> {
        private FinalizeTaskAction() {
        }

        public void execute(@NotNull Test task) {
            TestExecuter testExecuter = TestTaskConfigurer.getTestExecuter(task);
            if (!(testExecuter instanceof RetryTestExecuter)) {
                throw new IllegalStateException("Unexpected test executer: " + testExecuter);
            }
            ((RetryTestExecuter)testExecuter).failWithNonRetriedTestsIfAny();
        }
    }

    private static class ConditionalTaskAction
    implements Action<Task> {
        private final Provider<Boolean> isDeactivatedByTestDistributionPlugin;
        private final Action<Test> delegate;

        public ConditionalTaskAction(Provider<Boolean> isDeactivatedByTestDistributionPlugin, Action<Test> delegate) {
            this.isDeactivatedByTestDistributionPlugin = isDeactivatedByTestDistributionPlugin;
            this.delegate = delegate;
        }

        public void execute(@NotNull Task task) {
            if (((Boolean)this.isDeactivatedByTestDistributionPlugin.get()).booleanValue()) {
                task.getLogger().info("Test execution via the test-retry plugin is deactivated. Retries are handled by the test-distribution plugin.");
            } else {
                this.delegate.execute((Object)((Test)task));
            }
        }
    }
}

