/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.Junit5TestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.JunitTestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.TestNgTestFrameworkStrategy;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.gradle.util.GradleVersion;

public interface TestFrameworkStrategy {
    public static TestFrameworkStrategy of(TestFramework testFramework) {
        if (testFramework instanceof JUnitTestFramework) {
            return new JunitTestFrameworkStrategy();
        }
        if (testFramework instanceof JUnitPlatformTestFramework) {
            return new Junit5TestFrameworkStrategy();
        }
        if (testFramework instanceof TestNGTestFramework) {
            return new TestNgTestFrameworkStrategy();
        }
        throw new UnsupportedOperationException("Unknown test framework: " + testFramework);
    }

    public static boolean gradleVersionIsAtLeast(String version) {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)version)) >= 0;
    }

    public boolean isLifecycleFailureTest(TestsReader var1, String var2, String var3);

    public TestFramework createRetrying(TestFrameworkTemplate var1, TestNames var2);
}

