/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import org.gradle.testretry.org.objectweb.asm.MethodVisitor;

final class SpockParameterClassVisitor
extends TestsReader.Visitor<Map<String, List<String>>> {
    private static final String SPOCK_PARAM_PATTERN = "#[\\p{L}\\d$_.()&&[^#\\s]]+";
    private static final String WILDCARD = ".*";
    private final Set<String> failedTestNames;
    private final TestsReader testsReader;
    private final SpockParameterMethodVisitor spockMethodVisitor = new SpockParameterMethodVisitor();
    private boolean isSpec;

    public SpockParameterClassVisitor(Set<String> testMethodName, TestsReader testsReader) {
        this.failedTestNames = testMethodName;
        this.testsReader = testsReader;
    }

    @Override
    public Map<String, List<String>> getResult() {
        if (!this.isSpec) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        this.spockMethodVisitor.annotationVisitor.testMethodPatterns.forEach(methodPattern -> {
            String methodPatternRegex = Arrays.stream(methodPattern.split(SPOCK_PARAM_PATTERN)).map(Pattern::quote).collect(Collectors.joining(WILDCARD)) + WILDCARD;
            this.failedTestNames.forEach(failedTestName -> {
                List matches = map.computeIfAbsent((String)failedTestName, ignored -> new ArrayList());
                if (methodPattern.equals(failedTestName) || failedTestName.matches(methodPatternRegex)) {
                    matches.add(methodPattern);
                }
            });
        });
        return map;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (superName != null) {
            if (superName.equals("spock/lang/Specification")) {
                this.isSpec = true;
            } else if (!superName.equals("java/lang/Object")) {
                this.testsReader.readClass(superName.replace('/', '.'), () -> this);
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.isSpec ? this.spockMethodVisitor : null;
    }

    private static final class SpockParameterMethodVisitor
    extends MethodVisitor {
        private final SpockFeatureMetadataAnnotationVisitor annotationVisitor = new SpockFeatureMetadataAnnotationVisitor();

        public SpockParameterMethodVisitor() {
            super(458752);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.contains("org/spockframework/runtime/model/FeatureMetadata")) {
                return this.annotationVisitor;
            }
            return null;
        }

        private static final class SpockFeatureMetadataAnnotationVisitor
        extends AnnotationVisitor {
            private final List<String> testMethodPatterns = new ArrayList<String>();

            public SpockFeatureMetadataAnnotationVisitor() {
                super(458752);
            }

            @Override
            public void visit(String name, Object value) {
                if ("name".equals(name)) {
                    this.testMethodPatterns.add((String)value);
                }
            }
        }
    }
}

