/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer.framework;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.testretry.internal.executer.TestFilterBuilder;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.JunitTestFrameworkStrategy;
import org.gradle.testretry.internal.executer.framework.SpockParameterClassVisitor;
import org.gradle.testretry.internal.executer.framework.SpockStepwiseClassVisitor;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import org.gradle.testretry.internal.testsreader.TestsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseJunitTestFrameworkStrategy
implements TestFrameworkStrategy {
    public static final Logger LOGGER = LoggerFactory.getLogger(JunitTestFrameworkStrategy.class);
    static final Set<String> ERROR_SYNTHETIC_TEST_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("classMethod", "executionError", "initializationError")));

    BaseJunitTestFrameworkStrategy() {
    }

    @Override
    public boolean isLifecycleFailureTest(TestsReader testsReader, String className, String testName) {
        return ERROR_SYNTHETIC_TEST_NAMES.contains(testName);
    }

    protected void addFilters(TestFilterBuilder filters, TestsReader testsReader, TestNames failedTests, boolean canRunParameterizedSpockMethods) {
        failedTests.stream().forEach(entry -> {
            String className = (String)entry.getKey();
            Set tests = (Set)entry.getValue();
            if (tests.stream().anyMatch(ERROR_SYNTHETIC_TEST_NAMES::contains)) {
                filters.clazz(className);
                return;
            }
            if (this.processSpockTest(filters, testsReader, canRunParameterizedSpockMethods, className, tests)) {
                return;
            }
            tests.forEach(name -> this.addPotentiallyParameterizedSuffixed(filters, className, (String)name));
        });
    }

    private boolean processSpockTest(TestFilterBuilder filters, TestsReader testsReader, boolean canRunParameterizedSpockMethods, String className, Set<String> tests) {
        if (BaseJunitTestFrameworkStrategy.isSpockStepwiseTest(testsReader, className)) {
            filters.clazz(className);
            return true;
        }
        try {
            Optional resultOpt = testsReader.readTestClassDirClass(className, () -> new SpockParameterClassVisitor(tests, testsReader));
            if (resultOpt.isPresent()) {
                Map result = (Map)resultOpt.get();
                if (result.isEmpty()) {
                    return false;
                }
                if (canRunParameterizedSpockMethods) {
                    result.forEach((test, matches) -> {
                        if (matches.isEmpty()) {
                            this.addPotentiallyParameterizedSuffixed(filters, className, (String)test);
                        } else {
                            matches.forEach(match -> filters.test(className, (String)match));
                        }
                    });
                } else {
                    boolean allLiteralMethodMatches = result.entrySet().stream().allMatch(e2 -> ((List)e2.getValue()).size() == 1 && ((String)((List)e2.getValue()).get(0)).equals(e2.getKey()));
                    if (allLiteralMethodMatches) {
                        tests.forEach(test -> filters.test(className, (String)test));
                    } else {
                        filters.clazz(className);
                    }
                }
                return true;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to determine if class " + className + " contains Spock @Unroll parameterizations", t);
        }
        return false;
    }

    private void addPotentiallyParameterizedSuffixed(TestFilterBuilder filters, String className, String name) {
        String strippedParameterName = name.replaceAll("(?:\\([^)]*?\\)|\\[[^]]*?])*$", "");
        filters.test(className, strippedParameterName);
        filters.test(className, name);
    }

    private static boolean isSpockStepwiseTest(TestsReader testsReader, String className) {
        try {
            return testsReader.readTestClassDirClass(className, SpockStepwiseClassVisitor::new).orElse(false);
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to determine if class " + className + " is a Spock @Stepwise test", t);
            return false;
        }
    }
}

