/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.executer;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.testretry.internal.executer.RoundResult;
import org.gradle.testretry.internal.executer.TestDescriptorImpl;
import org.gradle.testretry.internal.executer.TestNames;
import org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import org.gradle.testretry.internal.filter.RetryFilter;
import org.gradle.testretry.internal.testsreader.TestsReader;

final class RetryTestResultProcessor
implements TestResultProcessor {
    private final TestFrameworkStrategy testFrameworkStrategy;
    private final RetryFilter filter;
    private final TestsReader testsReader;
    private final TestResultProcessor delegate;
    private final int maxFailures;
    private boolean lastRetry;
    private boolean hasRetryFilteredFailures;
    private final Map<Object, TestDescriptorInternal> activeDescriptorsById = new HashMap<Object, TestDescriptorInternal>();
    private TestNames currentRoundFailedTests = new TestNames();
    private TestNames previousRoundFailedTests = new TestNames();
    private Object rootTestDescriptorId;

    RetryTestResultProcessor(TestFrameworkStrategy testFrameworkStrategy, RetryFilter filter, TestsReader testsReader, TestResultProcessor delegate, int maxFailures) {
        this.testFrameworkStrategy = testFrameworkStrategy;
        this.filter = filter;
        this.testsReader = testsReader;
        this.delegate = delegate;
        this.maxFailures = maxFailures;
    }

    public void started(TestDescriptorInternal descriptor, TestStartEvent testStartEvent) {
        if (this.rootTestDescriptorId == null) {
            this.rootTestDescriptorId = descriptor.getId();
            this.activeDescriptorsById.put(descriptor.getId(), descriptor);
            this.delegate.started(descriptor, testStartEvent);
        } else if (!descriptor.getId().equals(this.rootTestDescriptorId)) {
            this.activeDescriptorsById.put(descriptor.getId(), descriptor);
            this.delegate.started(descriptor, testStartEvent);
        }
    }

    public void completed(Object testId, TestCompleteEvent testCompleteEvent) {
        if (testId.equals(this.rootTestDescriptorId)) {
            if (!this.lastRun()) {
                return;
            }
        } else {
            TestDescriptorInternal descriptor = this.activeDescriptorsById.remove(testId);
            if (descriptor != null && descriptor.getClassName() != null) {
                String name;
                String className = descriptor.getClassName();
                boolean failedInPreviousRound = this.previousRoundFailedTests.remove(className, name = descriptor.getName());
                if (failedInPreviousRound && testCompleteEvent.getResultType() == TestResult.ResultType.SKIPPED) {
                    this.currentRoundFailedTests.add(className, name);
                }
                if (this.isClassDescriptor(descriptor)) {
                    this.previousRoundFailedTests.remove(className, n -> {
                        if (this.testFrameworkStrategy.isLifecycleFailureTest(this.testsReader, className, (String)n)) {
                            this.emitFakePassedEvent(descriptor, testCompleteEvent, (String)n);
                            return true;
                        }
                        return false;
                    });
                }
            }
        }
        this.delegate.completed(testId, testCompleteEvent);
    }

    private void emitFakePassedEvent(TestDescriptorInternal parent, TestCompleteEvent parentEvent, String name) {
        Object syntheticTestId = new Object();
        TestDescriptorImpl syntheticDescriptor = new TestDescriptorImpl(syntheticTestId, parent, name);
        long timestamp = parentEvent.getEndTime();
        this.delegate.started((TestDescriptorInternal)syntheticDescriptor, new TestStartEvent(timestamp, parent.getId()));
        this.delegate.completed(syntheticTestId, new TestCompleteEvent(timestamp));
    }

    private boolean isClassDescriptor(TestDescriptorInternal descriptor) {
        return descriptor.getClassName() != null && descriptor.getClassName().equals(descriptor.getName());
    }

    public void output(Object testId, TestOutputEvent testOutputEvent) {
        this.delegate.output(testId, testOutputEvent);
    }

    public void failure(Object testId, Throwable throwable) {
        String className;
        TestDescriptorInternal descriptor = this.activeDescriptorsById.get(testId);
        if (descriptor != null && (className = descriptor.getClassName()) != null) {
            if (this.filter.canRetry(className)) {
                this.currentRoundFailedTests.add(className, descriptor.getName());
            } else {
                this.hasRetryFilteredFailures = true;
            }
        }
        this.delegate.failure(testId, throwable);
    }

    private boolean lastRun() {
        return this.currentRoundFailedTests.isEmpty() || this.lastRetry || this.maxFailures > 0 && this.currentRoundFailedTests.size() >= this.maxFailures;
    }

    public RoundResult getResult() {
        return new RoundResult(this.currentRoundFailedTests, this.previousRoundFailedTests, this.lastRun(), this.hasRetryFilteredFailures);
    }

    public void reset(boolean lastRetry) {
        if (this.lastRun()) {
            throw new IllegalStateException("processor has completed");
        }
        this.lastRetry = lastRetry;
        this.previousRoundFailedTests = this.currentRoundFailedTests;
        this.currentRoundFailedTests = new TestNames();
        this.activeDescriptorsById.clear();
    }
}

