/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testretry.TestRetryTaskExtension;
import org.gradle.testretry.internal.config.DefaultTestRetryTaskExtension;
import org.gradle.testretry.internal.config.TestRetryTaskExtensionAdapter;
import org.gradle.testretry.internal.executer.RetryTestExecuter;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;

public final class TestTaskConfigurer {
    private TestTaskConfigurer() {
    }

    public static void configureTestTask(Test test, ObjectFactory objectFactory, ProviderFactory providerFactory) {
        VersionNumber gradleVersion = VersionNumber.parse((String)test.getProject().getGradle().getGradleVersion());
        TestRetryTaskExtension extension = (TestRetryTaskExtension)objectFactory.newInstance(DefaultTestRetryTaskExtension.class, new Object[0]);
        TestRetryTaskExtensionAdapter adapter = new TestRetryTaskExtensionAdapter(providerFactory, extension, gradleVersion);
        test.getInputs().property("retry.failOnPassedAfterRetry", adapter.getFailOnPassedAfterRetryInput());
        test.getExtensions().add(TestRetryTaskExtension.class, "retry", (Object)extension);
        test.doFirst((Action)new ConditionalTaskAction(new InitTaskAction(adapter, objectFactory)));
        test.doLast((Action)new ConditionalTaskAction(new FinalizeTaskAction()));
    }

    private static RetryTestExecuter createRetryTestExecuter(Test task, TestRetryTaskExtensionAdapter extension, ObjectFactory objectFactory) {
        TestExecuter<JvmTestExecutionSpec> delegate = TestTaskConfigurer.getTestExecuter(task);
        Instantiator instantiator = (Instantiator)TestTaskConfigurer.invoke(TestTaskConfigurer.declaredMethod(AbstractTestTask.class, "getInstantiator", new Class[0]), task, new Object[0]);
        return new RetryTestExecuter(task, extension, delegate, instantiator, objectFactory);
    }

    private static TestExecuter<JvmTestExecutionSpec> getTestExecuter(Test task) {
        return (TestExecuter)TestTaskConfigurer.invoke(TestTaskConfigurer.declaredMethod(Test.class, "createTestExecuter", new Class[0]), task, new Object[0]);
    }

    private static void setTestExecuter(Test task, RetryTestExecuter retryTestExecuter) {
        TestTaskConfigurer.invoke(TestTaskConfigurer.declaredMethod(Test.class, "setTestExecuter", TestExecuter.class), task, retryTestExecuter);
    }

    private static boolean supportsPropertyConventions(VersionNumber gradleVersion) {
        return gradleVersion.getMajor() == 5 ? gradleVersion.getMinor() >= 1 : gradleVersion.getMajor() > 5;
    }

    private static Method declaredMethod(Class<?> type, String methodName, Class<?> ... paramTypes) {
        try {
            return TestTaskConfigurer.makeAccessible(type.getDeclaredMethod(methodName, paramTypes));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method method(Class<?> type, String methodName, Class<?> ... paramTypes) {
        try {
            return TestTaskConfigurer.makeAccessible(type.getMethod(methodName, paramTypes));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method makeAccessible(Method method) {
        method.setAccessible(true);
        return method;
    }

    private static <T> T invoke(Method method, Object instance, Object ... args) {
        try {
            Object result;
            Object cast = result = method.invoke(instance, args);
            return (T)cast;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InitTaskAction
    implements Action<Test> {
        private final TestRetryTaskExtensionAdapter adapter;
        private final ObjectFactory objectFactory;

        public InitTaskAction(TestRetryTaskExtensionAdapter adapter, ObjectFactory objectFactory) {
            this.adapter = adapter;
            this.objectFactory = objectFactory;
        }

        public void execute(@NotNull Test task) {
            RetryTestExecuter retryTestExecuter = TestTaskConfigurer.createRetryTestExecuter(task, this.adapter, this.objectFactory);
            TestTaskConfigurer.setTestExecuter(task, retryTestExecuter);
        }
    }

    private static class FinalizeTaskAction
    implements Action<Test> {
        private FinalizeTaskAction() {
        }

        public void execute(@NotNull Test task) {
            TestExecuter testExecuter = TestTaskConfigurer.getTestExecuter(task);
            if (!(testExecuter instanceof RetryTestExecuter)) {
                throw new IllegalStateException("Unexpected test executer: " + testExecuter);
            }
            ((RetryTestExecuter)testExecuter).failWithNonRetriedTestsIfAny();
        }
    }

    private static class ConditionalTaskAction
    implements Action<Task> {
        private final Action<Test> delegate;

        public ConditionalTaskAction(Action<Test> delegate) {
            this.delegate = delegate;
        }

        public void execute(@NotNull Task task) {
            if (this.isDeactivatedByTestDistributionPlugin(task)) {
                task.getLogger().info("Test execution via the test-retry plugin is deactivated. Retries are handled by the test-distribution plugin.");
            } else {
                this.delegate.execute((Object)((Test)task));
            }
        }

        private boolean isDeactivatedByTestDistributionPlugin(Task task) {
            Object distributionExtension = task.getExtensions().findByName("distribution");
            if (distributionExtension == null) {
                return false;
            }
            try {
                return (Boolean)TestTaskConfigurer.invoke(TestTaskConfigurer.method(distributionExtension.getClass(), "shouldTestRetryPluginBeDeactivated", new Class[0]), distributionExtension, new Object[0]);
            }
            catch (Exception e) {
                task.getLogger().warn("Failed to determine whether test-retry plugin should be deactivated from distribution extension", (Throwable)e);
                return false;
            }
        }
    }
}

