/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testretry.internal.config;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.testretry.TestRetryTaskExtension;
import org.gradle.util.VersionNumber;

public final class TestRetryTaskExtensionAdapter {
    public static final String SIMULATE_NOT_RETRYABLE_PROPERTY = "__org_gradle_testretry_simulate_not_retryable";
    private static final int DEFAULT_MAX_RETRIES = 0;
    private static final int DEFAULT_MAX_FAILURES = 0;
    private static final boolean DEFAULT_FAIL_ON_PASSED_AFTER_RETRY = false;
    private final ProviderFactory providerFactory;
    private final TestRetryTaskExtension extension;
    private final boolean simulateNotRetryableTest;
    private boolean useConventions;

    public TestRetryTaskExtensionAdapter(ProviderFactory providerFactory, TestRetryTaskExtension extension, VersionNumber gradleVersion) {
        boolean gradle51OrLater;
        this.providerFactory = providerFactory;
        this.extension = extension;
        this.simulateNotRetryableTest = Boolean.getBoolean(SIMULATE_NOT_RETRYABLE_PROPERTY);
        this.useConventions = gradle51OrLater = gradleVersion.getMajor() == 5 ? gradleVersion.getMinor() >= 1 : gradleVersion.getMajor() > 5;
        this.initialize(extension, gradle51OrLater);
    }

    private void initialize(TestRetryTaskExtension extension, boolean gradle51OrLater) {
        if (gradle51OrLater) {
            extension.getMaxRetries().convention((Object)0);
            extension.getMaxFailures().convention((Object)0);
            extension.getFailOnPassedAfterRetry().convention((Object)false);
            extension.getFilter().getIncludeClasses().convention(Collections.emptySet());
            extension.getFilter().getIncludeAnnotationClasses().convention(Collections.emptySet());
            extension.getFilter().getExcludeClasses().convention(Collections.emptySet());
            extension.getFilter().getExcludeAnnotationClasses().convention(Collections.emptySet());
        } else {
            extension.getFilter().getIncludeClasses().empty();
            extension.getFilter().getIncludeAnnotationClasses().empty();
            extension.getFilter().getExcludeClasses().empty();
            extension.getFilter().getExcludeAnnotationClasses().empty();
        }
    }

    Callable<Provider<Boolean>> getFailOnPassedAfterRetryInput() {
        if (this.useConventions) {
            return this.extension::getFailOnPassedAfterRetry;
        }
        return () -> {
            if (this.extension.getFailOnPassedAfterRetry().isPresent()) {
                return this.extension.getFailOnPassedAfterRetry();
            }
            return this.providerFactory.provider(this::getFailOnPassedAfterRetry);
        };
    }

    public boolean getFailOnPassedAfterRetry() {
        return this.read(this.extension.getFailOnPassedAfterRetry(), false);
    }

    public int getMaxRetries() {
        return this.read(this.extension.getMaxRetries(), 0);
    }

    public int getMaxFailures() {
        return this.read(this.extension.getMaxFailures(), 0);
    }

    public Set<String> getIncludeClasses() {
        return this.read(this.extension.getFilter().getIncludeClasses(), Collections.emptySet());
    }

    public Set<String> getIncludeAnnotationClasses() {
        return this.read(this.extension.getFilter().getIncludeAnnotationClasses(), Collections.emptySet());
    }

    public Set<String> getExcludeClasses() {
        return this.read(this.extension.getFilter().getExcludeClasses(), Collections.emptySet());
    }

    public Set<String> getExcludeAnnotationClasses() {
        return this.read(this.extension.getFilter().getExcludeAnnotationClasses(), Collections.emptySet());
    }

    public boolean getSimulateNotRetryableTest() {
        return this.simulateNotRetryableTest;
    }

    private <T> T read(Property<T> property, T defaultValue) {
        return (T)(this.useConventions ? property.get() : property.getOrElse(defaultValue));
    }

    private <T> Set<T> read(SetProperty<T> property, Set<T> defaultValue) {
        return this.useConventions ? (Set)property.get() : (Set)property.getOrElse(defaultValue);
    }
}

