/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import org.gradle.api.resources.MissingResourceException;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.resource.ResourceIsAFolderException;

public class ResourceExceptions {
    public static ResourceIsAFolderException readFolder(File location) {
        return new ResourceIsAFolderException(location.toURI(), String.format("Cannot read '%s' because it is a folder.", location));
    }

    public static ResourceException readFailed(File location, Throwable failure) {
        return ResourceExceptions.failure(location.toURI(), String.format("Could not read '%s'.", location), failure);
    }

    public static ResourceException readFailed(String displayName, Throwable failure) {
        return new ResourceException(String.format("Could not read %s.", displayName), failure);
    }

    public static MissingResourceException readMissing(File location, Throwable failure) {
        return new MissingResourceException(location.toURI(), String.format("Could not read '%s' as it does not exist.", location), failure instanceof FileNotFoundException ? null : failure);
    }

    public static MissingResourceException getMissing(URI location, Throwable failure) {
        return new MissingResourceException(location, String.format("Could not read '%s' as it does not exist.", location), failure instanceof FileNotFoundException ? null : failure);
    }

    public static MissingResourceException getMissing(URI location) {
        return new MissingResourceException(location, String.format("Could not read '%s' as it does not exist.", location));
    }

    public static ResourceException getFailed(URI location, Throwable failure) {
        return ResourceExceptions.failure(location, String.format("Could not get resource '%s'.", location), failure);
    }

    public static ResourceException putFailed(URI location, Throwable failure) {
        return ResourceExceptions.failure(location, String.format("Could not write to resource '%s'.", location), failure);
    }

    public static ResourceException failure(URI location, String message, Throwable failure) {
        ResourceException resourceException;
        if (failure instanceof ResourceException && location.equals((resourceException = (ResourceException)failure).getLocation())) {
            return resourceException;
        }
        return new ResourceException(location, message, failure);
    }
}

