/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.util.LinkedList;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.tooling.ProgressEvent;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;

class ProgressListenerAdapter
implements ProgressListenerVersion1 {
    private final ListenerBroadcast<ProgressListener> listeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final LinkedList<String> stack = new LinkedList();

    ProgressListenerAdapter() {
    }

    public void onOperationStart(String description) {
        this.stack.addFirst(description == null ? "" : description);
        this.fireChangeEvent();
    }

    public void onOperationEnd() {
        this.stack.removeFirst();
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        final String description = this.stack.isEmpty() ? "" : this.stack.getFirst();
        this.listeners.getSource().statusChanged(new ProgressEvent(){

            public String getDescription() {
                return description;
            }
        });
    }

    public void add(ProgressListener listener) {
        this.listeners.add(listener);
    }
}

