/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractModelProducer;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.converters.GradleBuildConverter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.gradle.DefaultGradleBuild;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleBuildAdapterProducer
extends AbstractModelProducer {
    private final ModelProducer delegate;

    public GradleBuildAdapterProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, ModelProducer delegate) {
        super(adapter, versionDetails, modelMapping);
        this.delegate = delegate;
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        if (type.getName().equals(GradleBuild.class.getName()) && !this.versionDetails.maySupportModel(type)) {
            GradleProject gradleProject = this.delegate.produceModel(GradleProject.class, operationParameters);
            DefaultGradleBuild convert = new GradleBuildConverter().convert(gradleProject);
            return this.adapter.adapt(type, convert);
        }
        return this.delegate.produceModel(type, operationParameters);
    }
}

