/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultProjectConnection;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.SynchronizedLogging;
import org.gradle.tooling.internal.consumer.async.DefaultAsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.LazyConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.LoggingInitializerConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ProgressLoggingConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public class ConnectionFactory {
    private final ToolingImplementationLoader toolingImplementationLoader;
    private final DefaultExecutorFactory executorFactory = new DefaultExecutorFactory();

    public ConnectionFactory(ToolingImplementationLoader toolingImplementationLoader) {
        this.toolingImplementationLoader = toolingImplementationLoader;
    }

    public ProjectConnection create(Distribution distribution, ConnectionParameters parameters) {
        SynchronizedLogging synchronizedLogging = new SynchronizedLogging();
        LazyConsumerActionExecutor lazyConnection = new LazyConsumerActionExecutor(distribution, this.toolingImplementationLoader, synchronizedLogging, parameters);
        ProgressLoggingConsumerActionExecutor progressLoggingConnection = new ProgressLoggingConsumerActionExecutor(lazyConnection, synchronizedLogging);
        LoggingInitializerConsumerActionExecutor initializingConnection = new LoggingInitializerConsumerActionExecutor(progressLoggingConnection, synchronizedLogging);
        DefaultAsyncConsumerActionExecutor asyncConnection = new DefaultAsyncConsumerActionExecutor(initializingConnection, this.executorFactory);
        return new DefaultProjectConnection(asyncConnection, parameters);
    }

    ToolingImplementationLoader getToolingImplementationLoader() {
        return this.toolingImplementationLoader;
    }
}

