/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.listener;

import groovy.lang.Closure;
import java.util.Arrays;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureBackedMethodInvocationDispatch
implements Dispatch<MethodInvocation> {
    private final String methodName;
    private final Closure closure;

    public ClosureBackedMethodInvocationDispatch(String methodName, Closure closure) {
        this.methodName = methodName;
        this.closure = closure;
    }

    @Override
    public void dispatch(MethodInvocation message) {
        if (message.getMethod().getName().equals(this.methodName)) {
            Object[] parameters = message.getArguments();
            if (this.closure.getMaximumNumberOfParameters() < parameters.length) {
                parameters = Arrays.asList(parameters).subList(0, this.closure.getMaximumNumberOfParameters()).toArray();
            }
            this.closure.call(parameters);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClosureBackedMethodInvocationDispatch that = (ClosureBackedMethodInvocationDispatch)o;
        if (!this.closure.equals(that.closure)) {
            return false;
        }
        return this.methodName.equals(that.methodName);
    }

    public int hashCode() {
        int result = this.methodName.hashCode();
        result = 31 * result + this.closure.hashCode();
        return result;
    }
}

