/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import org.gradle.internal.Factory;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.concurrent.Synchronizer;
import org.gradle.listener.DefaultListenerManager;
import org.gradle.listener.ListenerManager;
import org.gradle.logging.internal.DefaultProgressLoggerFactory;
import org.gradle.logging.internal.ProgressListener;
import org.gradle.tooling.internal.consumer.LoggingProvider;

public class SynchronizedLogging
implements LoggingProvider {
    private final ThreadLocal<ListenerManager> listenerManager = new ThreadLocal();
    private final ThreadLocal<DefaultProgressLoggerFactory> progressLoggerFactory = new ThreadLocal();
    private final Synchronizer synchronizer = new Synchronizer();

    public ListenerManager getListenerManager() {
        return this.synchronizer.synchronize(new Factory<ListenerManager>(){

            @Override
            public ListenerManager create() {
                SynchronizedLogging.this.assertInitialized();
                return (ListenerManager)SynchronizedLogging.this.listenerManager.get();
            }
        });
    }

    public DefaultProgressLoggerFactory getProgressLoggerFactory() {
        return this.synchronizer.synchronize(new Factory<DefaultProgressLoggerFactory>(){

            @Override
            public DefaultProgressLoggerFactory create() {
                SynchronizedLogging.this.assertInitialized();
                return (DefaultProgressLoggerFactory)SynchronizedLogging.this.progressLoggerFactory.get();
            }
        });
    }

    public void init() {
        this.synchronizer.synchronize(new Runnable(){

            public void run() {
                DefaultListenerManager manager = new DefaultListenerManager();
                SynchronizedLogging.this.listenerManager.set(manager);
                SynchronizedLogging.this.progressLoggerFactory.set(new DefaultProgressLoggerFactory(manager.getBroadcaster(ProgressListener.class), new TrueTimeProvider()));
            }
        });
    }

    private void assertInitialized() {
        if (this.listenerManager.get() == null) {
            throw new IllegalStateException("Internal problem. Logging has not yet been initialized for this thread.");
        }
    }
}

