/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLongRunningOperation<T extends LongRunningOperation>
implements LongRunningOperation {
    protected final ConnectionParameters connectionParameters;
    protected final ConsumerOperationParameters.Builder operationParamsBuilder;

    protected AbstractLongRunningOperation(ConnectionParameters parameters) {
        this.connectionParameters = parameters;
        this.operationParamsBuilder = ConsumerOperationParameters.builder();
    }

    protected abstract T getThis();

    protected final ConsumerOperationParameters getConsumerOperationParameters() {
        ConnectionParameters connectionParameters = this.connectionParameters;
        return this.operationParamsBuilder.setParameters(connectionParameters).build();
    }

    public T withArguments(String ... arguments) {
        this.operationParamsBuilder.setArguments(arguments);
        return this.getThis();
    }

    public T setStandardOutput(OutputStream outputStream) {
        this.operationParamsBuilder.setStdout(outputStream);
        return this.getThis();
    }

    public T setStandardError(OutputStream outputStream) {
        this.operationParamsBuilder.setStderr(outputStream);
        return this.getThis();
    }

    public T setStandardInput(InputStream inputStream) {
        this.operationParamsBuilder.setStdin(inputStream);
        return this.getThis();
    }

    public T setJavaHome(File javaHome) {
        this.operationParamsBuilder.setJavaHome(javaHome);
        return this.getThis();
    }

    public T setJvmArguments(String ... jvmArguments) {
        this.operationParamsBuilder.setJvmArguments(jvmArguments);
        return this.getThis();
    }

    public T addProgressListener(ProgressListener listener) {
        this.operationParamsBuilder.addProgressListener(listener);
        return this.getThis();
    }
}

