/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import groovy.lang.GroovySystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jarjar.org.apache.ivy.Ivy;
import org.gradle.jarjar.org.apache.tools.ant.Main;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleVersion
implements Comparable<GradleVersion> {
    public static final String URL = "http://www.gradle.org";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)+)(-(\\p{Alpha}+)-(\\d+[a-z]?))?(-(\\d{14}([-+]\\d{4})?))?");
    private final String version;
    private final String buildTime;
    private final Long snapshot;
    private final String versionPart;
    private final Stage stage;
    private static final GradleVersion CURRENT;
    public static final String RESOURCE_NAME = "/org/gradle/build-receipt.properties";

    public static GradleVersion current() {
        return CURRENT;
    }

    public static GradleVersion version(String version) {
        return new GradleVersion(version, null);
    }

    private GradleVersion(String version, Date buildTime) {
        this.version = version;
        this.buildTime = buildTime == null ? null : this.formatBuildTime(buildTime);
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            this.versionPart = null;
            this.snapshot = null;
            this.stage = null;
            return;
        }
        this.versionPart = matcher.group(1);
        if (matcher.group(3) != null) {
            int stageNumber = 0;
            if (matcher.group(4).equals("milestone")) {
                stageNumber = 1;
            } else if (matcher.group(4).equals("preview")) {
                stageNumber = 2;
            } else if (matcher.group(4).equals("rc")) {
                stageNumber = 3;
            }
            String stageString = matcher.group(5);
            this.stage = new Stage(stageNumber, stageString);
        } else {
            this.stage = null;
        }
        if (matcher.group(7) != null) {
            try {
                if (matcher.group(8) != null) {
                    this.snapshot = new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(7)).getTime();
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.snapshot = format.parse(matcher.group(7)).getTime();
            }
            catch (ParseException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        } else {
            this.snapshot = null;
        }
    }

    private String formatBuildTime(Date buildTime) {
        DateFormat format = DateFormat.getDateTimeInstance(0, 0);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.format(buildTime);
    }

    public String toString() {
        return String.format("Gradle %s", this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public boolean isSnapshot() {
        return this.versionPart == null || this.snapshot != null;
    }

    @Nullable
    public String getVersionBase() {
        return this.versionPart;
    }

    public int getMajor() {
        if (this.isValid()) {
            return Integer.valueOf(this.versionPart.split("\\.", 2)[0], 10);
        }
        return -1;
    }

    @Override
    public int compareTo(GradleVersion gradleVersion) {
        int diff;
        this.assertCanQueryParts();
        gradleVersion.assertCanQueryParts();
        String[] majorVersionParts = this.versionPart.split("\\.");
        String[] otherMajorVersionParts = gradleVersion.versionPart.split("\\.");
        for (int i = 0; i < majorVersionParts.length && i < otherMajorVersionParts.length; ++i) {
            int otherPart;
            int part = Integer.parseInt(majorVersionParts[i]);
            if (part > (otherPart = Integer.parseInt(otherMajorVersionParts[i]))) {
                return 1;
            }
            if (otherPart <= part) continue;
            return -1;
        }
        if (majorVersionParts.length > otherMajorVersionParts.length) {
            return 1;
        }
        if (majorVersionParts.length < otherMajorVersionParts.length) {
            return -1;
        }
        if (this.stage != null && gradleVersion.stage != null && (diff = this.stage.compareTo(gradleVersion.stage)) != 0) {
            return diff;
        }
        if (this.stage == null && gradleVersion.stage != null) {
            return 1;
        }
        if (this.stage != null && gradleVersion.stage == null) {
            return -1;
        }
        if (this.snapshot != null && gradleVersion.snapshot != null) {
            return this.snapshot.compareTo(gradleVersion.snapshot);
        }
        if (this.snapshot == null && gradleVersion.snapshot != null) {
            return 1;
        }
        if (this.snapshot != null && gradleVersion.snapshot == null) {
            return -1;
        }
        return 0;
    }

    private void assertCanQueryParts() {
        if (this.versionPart == null) {
            throw new IllegalArgumentException(String.format("Cannot compare unrecognized Gradle version '%s'.", this.version));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GradleVersion other = (GradleVersion)o;
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n------------------------------------------------------------\nGradle ");
        sb.append(this.getVersion());
        sb.append("\n------------------------------------------------------------\n\nGradle build time: ");
        sb.append(this.getBuildTime());
        sb.append("\nGroovy: ");
        sb.append(GroovySystem.getVersion());
        sb.append("\nAnt: ");
        sb.append(Main.getAntVersion());
        sb.append("\nIvy: ");
        sb.append(Ivy.getIvyVersion());
        sb.append("\nJVM: ");
        sb.append(Jvm.current());
        sb.append("\nOS: ");
        sb.append(OperatingSystem.current());
        sb.append("\n");
        return sb.toString();
    }

    public boolean isValid() {
        return this.versionPart != null;
    }

    static {
        URL resource = GradleVersion.class.getResource(RESOURCE_NAME);
        InputStream inputStream = null;
        try {
            URLConnection connection = resource.openConnection();
            inputStream = connection.getInputStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            String version = properties.get("versionNumber").toString();
            String buildTimestamp = properties.get("buildTimestamp").toString();
            Date buildTime = new SimpleDateFormat("yyyyMMddHHmmssZ").parse(buildTimestamp);
            CURRENT = new GradleVersion(version, buildTime);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not load version details from resource '%s'.", resource), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;
        final Character patchNo;

        Stage(int stage, String number) {
            this.stage = stage;
            Matcher m = Pattern.compile("(\\d+)([a-z])?").matcher(number);
            try {
                m.matches();
                this.number = Integer.parseInt(m.group(1));
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid stage small number: " + number, e);
            }
            this.patchNo = m.groupCount() == 2 && m.group(2) != null ? Character.valueOf(m.group(2).charAt(0)) : Character.valueOf('_');
        }

        @Override
        public int compareTo(Stage other) {
            if (this.stage > other.stage) {
                return 1;
            }
            if (this.stage < other.stage) {
                return -1;
            }
            if (this.number > other.number) {
                return 1;
            }
            if (this.number < other.number) {
                return -1;
            }
            if (this.patchNo.charValue() > other.patchNo.charValue()) {
                return 1;
            }
            if (this.patchNo.charValue() < other.patchNo.charValue()) {
                return -1;
            }
            return 0;
        }
    }
}

