/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractPost12ConsumerConnection;
import org.gradle.tooling.internal.consumer.converters.PropertyHandlerFactory;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildActionRunnerBackedConsumerConnection
extends AbstractPost12ConsumerConnection {
    private final BuildActionRunner buildActionRunner;
    private final ModelMapping modelMapping;
    private final ProtocolToModelAdapter adapter;

    public BuildActionRunnerBackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, new R12VersionDetails(delegate.getMetaData().getVersion()));
        this.modelMapping = modelMapping;
        this.adapter = adapter;
        this.buildActionRunner = (BuildActionRunner)((Object)delegate);
    }

    @Override
    public <T> T run(Class<T> type, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        Class<?> protocolType = this.modelMapping.getProtocolType(type);
        Object model = this.buildActionRunner.run(protocolType, operationParameters).getModel();
        return this.adapter.adapt(type, model, new PropertyHandlerFactory().forVersion(this.getVersionDetails()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R12VersionDetails
    extends VersionDetails {
        public R12VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean supportsConfiguringJavaHome() {
            return true;
        }

        @Override
        public boolean supportsConfiguringJvmArguments() {
            return true;
        }

        @Override
        public boolean supportsConfiguringStandardInput() {
            return true;
        }

        @Override
        public boolean supportsGradleProjectModel() {
            return true;
        }

        @Override
        public boolean supportsRunningTasksWhenBuildingModel() {
            return true;
        }

        @Override
        public boolean isModelSupported(Class<?> modelType) {
            return modelType.equals(ProjectOutcomes.class) || modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(BuildEnvironment.class) || modelType.equals(GradleProject.class) || modelType.equals(Void.class);
        }
    }
}

