/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.DefaultPatternMatcher;
import org.gradle.api.internal.file.pattern.NameOnlyPatternMatcher;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatcherFactory {
    public static Spec<RelativePath> getPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String pattern) {
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            pattern = pattern + "**";
        }
        if (pattern.length() == 0) {
            return new DefaultPatternMatcher(partialMatchDirs, true, new String[0]);
        }
        String[] parts = pattern.split("\\\\|/");
        if (parts.length == 2 && "**".equals(parts[0])) {
            if ("**".equals(parts[1])) {
                return new DefaultPatternMatcher(partialMatchDirs, caseSensitive, "**");
            }
            return new NameOnlyPatternMatcher(partialMatchDirs, caseSensitive, parts[1]);
        }
        return new DefaultPatternMatcher(partialMatchDirs, caseSensitive, parts);
    }
}

