/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.Named;
import org.gradle.api.Namer;
import org.gradle.api.Transformer;
import org.gradle.api.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transformers {
    public static <O, I> Transformer<O, I> cast(Class<O> outputType) {
        return new CastingTransformer(outputType);
    }

    public static <T> Transformer<String, T> asString() {
        return new ToStringTransformer();
    }

    public static Transformer<String, Named> name() {
        return Transformers.name(new Named.Namer());
    }

    public static <T> Transformer<String, T> name(Namer<? super T> namer) {
        return new ToNameTransformer<T>(namer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToNameTransformer<T>
    implements Transformer<String, T> {
        private final Namer<? super T> namer;

        public ToNameTransformer(Namer<? super T> namer) {
            this.namer = namer;
        }

        @Override
        public String transform(T thing) {
            return thing == null ? null : this.namer.determineName(thing);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToStringTransformer<T>
    implements Transformer<String, T> {
        private ToStringTransformer() {
        }

        @Override
        public String transform(T original) {
            return original == null ? null : original.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastingTransformer<O, I>
    implements Transformer<O, I> {
        final Class<O> outputType;

        public CastingTransformer(Class<O> outputType) {
            this.outputType = outputType;
        }

        @Override
        public O transform(I input) {
            return Cast.cast(this.outputType, input);
        }
    }
}

