/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.progress;

import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Nullable;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.progress.ProgressListener;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.BuildOperationCategory;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.time.TimeProvider;
import org.gradle.util.GUtil;

public class DefaultProgressLoggerFactory
implements ProgressLoggerFactory {
    private final ProgressListener progressListener;
    private final TimeProvider timeProvider;
    private final AtomicLong nextId = new AtomicLong(1L);
    private final ThreadLocal<ProgressLoggerImpl> current = new ThreadLocal();

    public DefaultProgressLoggerFactory(ProgressListener progressListener, TimeProvider timeProvider) {
        this.progressListener = progressListener;
        this.timeProvider = timeProvider;
    }

    public ProgressLogger newOperation(Class loggerCategory) {
        return this.newOperation(loggerCategory.getName());
    }

    public ProgressLogger newOperation(Class loggerCategory, @Nullable BuildOperationDescriptor buildOperationDescriptor) {
        return this.init(loggerCategory.getName(), null, buildOperationDescriptor);
    }

    public ProgressLogger newOperation(String loggerCategory) {
        return this.init(loggerCategory, null, null);
    }

    public ProgressLogger newOperation(Class loggerClass, ProgressLogger parent) {
        return this.init(loggerClass.toString(), parent, null);
    }

    private ProgressLogger init(String loggerCategory, @Nullable ProgressLogger parentOperation, @Nullable BuildOperationDescriptor buildOperationDescriptor) {
        if (parentOperation != null && !(parentOperation instanceof ProgressLoggerImpl)) {
            throw new IllegalArgumentException("Unexpected parent logger.");
        }
        return new ProgressLoggerImpl((ProgressLoggerImpl)parentOperation, new OperationIdentifier(this.nextId.getAndIncrement()), loggerCategory, this.progressListener, this.timeProvider, buildOperationDescriptor);
    }

    private class ProgressLoggerImpl
    implements ProgressLogger {
        private final OperationIdentifier progressOperationId;
        private final BuildOperationDescriptor buildOperationDescriptor;
        private final String category;
        private final ProgressListener listener;
        private final TimeProvider timeProvider;
        private ProgressLoggerImpl parent;
        private String description;
        private String shortDescription;
        private String loggingHeader;
        private State state = State.idle;

        public ProgressLoggerImpl(ProgressLoggerImpl parent, OperationIdentifier progressOperationId, String category, ProgressListener listener, @Nullable TimeProvider timeProvider, BuildOperationDescriptor buildOperationDescriptor) {
            this.parent = parent;
            this.progressOperationId = progressOperationId;
            this.category = category;
            this.listener = listener;
            this.timeProvider = timeProvider;
            this.buildOperationDescriptor = buildOperationDescriptor;
        }

        public String toString() {
            return this.category + " - " + this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public ProgressLogger setDescription(String description) {
            this.assertCanConfigure();
            this.description = description;
            return this;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public ProgressLogger setShortDescription(String shortDescription) {
            this.assertCanConfigure();
            this.shortDescription = shortDescription;
            return this;
        }

        public String getLoggingHeader() {
            return this.loggingHeader;
        }

        public ProgressLogger setLoggingHeader(String loggingHeader) {
            this.assertCanConfigure();
            this.loggingHeader = loggingHeader;
            return this;
        }

        public ProgressLogger start(String description, String shortDescription) {
            this.setDescription(description);
            this.setShortDescription(shortDescription);
            this.started();
            return this;
        }

        public void started() {
            this.started(null);
        }

        public void started(String status) {
            if (!GUtil.isTrue((Object)this.description)) {
                throw new IllegalStateException("A description must be specified before this operation is started.");
            }
            this.assertNotStarted();
            this.state = State.started;
            if (this.parent == null) {
                this.parent = (ProgressLoggerImpl)DefaultProgressLoggerFactory.this.current.get();
            } else {
                this.parent.assertRunning();
            }
            DefaultProgressLoggerFactory.this.current.set(this);
            this.listener.started(new ProgressStartEvent(this.progressOperationId, this.parent == null ? null : this.parent.progressOperationId, this.timeProvider.getCurrentTime(), this.category, this.description, this.shortDescription, this.loggingHeader, this.toStatus(status), this.getBuildOperationId(), this.getParentBuildOperationId(), this.getBuildOperationCategory()));
        }

        public void progress(String status) {
            this.assertRunning();
            this.listener.progress(new ProgressEvent(this.progressOperationId, this.toStatus(status)));
        }

        public void completed() {
            this.completed(null);
        }

        public void completed(String status) {
            this.assertRunning();
            this.state = State.completed;
            DefaultProgressLoggerFactory.this.current.set(this.parent);
            this.listener.completed(new ProgressCompleteEvent(this.progressOperationId, this.timeProvider.getCurrentTime(), this.toStatus(status)));
        }

        private String toStatus(String status) {
            return status == null ? "" : status;
        }

        private void assertNotStarted() {
            if (this.state == State.started) {
                throw new IllegalStateException(String.format("This operation (%s) has already been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already completed.", this));
            }
        }

        private void assertRunning() {
            if (this.state == State.idle) {
                throw new IllegalStateException(String.format("This operation (%s) has not been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already been completed.", this));
            }
        }

        private void assertCanConfigure() {
            if (this.state != State.idle) {
                throw new IllegalStateException(String.format("Cannot configure this operation (%s) once it has started.", this));
            }
        }

        private Object getBuildOperationId() {
            return this.buildOperationDescriptor == null ? null : this.buildOperationDescriptor.getId();
        }

        private Object getParentBuildOperationId() {
            return this.buildOperationDescriptor == null ? null : this.buildOperationDescriptor.getParentId();
        }

        private BuildOperationCategory getBuildOperationCategory() {
            return this.buildOperationDescriptor == null ? BuildOperationCategory.UNCATEGORIZED : this.buildOperationDescriptor.getOperationType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        idle,
        started,
        completed;

    }
}

