/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Nullable;
import org.gradle.internal.logging.events.BatchOutputEventListener;
import org.gradle.internal.logging.events.EndOutputEvent;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.format.LogHeaderFormatter;
import org.gradle.internal.progress.BuildOperationCategory;
import org.gradle.internal.time.TimeProvider;
import org.gradle.util.GUtil;

public class GroupingProgressLogEventGenerator
extends BatchOutputEventListener {
    static final long LONG_RUNNING_TASK_OUTPUT_FLUSH_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private final OutputEventListener listener;
    private final TimeProvider timeProvider;
    private final ScheduledExecutorService executor;
    private final LogHeaderFormatter headerFormatter;
    private final boolean alwaysRenderTasks;
    private final Map<Object, Object> buildOpIdHierarchy = new HashMap<Object, Object>();
    private final Map<Object, OperationGroup> operationsInProgress = new LinkedHashMap<Object, OperationGroup>();
    private final Map<OperationIdentifier, Object> progressToBuildOpIdMap = new HashMap<OperationIdentifier, Object>();
    private Object lastRenderedBuildOpId;
    private ScheduledFuture future;

    public GroupingProgressLogEventGenerator(OutputEventListener listener, TimeProvider timeProvider, LogHeaderFormatter headerFormatter, boolean alwaysRenderTasks) {
        this(listener, timeProvider, Executors.newSingleThreadScheduledExecutor(), headerFormatter, alwaysRenderTasks);
    }

    public GroupingProgressLogEventGenerator(OutputEventListener listener, TimeProvider timeProvider, ScheduledExecutorService executor, LogHeaderFormatter headerFormatter, boolean alwaysRenderTasks) {
        this.listener = listener;
        this.timeProvider = timeProvider;
        this.executor = executor;
        this.headerFormatter = headerFormatter;
        this.alwaysRenderTasks = alwaysRenderTasks;
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            this.onStart((ProgressStartEvent)event);
        } else if (event instanceof RenderableOutputEvent) {
            this.handleOutput((RenderableOutputEvent)event);
        } else if (event instanceof ProgressCompleteEvent) {
            this.onComplete((ProgressCompleteEvent)event);
        } else if (event instanceof EndOutputEvent) {
            if (this.future != null && !this.future.isCancelled()) {
                this.future.cancel(false);
            }
            this.executor.shutdownNow();
            this.onEnd((EndOutputEvent)event);
        } else if (!(event instanceof ProgressEvent)) {
            this.listener.onOutput(event);
        }
    }

    private void onStart(ProgressStartEvent startEvent) {
        Object buildOpId = startEvent.getBuildOperationId();
        boolean isGrouped = this.isGroupedOperation(startEvent.getBuildOperationCategory());
        if (buildOpId != null) {
            this.buildOpIdHierarchy.put(buildOpId, startEvent.getParentBuildOperationId());
            this.progressToBuildOpIdMap.put(startEvent.getProgressOperationId(), buildOpId);
            if (isGrouped) {
                this.operationsInProgress.put(buildOpId, new OperationGroup(startEvent.getCategory(), startEvent.getLoggingHeader(), startEvent.getDescription(), startEvent.getShortDescription(), startEvent.getTimestamp(), startEvent.getBuildOperationId(), startEvent.getBuildOperationCategory()));
                if (this.future == null || this.future.isCancelled()) {
                    this.future = this.executor.scheduleAtFixedRate(new Runnable(){

                        public void run() {
                            for (OperationGroup group : GroupingProgressLogEventGenerator.this.operationsInProgress.values()) {
                                group.maybeFlushOutput(GroupingProgressLogEventGenerator.this.timeProvider.getCurrentTime());
                            }
                        }
                    }, LONG_RUNNING_TASK_OUTPUT_FLUSH_TIMEOUT, 500L, TimeUnit.MILLISECONDS);
                }
            }
        }
        if (!(!GUtil.isTrue((Object)startEvent.getLoggingHeader()) || startEvent.getLoggingHeader().equals(startEvent.getShortDescription()) || buildOpId != null && isGrouped)) {
            this.onUngroupedOutput(new LogEvent(startEvent.getTimestamp(), startEvent.getCategory(), startEvent.getLogLevel(), startEvent.getLoggingHeader(), null, startEvent.getBuildOperationId()));
        }
    }

    private boolean isGroupedOperation(BuildOperationCategory buildOperationCategory) {
        return buildOperationCategory == BuildOperationCategory.TASK || buildOperationCategory == BuildOperationCategory.CONFIGURE_PROJECT;
    }

    private void handleOutput(RenderableOutputEvent event) {
        Object operationId = this.getOperationId(event.getBuildOperationId());
        if (operationId != null) {
            this.operationsInProgress.get(operationId).bufferOutput(event);
        } else {
            this.onUngroupedOutput(event);
        }
    }

    private void onComplete(ProgressCompleteEvent completeEvent) {
        Object buildOpId = this.progressToBuildOpIdMap.remove(completeEvent.getProgressOperationId());
        this.buildOpIdHierarchy.remove(buildOpId);
        OperationGroup group = this.operationsInProgress.remove(buildOpId);
        if (group != null) {
            group.setStatus(completeEvent.getStatus());
            group.flushOutput();
        }
    }

    private void onEnd(EndOutputEvent event) {
        for (OperationGroup group : this.operationsInProgress.values()) {
            group.flushOutput();
        }
        this.listener.onOutput(event);
        this.buildOpIdHierarchy.clear();
        this.operationsInProgress.clear();
        this.progressToBuildOpIdMap.clear();
    }

    private void onUngroupedOutput(RenderableOutputEvent event) {
        if (this.lastRenderedBuildOpId != null) {
            this.listener.onOutput(GroupingProgressLogEventGenerator.spacerLine(event.getTimestamp(), event.getCategory()));
            this.lastRenderedBuildOpId = null;
        }
        this.listener.onOutput(event);
    }

    private Object getOperationId(@Nullable Object buildOpId) {
        Object current = buildOpId;
        while (current != null) {
            if (this.operationsInProgress.containsKey(current)) {
                return current;
            }
            current = this.buildOpIdHierarchy.get(current);
        }
        return null;
    }

    private static LogEvent spacerLine(long timestamp, String category) {
        return new LogEvent(timestamp, category, null, "", null);
    }

    private class OperationGroup {
        private final String category;
        private final String loggingHeader;
        private long lastUpdateTime;
        private final String description;
        private final String shortDescription;
        private final Object buildOpIdentifier;
        private final BuildOperationCategory buildOperationCategory;
        private String status = "";
        private List<RenderableOutputEvent> bufferedLogs = new ArrayList<RenderableOutputEvent>();

        private OperationGroup(@Nullable String category, String loggingHeader, @Nullable String description, String shortDescription, long startTime, Object buildOpIdentifier, BuildOperationCategory buildOperationCategory) {
            this.category = category;
            this.loggingHeader = loggingHeader;
            this.lastUpdateTime = startTime;
            this.description = description;
            this.shortDescription = shortDescription;
            this.lastUpdateTime = startTime;
            this.buildOpIdentifier = buildOpIdentifier;
            this.buildOperationCategory = buildOperationCategory;
        }

        private StyledTextOutputEvent header() {
            return new StyledTextOutputEvent(this.lastUpdateTime, this.category, null, this.buildOpIdentifier, GroupingProgressLogEventGenerator.this.headerFormatter.format(this.loggingHeader, this.description, this.shortDescription, this.status));
        }

        synchronized void bufferOutput(RenderableOutputEvent output) {
            if (Objects.equal((Object)this.buildOpIdentifier, (Object)GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId)) {
                GroupingProgressLogEventGenerator.this.listener.onOutput(output);
                this.lastUpdateTime = GroupingProgressLogEventGenerator.this.timeProvider.getCurrentTime();
            } else {
                this.bufferedLogs.add(output);
            }
        }

        synchronized void flushOutput() {
            if (this.shouldForward()) {
                if (!this.buildOpIdentifier.equals(GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId)) {
                    GroupingProgressLogEventGenerator.this.listener.onOutput(this.header());
                }
                for (RenderableOutputEvent renderableEvent : this.bufferedLogs) {
                    GroupingProgressLogEventGenerator.this.listener.onOutput(renderableEvent);
                }
                this.bufferedLogs.clear();
                this.lastUpdateTime = GroupingProgressLogEventGenerator.this.timeProvider.getCurrentTime();
                GroupingProgressLogEventGenerator.this.lastRenderedBuildOpId = this.buildOpIdentifier;
            }
        }

        synchronized void maybeFlushOutput(long now) {
            if (this.lastUpdateTime + LONG_RUNNING_TASK_OUTPUT_FLUSH_TIMEOUT < now) {
                this.flushOutput();
            }
        }

        private void setStatus(String status) {
            this.status = status;
        }

        private boolean shouldForward() {
            return !this.bufferedLogs.isEmpty() || GroupingProgressLogEventGenerator.this.alwaysRenderTasks && this.buildOperationCategory == BuildOperationCategory.TASK;
        }
    }
}

