/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.MutableClassDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInspector {
    public static ClassDetails inspect(Class<?> type) {
        MutableClassDetails classDetails = new MutableClassDetails(type);
        ClassInspector.visitGraph(type, classDetails);
        return classDetails;
    }

    private static void visitGraph(Class<?> type, MutableClassDetails classDetails) {
        HashSet<Class> seen = new HashSet<Class>();
        ArrayList queue = new ArrayList();
        queue.add(type);
        Collections.addAll(queue, ClassInspector.superClasses(type));
        while (!queue.isEmpty()) {
            Class current = (Class)queue.remove(0);
            if (!seen.add(current)) continue;
            if (!current.equals(type)) {
                classDetails.superType(current);
            }
            ClassInspector.inspectClass(current, classDetails);
            Collections.addAll(queue, current.getInterfaces());
        }
    }

    private static Class<?>[] superClasses(Class<?> current) {
        ArrayList supers = Lists.newArrayList();
        for (Class<?> superclass = current.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
            supers.add(superclass);
        }
        return supers.toArray(new Class[supers.size()]);
    }

    private static void inspectClass(Class<?> type, MutableClassDetails classDetails) {
        for (Method method : type.getDeclaredMethods()) {
            String propertyName;
            classDetails.method(method);
            if (Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isBridge()) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodName = method.getName();
            if (methodName.startsWith("get") && methodName.length() > 3 && !method.getReturnType().equals(Void.TYPE) && parameterTypes.length == 0) {
                propertyName = ClassInspector.propertyName(methodName, 3);
                classDetails.property(propertyName).addGetter(method);
                continue;
            }
            if (methodName.startsWith("is") && methodName.length() > 2 && (method.getReturnType().equals(Boolean.class) || method.getReturnType().equals(Boolean.TYPE)) && parameterTypes.length == 0) {
                propertyName = ClassInspector.propertyName(methodName, 2);
                classDetails.property(propertyName).addGetter(method);
                continue;
            }
            if (methodName.startsWith("set") && methodName.length() > 3 && parameterTypes.length == 1) {
                propertyName = ClassInspector.propertyName(methodName, 3);
                classDetails.property(propertyName).addSetter(method);
                continue;
            }
            classDetails.instanceMethod(method);
        }
    }

    private static String propertyName(String methodName, int beginIndex) {
        String propertyName = methodName.substring(beginIndex);
        if (Character.isUpperCase(propertyName.charAt(0)) && propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1))) {
            return propertyName;
        }
        return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

