/*
 * Decompiled with CFR 0.152.
 */
package org.gradlewebtools.minify.minifier.js;

import com.google.javascript.jscomp.AbstractCommandLineRunner;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradlewebtools.minify.minifier.Minifier;
import org.gradlewebtools.minify.minifier.js.JsMinifierOptions;
import org.gradlewebtools.minify.minifier.result.Error;
import org.gradlewebtools.minify.minifier.result.Report;
import org.gradlewebtools.minify.minifier.result.Warning;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0014J\b\u0010\u0019\u001a\u00020\u0013H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gradlewebtools/minify/minifier/js/JsMinifier;", "Lorg/gradlewebtools/minify/minifier/Minifier;", "minifierOptions", "Lorg/gradlewebtools/minify/minifier/js/JsMinifierOptions;", "(Lorg/gradlewebtools/minify/minifier/js/JsMinifierOptions;)V", "acceptedFileExtensions", "", "", "getAcceptedFileExtensions", "()Ljava/util/List;", "minifierName", "getMinifierName", "()Ljava/lang/String;", "getMinifierOptions", "()Lorg/gradlewebtools/minify/minifier/js/JsMinifierOptions;", "setMinifierOptions", "options", "Lcom/google/javascript/jscomp/CompilerOptions;", "minifyFile", "", "srcFile", "Ljava/io/File;", "dstFile", "rename", "oldName", "setOptions", "gradle-minify-plugin"})
public final class JsMinifier
extends Minifier {
    @NotNull
    private JsMinifierOptions minifierOptions;
    @NotNull
    private final String minifierName;
    @NotNull
    private final List<String> acceptedFileExtensions;
    @NotNull
    private final CompilerOptions options;

    public JsMinifier(@NotNull JsMinifierOptions minifierOptions) {
        Intrinsics.checkNotNullParameter((Object)minifierOptions, (String)"minifierOptions");
        this.minifierOptions = minifierOptions;
        this.minifierName = "Js Minifier";
        this.acceptedFileExtensions = CollectionsKt.listOf((Object)"js");
        this.options = new CompilerOptions();
    }

    public /* synthetic */ JsMinifier(JsMinifierOptions jsMinifierOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jsMinifierOptions = new JsMinifierOptions(null, null, null, null, null, null, false, false, false, null, false, null, null, null, false, null, false, false, null, null, false, null, false, null, false, 0x1FFFFFF, null);
        }
        this(jsMinifierOptions);
    }

    @Override
    @NotNull
    public JsMinifierOptions getMinifierOptions() {
        return this.minifierOptions;
    }

    public void setMinifierOptions(@NotNull JsMinifierOptions jsMinifierOptions) {
        Intrinsics.checkNotNullParameter((Object)jsMinifierOptions, (String)"<set-?>");
        this.minifierOptions = jsMinifierOptions;
    }

    @Override
    @NotNull
    public String getMinifierName() {
        return this.minifierName;
    }

    @Override
    @NotNull
    public List<String> getAcceptedFileExtensions() {
        return this.acceptedFileExtensions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void minifyFile(@NotNull File srcFile, @NotNull File dstFile) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
        Compiler compiler = new Compiler();
        this.setOptions();
        List externals = AbstractCommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)new CompilerOptions().getEnvironment());
        SourceFile sourceFile = SourceFile.fromFile((String)srcFile.getAbsolutePath());
        File sourcemapFile = new File(Intrinsics.stringPlus((String)dstFile.getAbsolutePath(), (Object)".map"));
        if (this.getMinifierOptions().getCreateSourceMaps()) {
            this.options.setSourceMapOutputPath(sourcemapFile.getAbsolutePath());
            this.options.setSourceMapLocationMappings(CollectionsKt.listOf(JsMinifier::minifyFile$lambda-1));
        }
        Result result = compiler.compile(externals, Collections.singletonList(sourceFile), this.options);
        if (result.success) {
            String source = compiler.toSource();
            if (this.getMinifierOptions().getCreateSourceMaps()) {
                void $this$minifyFile_u24lambda_u2d2;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
                File file = sourcemapFile;
                JsMinifier jsMinifier = this;
                boolean bl = false;
                result.sourceMap.appendTo((Appendable)$this$minifyFile_u24lambda_u2d2, dstFile.getName());
                Unit unit = Unit.INSTANCE;
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                jsMinifier.writeToFile(file, string);
                source = source + "\n//# sourceMappingURL=" + sourcemapFile.getName();
            }
            String string = source;
            Intrinsics.checkNotNull((Object)string);
            this.writeToFile(dstFile, string);
        } else {
            JSError it;
            ImmutableList source = result.errors;
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"result.errors");
            Iterable $this$forEach$iv = (Iterable)source;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JSError)element$iv;
                boolean bl = false;
                Report report = this.getReport();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                report.add(new Error(it));
            }
            $this$forEach$iv = result.warnings;
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"result.warnings");
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JSError)element$iv;
                boolean bl = false;
                Report report = this.getReport();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                report.add(new Warning(it));
            }
        }
    }

    private final void setOptions() {
        this.getMinifierOptions().getCompilationLevel().setOptionsForCompilationLevel(this.options);
        this.options.setEnvironment(this.getMinifierOptions().getEnv());
        if (this.getMinifierOptions().getLanguageIn() != null) {
            this.options.setLanguageIn(this.getMinifierOptions().getLanguageIn());
        }
        if (this.getMinifierOptions().getLanguageOut() != null) {
            this.options.setLanguageOut(this.getMinifierOptions().getLanguageOut());
        }
        this.getMinifierOptions().getWarningLevel().setOptionsForWarningLevel(this.options);
        this.options.setExtraAnnotationNames((Iterable)this.getMinifierOptions().getExtraAnnotationNames());
        this.options.setStrictModeInput(this.getMinifierOptions().getStrictModeInput());
        this.options.setStrictModeInput(this.getMinifierOptions().getStrictModeInput());
        if (this.getMinifierOptions().getDebug()) {
            this.getMinifierOptions().getCompilationLevel().setDebugOptionsForCompilationLevel(this.options);
        }
        this.options.setExportLocalPropertyDefinitions(this.getMinifierOptions().getExportLocalPropertyDefinitions());
        Iterable $this$forEach$iv = this.getMinifierOptions().getFormatting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandLineRunner.FormattingOption it = (CommandLineRunner.FormattingOption)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    this.options.setPrettyPrint(true);
                    break;
                }
                case 2: {
                    this.options.printInputDelimiter = true;
                    break;
                }
                case 3: {
                    this.options.setPreferSingleQuotes(true);
                    break;
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown formatting option: ", (Object)this));
                }
            }
        }
        this.options.setGenerateExports(this.getMinifierOptions().getGenerateExports());
        this.options.setRenamePrefixNamespace(this.getMinifierOptions().getRenamePrefixNamespace());
        this.options.setRenamePrefix(this.getMinifierOptions().getRenameVariablePrefix());
        this.options.setModuleResolutionMode(this.getMinifierOptions().getModuleResolution());
        this.options.setProcessCommonJSModules(this.getMinifierOptions().getProcessCommonJsModules());
        this.options.setPackageJsonEntryNames(this.getMinifierOptions().getPackageJsonEntryNames());
        this.options.setAngularPass(this.getMinifierOptions().getAngularPass());
        this.options.setDartPass(this.getMinifierOptions().getDartPass());
        this.options.setForceLibraryInjection((Iterable)this.getMinifierOptions().getForceInjectLibrary());
        this.options.setPolymerVersion(this.getMinifierOptions().getPolymerVersion());
        this.options.setRewritePolyfills(this.getMinifierOptions().getRewritePolyfills());
        this.options.setOutputCharset(this.getMinifierOptions().getCharset());
        this.options.setChecksOnly(this.getMinifierOptions().getChecksOnly());
        if (this.getMinifierOptions().getBrowserFeaturesetYear() != null) {
            this.options.setBrowserFeaturesetYear(this.getMinifierOptions().getBrowserFeaturesetYear());
        }
        this.options.setEmitUseStrict(this.getMinifierOptions().getEmitUseStrict());
    }

    @Override
    @NotNull
    protected String rename(@NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        return StringsKt.replace$default((String)oldName, (String)".js", (String)".min.js", (boolean)false, (int)4, null);
    }

    private static final String minifyFile$lambda-1(String it) {
        String string;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String it2 = string = StringsKt.substringAfterLast$default((String)it, (String)"/", null, (int)2, null);
        boolean bl = false;
        return ((CharSequence)it2).length() > 0 ? string : null;
    }

    public JsMinifier() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommandLineRunner.FormattingOption.values().length];
            nArray[CommandLineRunner.FormattingOption.PRETTY_PRINT.ordinal()] = 1;
            nArray[CommandLineRunner.FormattingOption.PRINT_INPUT_DELIMITER.ordinal()] = 2;
            nArray[CommandLineRunner.FormattingOption.SINGLE_QUOTES.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

