/*
 * Decompiled with CFR 0.152.
 */
package org.gradlewebtools.minify.minifier.css;

import com.google.common.css.DefaultExitCodeHandler;
import com.google.common.css.ExitCodeHandler;
import com.google.common.css.GssFunctionMapProvider;
import com.google.common.css.IdentitySubstitutionMap;
import com.google.common.css.JobDescription;
import com.google.common.css.JobDescriptionBuilder;
import com.google.common.css.SourceCode;
import com.google.common.css.SubstitutionMap;
import com.google.common.css.compiler.ast.BasicErrorManager;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.commandline.DefaultCommandLineCompiler;
import com.google.common.css.compiler.gssfunctions.DefaultGssFunctionMapProvider;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradlewebtools.minify.minifier.Minifier;
import org.gradlewebtools.minify.minifier.css.CssMinifierOptions;
import org.gradlewebtools.minify.minifier.result.Error;
import org.gradlewebtools.minify.minifier.result.Warning;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0014J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0014R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004\u00a8\u0006\u001c"}, d2={"Lorg/gradlewebtools/minify/minifier/css/CssMinifier;", "Lorg/gradlewebtools/minify/minifier/Minifier;", "minifierOptions", "Lorg/gradlewebtools/minify/minifier/css/CssMinifierOptions;", "(Lorg/gradlewebtools/minify/minifier/css/CssMinifierOptions;)V", "acceptedFileExtensions", "", "", "getAcceptedFileExtensions", "()Ljava/util/List;", "minifierName", "getMinifierName", "()Ljava/lang/String;", "getMinifierOptions", "()Lorg/gradlewebtools/minify/minifier/css/CssMinifierOptions;", "setMinifierOptions", "createJobDescription", "Lcom/google/common/css/JobDescription;", "file", "Ljava/io/File;", "minifyFile", "", "srcFile", "dstFile", "rename", "oldName", "ClosureStylesheetCompiler", "CompilerErrorManager", "gradle-minify-plugin"})
public final class CssMinifier
extends Minifier {
    @NotNull
    private CssMinifierOptions minifierOptions;
    @NotNull
    private final String minifierName;
    @NotNull
    private final List<String> acceptedFileExtensions;

    public CssMinifier(@NotNull CssMinifierOptions minifierOptions) {
        Intrinsics.checkNotNullParameter((Object)minifierOptions, (String)"minifierOptions");
        this.minifierOptions = minifierOptions;
        this.minifierName = "Css Minifier";
        this.acceptedFileExtensions = CollectionsKt.listOf((Object)"css");
    }

    public /* synthetic */ CssMinifier(CssMinifierOptions cssMinifierOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            cssMinifierOptions = new CssMinifierOptions(null, null, null, null, null, false, false, null, null, false, null, false, false, false, null, false, false, null, false, null, null, null, 0x3FFFFF, null);
        }
        this(cssMinifierOptions);
    }

    @Override
    @NotNull
    public CssMinifierOptions getMinifierOptions() {
        return this.minifierOptions;
    }

    public void setMinifierOptions(@NotNull CssMinifierOptions cssMinifierOptions) {
        Intrinsics.checkNotNullParameter((Object)cssMinifierOptions, (String)"<set-?>");
        this.minifierOptions = cssMinifierOptions;
    }

    @Override
    @NotNull
    public String getMinifierName() {
        return this.minifierName;
    }

    @Override
    @NotNull
    public List<String> getAcceptedFileExtensions() {
        return this.acceptedFileExtensions;
    }

    @Override
    protected void minifyFile(@NotNull File srcFile, @NotNull File dstFile) {
        Intrinsics.checkNotNullParameter((Object)srcFile, (String)"srcFile");
        Intrinsics.checkNotNullParameter((Object)dstFile, (String)"dstFile");
        try {
            JobDescription job = this.createJobDescription(srcFile);
            DefaultExitCodeHandler exitCodeHandler = new DefaultExitCodeHandler();
            CompilerErrorManager errorManager = new CompilerErrorManager();
            ClosureStylesheetCompiler compiler = new ClosureStylesheetCompiler(job, (ExitCodeHandler)exitCodeHandler, (ErrorManager)errorManager);
            File sourcemapFile = null;
            if (this.getMinifierOptions().getCreateSourceMaps()) {
                sourcemapFile = new File(Intrinsics.stringPlus((String)dstFile.getAbsolutePath(), (Object)".map"));
            }
            String compilerOutput = compiler.execute(null, sourcemapFile);
            if (sourcemapFile != null) {
                compilerOutput = compilerOutput + "\n//# sourceMappingURL=" + sourcemapFile.getName();
            }
            this.writeToFile(dstFile, compilerOutput);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    @NotNull
    protected String rename(@NotNull String oldName) {
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        return StringsKt.replace$default((String)oldName, (String)".css", (String)".min.css", (boolean)false, (int)4, null);
    }

    private final JobDescription createJobDescription(File file) throws IOException {
        JobDescriptionBuilder builder = new JobDescriptionBuilder();
        builder.setInputOrientation(this.getMinifierOptions().getInputOrientation());
        builder.setOutputOrientation(this.getMinifierOptions().getOutputOrientation());
        builder.setOutputFormat(this.getMinifierOptions().getOutputFormat());
        builder.setCopyrightNotice(this.getMinifierOptions().getCopyrightNotice());
        builder.setTrueConditionNames(this.getMinifierOptions().getTrueConditionNames());
        builder.setAllowDefPropagation(this.getMinifierOptions().getAllowDefPropagation());
        builder.setAllowUnrecognizedFunctions(this.getMinifierOptions().getAllowUnrecognizedFunctions());
        builder.setAllowedNonStandardFunctions(this.getMinifierOptions().getAllowedNonStandardFunctions());
        builder.setAllowedUnrecognizedProperties(this.getMinifierOptions().getAllowedUnrecognizedProperties());
        builder.setAllowUnrecognizedProperties(this.getMinifierOptions().getAllowUnrecognizedProperties());
        builder.setVendor(this.getMinifierOptions().getVendor());
        builder.setAllowKeyframes(this.getMinifierOptions().getAllowKeyframes());
        builder.setAllowWebkitKeyframes(this.getMinifierOptions().getAllowWebkitKeyframes());
        builder.setProcessDependencies(this.getMinifierOptions().getProcessDependencies());
        builder.setExcludedClassesFromRenaming(this.getMinifierOptions().getExcludedClassesFromRenaming());
        builder.setSimplifyCss(this.getMinifierOptions().getSimplifyCss());
        builder.setEliminateDeadStyles(this.getMinifierOptions().getEliminateDeadStyles());
        builder.setCssSubstitutionMapProvider(CssMinifier::createJobDescription$lambda-0);
        builder.setCssRenamingPrefix(this.getMinifierOptions().getCssRenamingPrefix());
        builder.setPreserveComments(this.getMinifierOptions().getPreserveComments());
        builder.setOutputRenamingMapFormat(this.getMinifierOptions().getOutputRenamingMapFormat());
        builder.setCompileConstants(this.getMinifierOptions().getCompileConstants());
        builder.setGssFunctionMapProvider((GssFunctionMapProvider)new DefaultGssFunctionMapProvider());
        builder.setSourceMapLevel(this.getMinifierOptions().getSourceMapLevel());
        builder.setCreateSourceMap(this.getMinifierOptions().getCreateSourceMaps());
        Object object = Files.readAllBytes(file.toPath());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readAllBytes(file.toPath())");
        String fileContents = new String((byte[])object, Charsets.UTF_8);
        builder.addInput(new SourceCode(file.getName(), fileContents));
        object = builder.getJobDescription();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.jobDescription");
        return object;
    }

    private static final SubstitutionMap createJobDescription$lambda-0() {
        return (SubstitutionMap)new IdentitySubstitutionMap();
    }

    public CssMinifier() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/gradlewebtools/minify/minifier/css/CssMinifier$CompilerErrorManager;", "Lcom/google/common/css/compiler/ast/BasicErrorManager;", "(Lorg/gradlewebtools/minify/minifier/css/CssMinifier;)V", "print", "", "msg", "", "report", "error", "Lcom/google/common/css/compiler/ast/GssError;", "reportWarning", "warning", "gradle-minify-plugin"})
    public final class CompilerErrorManager
    extends BasicErrorManager {
        public CompilerErrorManager() {
            Intrinsics.checkNotNullParameter((Object)CssMinifier.this, (String)"this$0");
        }

        public void print(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        }

        public void report(@NotNull GssError error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            CssMinifier.this.getReport().add(new Error(error));
        }

        public void reportWarning(@NotNull GssError warning) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            CssMinifier.this.getReport().add(new Warning(warning));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/gradlewebtools/minify/minifier/css/CssMinifier$ClosureStylesheetCompiler;", "Lcom/google/common/css/compiler/commandline/DefaultCommandLineCompiler;", "job", "Lcom/google/common/css/JobDescription;", "exitCodeHandler", "Lcom/google/common/css/ExitCodeHandler;", "errorManager", "Lcom/google/common/css/compiler/ast/ErrorManager;", "(Lorg/gradlewebtools/minify/minifier/css/CssMinifier;Lcom/google/common/css/JobDescription;Lcom/google/common/css/ExitCodeHandler;Lcom/google/common/css/compiler/ast/ErrorManager;)V", "execute", "", "renameFile", "Ljava/io/File;", "sourcemapFile", "gradle-minify-plugin"})
    public final class ClosureStylesheetCompiler
    extends DefaultCommandLineCompiler {
        public ClosureStylesheetCompiler(@Nullable JobDescription job, @Nullable ExitCodeHandler exitCodeHandler, ErrorManager errorManager) {
            Intrinsics.checkNotNullParameter((Object)CssMinifier.this, (String)"this$0");
            super(job, exitCodeHandler, errorManager);
        }

        @NotNull
        public String execute(@Nullable File renameFile, @Nullable File sourcemapFile) {
            String string = super.execute(renameFile, sourcemapFile);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.execute(renameFile, sourcemapFile)");
            return string;
        }
    }
}

