// CheckStyle: start generated
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.IntValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString.LazyConcat;
import com.oracle.truffle.api.strings.AbstractTruffleString.LazyLong;
import com.oracle.truffle.api.strings.AbstractTruffleString.NativePointer;
import com.oracle.truffle.api.strings.TStringInternalNodes.CalcStringAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointAtRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CodePointIndexToRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.ConcatEagerNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.CreateJavaStringNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromBufferWithStringCompactionNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.FromJavaStringUTF16Node;
import com.oracle.truffle.api.strings.TStringInternalNodes.GetCodePointLengthNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringRawNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RawIndexToCodePointIndexNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.RegionEqualsNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.StrideFromCodeRangeNode;
import com.oracle.truffle.api.strings.TStringInternalNodes.TransCodeNode;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CalcStringAttributesNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CodePointAtNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CodePointAtRawNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CodePointIndexToRawNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.ConcatEagerNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.CreateJavaStringNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.FromBufferWithStringCompactionKnownAttributesNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.FromBufferWithStringCompactionNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.FromJavaStringUTF16NodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodePointLengthNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.IndexOfCodePointRawNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.IndexOfStringRawNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.LastIndexOfCodePointRawNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.LastIndexOfStringRawNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.RawIndexToCodePointIndexNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.RegionEqualsNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.StrideFromCodeRangeNodeGen;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory.TransCodeNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodes.CalculateHashCodeNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.IndexOfAnyCharNode;
import com.oracle.truffle.api.strings.TStringOpsNodes.IndexOfAnyIntNode;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.CalculateHashCodeNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.IndexOfAnyCharNodeGen;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory.IndexOfAnyIntNodeGen;
import com.oracle.truffle.api.strings.TruffleString.AsManagedNode;
import com.oracle.truffle.api.strings.TruffleString.AsTruffleStringNode;
import com.oracle.truffle.api.strings.TruffleString.ByteIndexOfAnyByteNode;
import com.oracle.truffle.api.strings.TruffleString.ByteIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TruffleString.ByteIndexOfStringNode;
import com.oracle.truffle.api.strings.TruffleString.ByteIndexToCodePointIndexNode;
import com.oracle.truffle.api.strings.TruffleString.CharIndexOfAnyCharUTF16Node;
import com.oracle.truffle.api.strings.TruffleString.CodePointAtByteIndexNode;
import com.oracle.truffle.api.strings.TruffleString.CodePointAtIndexNode;
import com.oracle.truffle.api.strings.TruffleString.CodePointIndexToByteIndexNode;
import com.oracle.truffle.api.strings.TruffleString.CodePointLengthNode;
import com.oracle.truffle.api.strings.TruffleString.CodeRange;
import com.oracle.truffle.api.strings.TruffleString.CodeRangeEqualsNode;
import com.oracle.truffle.api.strings.TruffleString.CompareBytesNode;
import com.oracle.truffle.api.strings.TruffleString.CompareCharsUTF16Node;
import com.oracle.truffle.api.strings.TruffleString.CompareIntsUTF32Node;
import com.oracle.truffle.api.strings.TruffleString.ConcatNode;
import com.oracle.truffle.api.strings.TruffleString.CopyToByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.CopyToNativeMemoryNode;
import com.oracle.truffle.api.strings.TruffleString.CreateBackwardCodePointIteratorNode;
import com.oracle.truffle.api.strings.TruffleString.CreateCodePointIteratorNode;
import com.oracle.truffle.api.strings.TruffleString.Encoding;
import com.oracle.truffle.api.strings.TruffleString.EqualNode;
import com.oracle.truffle.api.strings.TruffleString.ErrorHandling;
import com.oracle.truffle.api.strings.TruffleString.ForceEncodingNode;
import com.oracle.truffle.api.strings.TruffleString.FromByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.FromCharArrayUTF16Node;
import com.oracle.truffle.api.strings.TruffleString.FromCodePointNode;
import com.oracle.truffle.api.strings.TruffleString.FromIntArrayUTF32Node;
import com.oracle.truffle.api.strings.TruffleString.FromJavaStringNode;
import com.oracle.truffle.api.strings.TruffleString.FromLongNode;
import com.oracle.truffle.api.strings.TruffleString.GetByteCodeRangeNode;
import com.oracle.truffle.api.strings.TruffleString.GetInternalByteArrayNode;
import com.oracle.truffle.api.strings.TruffleString.GetInternalNativePointerNode;
import com.oracle.truffle.api.strings.TruffleString.HashCodeNode;
import com.oracle.truffle.api.strings.TruffleString.IntIndexOfAnyIntUTF32Node;
import com.oracle.truffle.api.strings.TruffleString.IsValidNode;
import com.oracle.truffle.api.strings.TruffleString.LastByteIndexOfCodePointNode;
import com.oracle.truffle.api.strings.TruffleString.LastByteIndexOfStringNode;
import com.oracle.truffle.api.strings.TruffleString.MaterializeNode;
import com.oracle.truffle.api.strings.TruffleString.NumberFormatException;
import com.oracle.truffle.api.strings.TruffleString.ReadCharUTF16Node;
import com.oracle.truffle.api.strings.TruffleString.RegionEqualByteIndexNode;
import com.oracle.truffle.api.strings.TruffleString.RegionEqualNode;
import com.oracle.truffle.api.strings.TruffleString.RepeatNode;
import com.oracle.truffle.api.strings.TruffleString.SubstringByteIndexNode;
import com.oracle.truffle.api.strings.TruffleString.SwitchEncodingNode;
import com.oracle.truffle.api.strings.TruffleString.ToIndexableNode;
import com.oracle.truffle.api.strings.TruffleString.WithMask;
import com.oracle.truffle.api.strings.TruffleString.ToIndexableNode.ToIndexableImplNode;
import com.oracle.truffle.api.strings.TruffleString.WithMask.CreateNode;
import com.oracle.truffle.api.strings.TruffleString.WithMask.CreateUTF16Node;
import com.oracle.truffle.api.strings.TruffleString.WithMask.CreateUTF32Node;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.Lock;

@GeneratedBy(TruffleString.class)
public final class TruffleStringFactory {

    @GeneratedBy(WithMask.class)
    public static final class WithMaskFactory {

        @GeneratedBy(CreateNode.class)
        static final class CreateNodeGen extends CreateNode {

            private static final Uncached UNCACHED = new Uncached();

            private CreateNodeGen() {
            }

            @Override
            public WithMask execute(AbstractTruffleString arg0Value, byte[] arg1Value, Encoding arg2Value) {
                return doCreate(arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public static CreateNode create() {
                return new CreateNodeGen();
            }

            public static CreateNode getUncached() {
                return CreateNodeGen.UNCACHED;
            }

            @GeneratedBy(CreateNode.class)
            @DenyReplace
            private static final class Uncached extends CreateNode {

                @TruffleBoundary
                @Override
                public WithMask execute(AbstractTruffleString arg0Value, byte[] arg1Value, Encoding arg2Value) {
                    return doCreate(arg0Value, arg1Value, arg2Value);
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
        @GeneratedBy(CreateUTF16Node.class)
        static final class CreateUTF16NodeGen extends CreateUTF16Node {

            private static final Uncached UNCACHED = new Uncached();

            private CreateUTF16NodeGen() {
            }

            @Override
            public WithMask execute(AbstractTruffleString arg0Value, char[] arg1Value) {
                return doCreate(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public static CreateUTF16Node create() {
                return new CreateUTF16NodeGen();
            }

            public static CreateUTF16Node getUncached() {
                return CreateUTF16NodeGen.UNCACHED;
            }

            @GeneratedBy(CreateUTF16Node.class)
            @DenyReplace
            private static final class Uncached extends CreateUTF16Node {

                @TruffleBoundary
                @Override
                public WithMask execute(AbstractTruffleString arg0Value, char[] arg1Value) {
                    return doCreate(arg0Value, arg1Value);
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
        @GeneratedBy(CreateUTF32Node.class)
        static final class CreateUTF32NodeGen extends CreateUTF32Node {

            private static final Uncached UNCACHED = new Uncached();

            private CreateUTF32NodeGen() {
            }

            @Override
            public WithMask execute(AbstractTruffleString arg0Value, int[] arg1Value) {
                return doCreate(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            public static CreateUTF32Node create() {
                return new CreateUTF32NodeGen();
            }

            public static CreateUTF32Node getUncached() {
                return CreateUTF32NodeGen.UNCACHED;
            }

            @GeneratedBy(CreateUTF32Node.class)
            @DenyReplace
            private static final class Uncached extends CreateUTF32Node {

                @TruffleBoundary
                @Override
                public WithMask execute(AbstractTruffleString arg0Value, int[] arg1Value) {
                    return doCreate(arg0Value, arg1Value);
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.MEGAMORPHIC;
                }

                @Override
                public boolean isAdoptable() {
                    return false;
                }

            }
        }
    }
    @GeneratedBy(FromCodePointNode.class)
    static final class FromCodePointNodeGen extends FromCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private FromCodePointData fromCodePoint_cache;

        private FromCodePointNodeGen() {
        }

        @Override
        public TruffleString execute(int arg0Value, Encoding arg1Value, boolean arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fromCodePoint(int, Encoding, boolean, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, BranchProfile) */) {
                FromCodePointData s0_ = this.fromCodePoint_cache;
                if (s0_ != null) {
                    return FromCodePointNode.fromCodePoint(arg0Value, arg1Value, arg2Value, s0_.bytesProfile_, s0_.utf8Profile_, s0_.utf16Profile_, s0_.utf32Profile_, s0_.exoticProfile_, s0_.bmpProfile_, s0_.invalidCodePoint_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleString executeAndSpecialize(int arg0Value, Encoding arg1Value, boolean arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                FromCodePointData s0_ = new FromCodePointData();
                s0_.bytesProfile_ = (ConditionProfile.create());
                s0_.utf8Profile_ = (ConditionProfile.create());
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.exoticProfile_ = (ConditionProfile.create());
                s0_.bmpProfile_ = (ConditionProfile.create());
                s0_.invalidCodePoint_ = (BranchProfile.create());
                VarHandle.storeStoreFence();
                this.fromCodePoint_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fromCodePoint(int, Encoding, boolean, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                return FromCodePointNode.fromCodePoint(arg0Value, arg1Value, arg2Value, s0_.bytesProfile_, s0_.utf8Profile_, s0_.utf16Profile_, s0_.utf32Profile_, s0_.exoticProfile_, s0_.bmpProfile_, s0_.invalidCodePoint_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromCodePointNode create() {
            return new FromCodePointNodeGen();
        }

        public static FromCodePointNode getUncached() {
            return FromCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(FromCodePointNode.class)
        private static final class FromCodePointData {

            @CompilationFinal ConditionProfile bytesProfile_;
            @CompilationFinal ConditionProfile utf8Profile_;
            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile exoticProfile_;
            @CompilationFinal ConditionProfile bmpProfile_;
            @CompilationFinal BranchProfile invalidCodePoint_;

            FromCodePointData() {
            }

        }
        @GeneratedBy(FromCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends FromCodePointNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(int arg0Value, Encoding arg1Value, boolean arg2Value) {
                return FromCodePointNode.fromCodePoint(arg0Value, arg1Value, arg2Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromLongNode.class)
    static final class FromLongNodeGen extends FromLongNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_0_;

        private FromLongNodeGen() {
        }

        @Override
        public TruffleString execute(long arg0Value, Encoding arg1Value, boolean arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doLazy(long, Encoding, boolean) || doEager(long, Encoding, boolean) || unsupported(long, Encoding, boolean) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doLazy(long, Encoding, boolean) */) {
                    if ((TStringGuards.is7BitCompatible(arg1Value)) && (arg2Value)) {
                        return FromLongNode.doLazy(arg0Value, arg1Value, arg2Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doEager(long, Encoding, boolean) */) {
                    if ((TStringGuards.is7BitCompatible(arg1Value)) && (!(arg2Value))) {
                        return FromLongNode.doEager(arg0Value, arg1Value, arg2Value);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 unsupported(long, Encoding, boolean) */) {
                    if ((!(TStringGuards.is7BitCompatible(arg1Value)))) {
                        return FromLongNode.unsupported(arg0Value, arg1Value, arg2Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleString executeAndSpecialize(long arg0Value, Encoding arg1Value, boolean arg2Value) {
            int state_0 = this.state_0_;
            if ((TStringGuards.is7BitCompatible(arg1Value)) && (arg2Value)) {
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doLazy(long, Encoding, boolean) */;
                return FromLongNode.doLazy(arg0Value, arg1Value, arg2Value);
            }
            if ((TStringGuards.is7BitCompatible(arg1Value)) && (!(arg2Value))) {
                this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doEager(long, Encoding, boolean) */;
                return FromLongNode.doEager(arg0Value, arg1Value, arg2Value);
            }
            if ((!(TStringGuards.is7BitCompatible(arg1Value)))) {
                this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 unsupported(long, Encoding, boolean) */;
                return FromLongNode.unsupported(arg0Value, arg1Value, arg2Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static FromLongNode create() {
            return new FromLongNodeGen();
        }

        public static FromLongNode getUncached() {
            return FromLongNodeGen.UNCACHED;
        }

        @GeneratedBy(FromLongNode.class)
        @DenyReplace
        private static final class Uncached extends FromLongNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(long arg0Value, Encoding arg1Value, boolean arg2Value) {
                if ((TStringGuards.is7BitCompatible(arg1Value)) && (arg2Value)) {
                    return FromLongNode.doLazy(arg0Value, arg1Value, arg2Value);
                }
                if ((TStringGuards.is7BitCompatible(arg1Value)) && (!(arg2Value))) {
                    return FromLongNode.doEager(arg0Value, arg1Value, arg2Value);
                }
                if ((!(TStringGuards.is7BitCompatible(arg1Value)))) {
                    return FromLongNode.unsupported(arg0Value, arg1Value, arg2Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromByteArrayNode.class)
    static final class FromByteArrayNodeGen extends FromByteArrayNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode_;

        private FromByteArrayNodeGen() {
        }

        @Override
        public TruffleString execute(byte[] arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fromByteArray(byte[], int, int, Encoding, boolean, FromBufferWithStringCompactionNode) */) {
                return FromByteArrayNode.fromByteArray(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.fromBufferWithStringCompactionNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private TruffleString executeAndSpecialize(byte[] arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.fromBufferWithStringCompactionNode_ = super.insert((FromBufferWithStringCompactionNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fromByteArray(byte[], int, int, Encoding, boolean, FromBufferWithStringCompactionNode) */;
                lock.unlock();
                hasLock = false;
                return FromByteArrayNode.fromByteArray(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.fromBufferWithStringCompactionNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromByteArrayNode create() {
            return new FromByteArrayNodeGen();
        }

        public static FromByteArrayNode getUncached() {
            return FromByteArrayNodeGen.UNCACHED;
        }

        @GeneratedBy(FromByteArrayNode.class)
        @DenyReplace
        private static final class Uncached extends FromByteArrayNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(byte[] arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return FromByteArrayNode.fromByteArray(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (FromBufferWithStringCompactionNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromCharArrayUTF16Node.class)
    static final class FromCharArrayUTF16NodeGen extends FromCharArrayUTF16Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private ConditionProfile utf16CompactProfile_;
        @CompilationFinal private BranchProfile outOfMemoryProfile_;

        private FromCharArrayUTF16NodeGen() {
        }

        @Override
        public TruffleString execute(char[] arg0Value, int arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doNonEmpty(char[], int, int, ConditionProfile, BranchProfile) */) {
                return doNonEmpty(arg0Value, arg1Value, arg2Value, this.utf16CompactProfile_, this.outOfMemoryProfile_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleString executeAndSpecialize(char[] arg0Value, int arg1Value, int arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.utf16CompactProfile_ = (ConditionProfile.create());
                this.outOfMemoryProfile_ = (BranchProfile.create());
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doNonEmpty(char[], int, int, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                return doNonEmpty(arg0Value, arg1Value, arg2Value, this.utf16CompactProfile_, this.outOfMemoryProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromCharArrayUTF16Node create() {
            return new FromCharArrayUTF16NodeGen();
        }

        public static FromCharArrayUTF16Node getUncached() {
            return FromCharArrayUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(FromCharArrayUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends FromCharArrayUTF16Node {

            @TruffleBoundary
            @Override
            public TruffleString execute(char[] arg0Value, int arg1Value, int arg2Value) {
                return doNonEmpty(arg0Value, arg1Value, arg2Value, (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromJavaStringNode.class)
    static final class FromJavaStringNodeGen extends FromJavaStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private UTF16Data uTF16_cache;

        private FromJavaStringNodeGen() {
        }

        @Override
        public TruffleString execute(String arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doUTF16(String, int, int, Encoding, boolean, FromJavaStringUTF16Node, SwitchEncodingNode, ConditionProfile) */) {
                UTF16Data s0_ = this.uTF16_cache;
                if (s0_ != null) {
                    return FromJavaStringNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.fromJavaStringUTF16Node_, s0_.switchEncodingNode_, s0_.utf16Profile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private TruffleString executeAndSpecialize(String arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                UTF16Data s0_ = super.insert(new UTF16Data());
                s0_.fromJavaStringUTF16Node_ = s0_.insertAccessor((FromJavaStringUTF16NodeGen.create()));
                s0_.switchEncodingNode_ = s0_.insertAccessor((SwitchEncodingNode.create()));
                s0_.utf16Profile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.uTF16_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doUTF16(String, int, int, Encoding, boolean, FromJavaStringUTF16Node, SwitchEncodingNode, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return FromJavaStringNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.fromJavaStringUTF16Node_, s0_.switchEncodingNode_, s0_.utf16Profile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromJavaStringNode create() {
            return new FromJavaStringNodeGen();
        }

        public static FromJavaStringNode getUncached() {
            return FromJavaStringNodeGen.UNCACHED;
        }

        @GeneratedBy(FromJavaStringNode.class)
        private static final class UTF16Data extends Node {

            @Child FromJavaStringUTF16Node fromJavaStringUTF16Node_;
            @Child SwitchEncodingNode switchEncodingNode_;
            @CompilationFinal ConditionProfile utf16Profile_;

            UTF16Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(FromJavaStringNode.class)
        @DenyReplace
        private static final class Uncached extends FromJavaStringNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(String arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return FromJavaStringNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (FromJavaStringUTF16NodeGen.getUncached()), (SwitchEncodingNode.getUncached()), (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(FromIntArrayUTF32Node.class)
    static final class FromIntArrayUTF32NodeGen extends FromIntArrayUTF32Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private NonEmptyData nonEmpty_cache;

        private FromIntArrayUTF32NodeGen() {
        }

        @Override
        public TruffleString execute(int[] arg0Value, int arg1Value, int arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doNonEmpty(int[], int, int, ConditionProfile, ConditionProfile, BranchProfile) */) {
                NonEmptyData s0_ = this.nonEmpty_cache;
                if (s0_ != null) {
                    return doNonEmpty(arg0Value, arg1Value, arg2Value, s0_.utf32Compact0Profile_, s0_.utf32Compact1Profile_, s0_.outOfMemoryProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleString executeAndSpecialize(int[] arg0Value, int arg1Value, int arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                NonEmptyData s0_ = new NonEmptyData();
                s0_.utf32Compact0Profile_ = (ConditionProfile.create());
                s0_.utf32Compact1Profile_ = (ConditionProfile.create());
                s0_.outOfMemoryProfile_ = (BranchProfile.create());
                VarHandle.storeStoreFence();
                this.nonEmpty_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doNonEmpty(int[], int, int, ConditionProfile, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                return doNonEmpty(arg0Value, arg1Value, arg2Value, s0_.utf32Compact0Profile_, s0_.utf32Compact1Profile_, s0_.outOfMemoryProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static FromIntArrayUTF32Node create() {
            return new FromIntArrayUTF32NodeGen();
        }

        public static FromIntArrayUTF32Node getUncached() {
            return FromIntArrayUTF32NodeGen.UNCACHED;
        }

        @GeneratedBy(FromIntArrayUTF32Node.class)
        private static final class NonEmptyData {

            @CompilationFinal ConditionProfile utf32Compact0Profile_;
            @CompilationFinal ConditionProfile utf32Compact1Profile_;
            @CompilationFinal BranchProfile outOfMemoryProfile_;

            NonEmptyData() {
            }

        }
        @GeneratedBy(FromIntArrayUTF32Node.class)
        @DenyReplace
        private static final class Uncached extends FromIntArrayUTF32Node {

            @TruffleBoundary
            @Override
            public TruffleString execute(int[] arg0Value, int arg1Value, int arg2Value) {
                return doNonEmpty(arg0Value, arg1Value, arg2Value, (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode.class)
    static final class FromNativePointerNodeGen extends com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private FromNativePointerData fromNativePointer_cache;

        private FromNativePointerNodeGen() {
        }

        @Override
        public TruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 fromNativePointer(Object, int, int, Encoding, boolean, Node, FromNativePointerNode, FromBufferWithStringCompactionNode) */) {
                FromNativePointerData s0_ = this.fromNativePointer_cache;
                if (s0_ != null) {
                    return fromNativePointer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.interopLibrary_, s0_.fromNativePointerNode_, s0_.fromBufferWithStringCompactionNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private TruffleString executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                FromNativePointerData s0_ = super.insert(new FromNativePointerData());
                s0_.interopLibrary_ = s0_.insertAccessor((TStringAccessor.createInteropLibrary()));
                s0_.fromNativePointerNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.FromNativePointerNodeGen.create()));
                s0_.fromBufferWithStringCompactionNode_ = s0_.insertAccessor((FromBufferWithStringCompactionNodeGen.create()));
                VarHandle.storeStoreFence();
                this.fromNativePointer_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 fromNativePointer(Object, int, int, Encoding, boolean, Node, FromNativePointerNode, FromBufferWithStringCompactionNode) */;
                lock.unlock();
                hasLock = false;
                return fromNativePointer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.interopLibrary_, s0_.fromNativePointerNode_, s0_.fromBufferWithStringCompactionNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.FromNativePointerNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode getUncached() {
            return FromNativePointerNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode.class)
        private static final class FromNativePointerData extends Node {

            @Child Node interopLibrary_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.FromNativePointerNode fromNativePointerNode_;
            @Child FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode_;

            FromNativePointerData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.FromNativePointerNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(Object arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return fromNativePointer(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (TStringAccessor.getUncachedInteropLibrary()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.FromNativePointerNodeGen.getUncached()), (FromBufferWithStringCompactionNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AsTruffleStringNode.class)
    static final class AsTruffleStringNodeGen extends AsTruffleStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private FromMutableStringData fromMutableString_cache;

        private AsTruffleStringNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 immutable(TruffleString, Encoding) || fromMutableString(MutableTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 immutable(TruffleString, Encoding) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return AsTruffleStringNode.immutable(arg0Value_, arg1Value);
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 fromMutableString(MutableTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    FromMutableStringData s1_ = this.fromMutableString_cache;
                    if (s1_ != null) {
                        return AsTruffleStringNode.fromMutableString(arg0Value_, arg1Value, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.fromBufferWithStringCompactionNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 immutable(TruffleString, Encoding) */;
                    lock.unlock();
                    hasLock = false;
                    return AsTruffleStringNode.immutable(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    FromMutableStringData s1_ = super.insert(new FromMutableStringData());
                    s1_.getCodePointLengthNode_ = s1_.insertAccessor((GetCodePointLengthNodeGen.create()));
                    s1_.getCodeRangeNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.fromBufferWithStringCompactionNode_ = s1_.insertAccessor((FromBufferWithStringCompactionKnownAttributesNodeGen.create()));
                    VarHandle.storeStoreFence();
                    this.fromMutableString_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 fromMutableString(MutableTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */;
                    lock.unlock();
                    hasLock = false;
                    return AsTruffleStringNode.fromMutableString(arg0Value_, arg1Value, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.fromBufferWithStringCompactionNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AsTruffleStringNode create() {
            return new AsTruffleStringNodeGen();
        }

        public static AsTruffleStringNode getUncached() {
            return AsTruffleStringNodeGen.UNCACHED;
        }

        @GeneratedBy(AsTruffleStringNode.class)
        private static final class FromMutableStringData extends Node {

            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child FromBufferWithStringCompactionKnownAttributesNode fromBufferWithStringCompactionNode_;

            FromMutableStringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(AsTruffleStringNode.class)
        @DenyReplace
        private static final class Uncached extends AsTruffleStringNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return AsTruffleStringNode.immutable(arg0Value_, arg1Value);
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    return AsTruffleStringNode.fromMutableString(arg0Value_, arg1Value, (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (FromBufferWithStringCompactionKnownAttributesNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(AsManagedNode.class)
    static final class AsManagedNodeGen extends AsManagedNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private NativeOrMutableData nativeOrMutable_cache;

        private AsManagedNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 managedImmutable(TruffleString, Encoding) || nativeOrMutable(AbstractTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 managedImmutable(TruffleString, Encoding) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((!(arg0Value_.isNative()))) {
                        return AsManagedNode.managedImmutable(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 nativeOrMutable(AbstractTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */) {
                    NativeOrMutableData s1_ = this.nativeOrMutable_cache;
                    if (s1_ != null) {
                        if ((arg0Value.isNative() || arg0Value.isMutable())) {
                            return AsManagedNode.nativeOrMutable(arg0Value, arg1Value, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.fromBufferWithStringCompactionNode_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((!(arg0Value_.isNative()))) {
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 managedImmutable(TruffleString, Encoding) */;
                        lock.unlock();
                        hasLock = false;
                        return AsManagedNode.managedImmutable(arg0Value_, arg1Value);
                    }
                }
                if ((arg0Value.isNative() || arg0Value.isMutable())) {
                    NativeOrMutableData s1_ = super.insert(new NativeOrMutableData());
                    s1_.getCodePointLengthNode_ = s1_.insertAccessor((GetCodePointLengthNodeGen.create()));
                    s1_.getCodeRangeNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.fromBufferWithStringCompactionNode_ = s1_.insertAccessor((FromBufferWithStringCompactionKnownAttributesNodeGen.create()));
                    VarHandle.storeStoreFence();
                    this.nativeOrMutable_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 nativeOrMutable(AbstractTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */;
                    lock.unlock();
                    hasLock = false;
                    return AsManagedNode.nativeOrMutable(arg0Value, arg1Value, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.fromBufferWithStringCompactionNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static AsManagedNode create() {
            return new AsManagedNodeGen();
        }

        public static AsManagedNode getUncached() {
            return AsManagedNodeGen.UNCACHED;
        }

        @GeneratedBy(AsManagedNode.class)
        private static final class NativeOrMutableData extends Node {

            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child FromBufferWithStringCompactionKnownAttributesNode fromBufferWithStringCompactionNode_;

            NativeOrMutableData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(AsManagedNode.class)
        @DenyReplace
        private static final class Uncached extends AsManagedNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((!(arg0Value_.isNative()))) {
                        return AsManagedNode.managedImmutable(arg0Value_, arg1Value);
                    }
                }
                if ((arg0Value.isNative() || arg0Value.isMutable())) {
                    return AsManagedNode.nativeOrMutable(arg0Value, arg1Value, (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (FromBufferWithStringCompactionKnownAttributesNode.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ToIndexableNode.class)
    static final class ToIndexableNodeFactory {

        @GeneratedBy(ToIndexableImplNode.class)
        static final class ToIndexableImplNodeGen extends ToIndexableImplNode {

            @CompilationFinal private volatile int state_0_;
            @CompilationFinal private ConditionProfile nativeUnsupported_materializeProfile_;
            @CompilationFinal private ConditionProfile lazyLong_materializeProfile_;

            private ToIndexableImplNodeGen() {
            }

            @Override
            Object execute(AbstractTruffleString arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is-state_0 doByteArray(AbstractTruffleString, byte[]) || doNativeSupported(AbstractTruffleString, NativePointer) || doNativeUnsupported(AbstractTruffleString, NativePointer, ConditionProfile) || doLazyConcat(AbstractTruffleString, LazyConcat) || doLazyLong(AbstractTruffleString, LazyLong, ConditionProfile) */) {
                    if ((state_0 & 0b1) != 0 /* is-state_0 doByteArray(AbstractTruffleString, byte[]) */ && arg1Value instanceof byte[]) {
                        byte[] arg1Value_ = (byte[]) arg1Value;
                        return ToIndexableImplNode.doByteArray(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b110) != 0 /* is-state_0 doNativeSupported(AbstractTruffleString, NativePointer) || doNativeUnsupported(AbstractTruffleString, NativePointer, ConditionProfile) */ && arg1Value instanceof NativePointer) {
                        NativePointer arg1Value_ = (NativePointer) arg1Value;
                        if ((state_0 & 0b10) != 0 /* is-state_0 doNativeSupported(AbstractTruffleString, NativePointer) */) {
                            if ((TStringGuards.isSupportedEncoding(arg0Value.encoding()))) {
                                return ToIndexableImplNode.doNativeSupported(arg0Value, arg1Value_);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is-state_0 doNativeUnsupported(AbstractTruffleString, NativePointer, ConditionProfile) */) {
                            if ((!(TStringGuards.isSupportedEncoding(arg0Value.encoding())))) {
                                return ToIndexableImplNode.doNativeUnsupported(arg0Value, arg1Value_, this.nativeUnsupported_materializeProfile_);
                            }
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is-state_0 doLazyConcat(AbstractTruffleString, LazyConcat) */ && arg1Value instanceof LazyConcat) {
                        LazyConcat arg1Value_ = (LazyConcat) arg1Value;
                        return doLazyConcat(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b10000) != 0 /* is-state_0 doLazyLong(AbstractTruffleString, LazyLong, ConditionProfile) */ && arg1Value instanceof LazyLong) {
                        LazyLong arg1Value_ = (LazyLong) arg1Value;
                        return ToIndexableImplNode.doLazyLong(arg0Value, arg1Value_, this.lazyLong_materializeProfile_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(AbstractTruffleString arg0Value, Object arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                try {
                    int state_0 = this.state_0_;
                    if (arg1Value instanceof byte[]) {
                        byte[] arg1Value_ = (byte[]) arg1Value;
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doByteArray(AbstractTruffleString, byte[]) */;
                        lock.unlock();
                        hasLock = false;
                        return ToIndexableImplNode.doByteArray(arg0Value, arg1Value_);
                    }
                    if (arg1Value instanceof NativePointer) {
                        NativePointer arg1Value_ = (NativePointer) arg1Value;
                        if ((TStringGuards.isSupportedEncoding(arg0Value.encoding()))) {
                            this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doNativeSupported(AbstractTruffleString, NativePointer) */;
                            lock.unlock();
                            hasLock = false;
                            return ToIndexableImplNode.doNativeSupported(arg0Value, arg1Value_);
                        }
                        if ((!(TStringGuards.isSupportedEncoding(arg0Value.encoding())))) {
                            this.nativeUnsupported_materializeProfile_ = (ConditionProfile.create());
                            this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 doNativeUnsupported(AbstractTruffleString, NativePointer, ConditionProfile) */;
                            lock.unlock();
                            hasLock = false;
                            return ToIndexableImplNode.doNativeUnsupported(arg0Value, arg1Value_, this.nativeUnsupported_materializeProfile_);
                        }
                    }
                    if (arg1Value instanceof LazyConcat) {
                        LazyConcat arg1Value_ = (LazyConcat) arg1Value;
                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 doLazyConcat(AbstractTruffleString, LazyConcat) */;
                        lock.unlock();
                        hasLock = false;
                        return doLazyConcat(arg0Value, arg1Value_);
                    }
                    if (arg1Value instanceof LazyLong) {
                        LazyLong arg1Value_ = (LazyLong) arg1Value;
                        this.lazyLong_materializeProfile_ = (ConditionProfile.create());
                        this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doLazyLong(AbstractTruffleString, LazyLong, ConditionProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return ToIndexableImplNode.doLazyLong(arg0Value, arg1Value_, this.lazyLong_materializeProfile_);
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            public static ToIndexableImplNode create() {
                return new ToIndexableImplNodeGen();
            }

        }
    }
    @GeneratedBy(MaterializeNode.class)
    static final class MaterializeNodeGen extends MaterializeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ToIndexableNode toIndexableNode_;

        private MaterializeNodeGen() {
        }

        @Override
        public void execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doMaterialize(AbstractTruffleString, Encoding, ToIndexableNode) */) {
                MaterializeNode.doMaterialize(arg0Value, arg1Value, this.toIndexableNode_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.toIndexableNode_ = super.insert((ToIndexableNode.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doMaterialize(AbstractTruffleString, Encoding, ToIndexableNode) */;
                lock.unlock();
                hasLock = false;
                MaterializeNode.doMaterialize(arg0Value, arg1Value, this.toIndexableNode_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static MaterializeNode create() {
            return new MaterializeNodeGen();
        }

        public static MaterializeNode getUncached() {
            return MaterializeNodeGen.UNCACHED;
        }

        @GeneratedBy(MaterializeNode.class)
        @DenyReplace
        private static final class Uncached extends MaterializeNode {

            @TruffleBoundary
            @Override
            public void execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                MaterializeNode.doMaterialize(arg0Value, arg1Value, (ToIndexableNode.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode.class)
    static final class GetCodeRangeNodeGen extends com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;

        private GetCodeRangeNodeGen() {
        }

        @Override
        public CodeRange execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 getCodeRange(AbstractTruffleString, Encoding, GetCodeRangeNode) */) {
                return com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode.getCodeRange(arg0Value, arg1Value, this.getCodeRangeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private CodeRange executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.getCodeRangeNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getCodeRange(AbstractTruffleString, Encoding, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode.getCodeRange(arg0Value, arg1Value, this.getCodeRangeNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.GetCodeRangeNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode getUncached() {
            return GetCodeRangeNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode {

            @TruffleBoundary
            @Override
            public CodeRange execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                return com.oracle.truffle.api.strings.TruffleString.GetCodeRangeNode.getCodeRange(arg0Value, arg1Value, (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(GetByteCodeRangeNode.class)
    static final class GetByteCodeRangeNodeGen extends GetByteCodeRangeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;

        private GetByteCodeRangeNodeGen() {
        }

        @Override
        public CodeRange execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 getCodeRange(AbstractTruffleString, Encoding, GetCodeRangeNode) */) {
                return GetByteCodeRangeNode.getCodeRange(arg0Value, arg1Value, this.getCodeRangeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private CodeRange executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.getCodeRangeNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getCodeRange(AbstractTruffleString, Encoding, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return GetByteCodeRangeNode.getCodeRange(arg0Value, arg1Value, this.getCodeRangeNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static GetByteCodeRangeNode create() {
            return new GetByteCodeRangeNodeGen();
        }

        public static GetByteCodeRangeNode getUncached() {
            return GetByteCodeRangeNodeGen.UNCACHED;
        }

        @GeneratedBy(GetByteCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached extends GetByteCodeRangeNode {

            @TruffleBoundary
            @Override
            public CodeRange execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                return GetByteCodeRangeNode.getCodeRange(arg0Value, arg1Value, (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodeRangeEqualsNode.class)
    static final class CodeRangeEqualsNodeGen extends CodeRangeEqualsNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;

        private CodeRangeEqualsNodeGen() {
        }

        @Override
        public boolean execute(AbstractTruffleString arg0Value, CodeRange arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 codeRangeEquals(AbstractTruffleString, CodeRange, GetCodeRangeNode) */) {
                return CodeRangeEqualsNode.codeRangeEquals(arg0Value, arg1Value, this.getCodeRangeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, CodeRange arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.getCodeRangeNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 codeRangeEquals(AbstractTruffleString, CodeRange, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return CodeRangeEqualsNode.codeRangeEquals(arg0Value, arg1Value, this.getCodeRangeNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CodeRangeEqualsNode create() {
            return new CodeRangeEqualsNodeGen();
        }

        public static CodeRangeEqualsNode getUncached() {
            return CodeRangeEqualsNodeGen.UNCACHED;
        }

        @GeneratedBy(CodeRangeEqualsNode.class)
        @DenyReplace
        private static final class Uncached extends CodeRangeEqualsNode {

            @TruffleBoundary
            @Override
            public boolean execute(AbstractTruffleString arg0Value, CodeRange arg1Value) {
                return CodeRangeEqualsNode.codeRangeEquals(arg0Value, arg1Value, (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IsValidNode.class)
    static final class IsValidNodeGen extends IsValidNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;

        private IsValidNodeGen() {
        }

        @Override
        public boolean execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 isValid(AbstractTruffleString, Encoding, GetCodeRangeNode) */) {
                return IsValidNode.isValid(arg0Value, arg1Value, this.getCodeRangeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.getCodeRangeNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 isValid(AbstractTruffleString, Encoding, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return IsValidNode.isValid(arg0Value, arg1Value, this.getCodeRangeNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static IsValidNode create() {
            return new IsValidNodeGen();
        }

        public static IsValidNode getUncached() {
            return IsValidNodeGen.UNCACHED;
        }

        @GeneratedBy(IsValidNode.class)
        @DenyReplace
        private static final class Uncached extends IsValidNode {

            @TruffleBoundary
            @Override
            public boolean execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                return IsValidNode.isValid(arg0Value, arg1Value, (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodePointLengthNode.class)
    static final class CodePointLengthNodeGen extends CodePointLengthNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private GetCodePointLengthNode getCodePointLengthNode_;

        private CodePointLengthNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 get(AbstractTruffleString, Encoding, GetCodePointLengthNode) */) {
                return CodePointLengthNode.get(arg0Value, arg1Value, this.getCodePointLengthNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.getCodePointLengthNode_ = super.insert((GetCodePointLengthNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 get(AbstractTruffleString, Encoding, GetCodePointLengthNode) */;
                lock.unlock();
                hasLock = false;
                return CodePointLengthNode.get(arg0Value, arg1Value, this.getCodePointLengthNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CodePointLengthNode create() {
            return new CodePointLengthNodeGen();
        }

        public static CodePointLengthNode getUncached() {
            return CodePointLengthNodeGen.UNCACHED;
        }

        @GeneratedBy(CodePointLengthNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointLengthNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                return CodePointLengthNode.get(arg0Value, arg1Value, (GetCodePointLengthNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(HashCodeNode.class)
    static final class HashCodeNodeGen extends HashCodeNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CalculateHashData calculateHash_cache;

        private HashCodeNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 calculateHash(AbstractTruffleString, Encoding, ConditionProfile, ToIndexableNode, CalculateHashCodeNode) */) {
                CalculateHashData s0_ = this.calculateHash_cache;
                if (s0_ != null) {
                    return HashCodeNode.calculateHash(arg0Value, arg1Value, s0_.cacheMiss_, s0_.toIndexableNode_, s0_.calculateHashCodeNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                CalculateHashData s0_ = super.insert(new CalculateHashData());
                s0_.cacheMiss_ = (ConditionProfile.create());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.calculateHashCodeNode_ = s0_.insertAccessor((CalculateHashCodeNodeGen.create()));
                VarHandle.storeStoreFence();
                this.calculateHash_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 calculateHash(AbstractTruffleString, Encoding, ConditionProfile, ToIndexableNode, CalculateHashCodeNode) */;
                lock.unlock();
                hasLock = false;
                return HashCodeNode.calculateHash(arg0Value, arg1Value, s0_.cacheMiss_, s0_.toIndexableNode_, s0_.calculateHashCodeNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static HashCodeNode create() {
            return new HashCodeNodeGen();
        }

        public static HashCodeNode getUncached() {
            return HashCodeNodeGen.UNCACHED;
        }

        @GeneratedBy(HashCodeNode.class)
        private static final class CalculateHashData extends Node {

            @CompilationFinal ConditionProfile cacheMiss_;
            @Child ToIndexableNode toIndexableNode_;
            @Child CalculateHashCodeNode calculateHashCodeNode_;

            CalculateHashData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(HashCodeNode.class)
        @DenyReplace
        private static final class Uncached extends HashCodeNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                return HashCodeNode.calculateHash(arg0Value, arg1Value, (ConditionProfile.getUncached()), (ToIndexableNode.getUncached()), (CalculateHashCodeNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ReadByteNode.class)
    static final class ReadByteNodeGen extends com.oracle.truffle.api.strings.TruffleString.ReadByteNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ToIndexableNode toIndexableNode_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.ReadByteNode readByteNode_;

        private ReadByteNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doRead(AbstractTruffleString, int, Encoding, ToIndexableNode, ReadByteNode) */) {
                return com.oracle.truffle.api.strings.TruffleString.ReadByteNode.doRead(arg0Value, arg1Value, arg2Value, this.toIndexableNode_, this.readByteNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.toIndexableNode_ = super.insert((ToIndexableNode.create()));
                this.readByteNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.ReadByteNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doRead(AbstractTruffleString, int, Encoding, ToIndexableNode, ReadByteNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.ReadByteNode.doRead(arg0Value, arg1Value, arg2Value, this.toIndexableNode_, this.readByteNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.ReadByteNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.ReadByteNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.ReadByteNode getUncached() {
            return ReadByteNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ReadByteNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.ReadByteNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value) {
                return com.oracle.truffle.api.strings.TruffleString.ReadByteNode.doRead(arg0Value, arg1Value, arg2Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.ReadByteNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ReadCharUTF16Node.class)
    static final class ReadCharUTF16NodeGen extends ReadCharUTF16Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ToIndexableNode toIndexableNode_;
        @CompilationFinal private ConditionProfile utf16S0Profile_;

        private ReadCharUTF16NodeGen() {
        }

        @Override
        public char execute(AbstractTruffleString arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doRead(AbstractTruffleString, int, ToIndexableNode, ConditionProfile) */) {
                return ReadCharUTF16Node.doRead(arg0Value, arg1Value, this.toIndexableNode_, this.utf16S0Profile_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private char executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.toIndexableNode_ = super.insert((ToIndexableNode.create()));
                this.utf16S0Profile_ = (ConditionProfile.create());
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doRead(AbstractTruffleString, int, ToIndexableNode, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return ReadCharUTF16Node.doRead(arg0Value, arg1Value, this.toIndexableNode_, this.utf16S0Profile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ReadCharUTF16Node create() {
            return new ReadCharUTF16NodeGen();
        }

        public static ReadCharUTF16Node getUncached() {
            return ReadCharUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(ReadCharUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends ReadCharUTF16Node {

            @TruffleBoundary
            @Override
            public char execute(AbstractTruffleString arg0Value, int arg1Value) {
                return ReadCharUTF16Node.doRead(arg0Value, arg1Value, (ToIndexableNode.getUncached()), (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode.class)
    static final class ByteLengthOfCodePointNodeGen extends com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private TranslateData translate_cache;

        private ByteLengthOfCodePointNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 translate(AbstractTruffleString, int, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode, ByteLengthOfCodePointNode) */) {
                TranslateData s0_ = this.translate_cache;
                if (s0_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.byteLengthOfCodePointNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                TranslateData s0_ = super.insert(new TranslateData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.byteLengthOfCodePointNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.ByteLengthOfCodePointNodeGen.create()));
                VarHandle.storeStoreFence();
                this.translate_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 translate(AbstractTruffleString, int, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode, ByteLengthOfCodePointNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.byteLengthOfCodePointNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.ByteLengthOfCodePointNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode getUncached() {
            return ByteLengthOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode.class)
        private static final class TranslateData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.ByteLengthOfCodePointNode byteLengthOfCodePointNode_;

            TranslateData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
                return com.oracle.truffle.api.strings.TruffleString.ByteLengthOfCodePointNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.ByteLengthOfCodePointNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ByteIndexToCodePointIndexNode.class)
    static final class ByteIndexToCodePointIndexNodeGen extends ByteIndexToCodePointIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private TranslateData translate_cache;

        private ByteIndexToCodePointIndexNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 translate(AbstractTruffleString, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, RawIndexToCodePointIndexNode) */) {
                TranslateData s0_ = this.translate_cache;
                if (s0_ != null) {
                    return ByteIndexToCodePointIndexNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.rawIndexToCodePointIndexNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                TranslateData s0_ = super.insert(new TranslateData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.rawIndexToCodePointIndexNode_ = s0_.insertAccessor((RawIndexToCodePointIndexNodeGen.create()));
                VarHandle.storeStoreFence();
                this.translate_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 translate(AbstractTruffleString, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, RawIndexToCodePointIndexNode) */;
                lock.unlock();
                hasLock = false;
                return ByteIndexToCodePointIndexNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.rawIndexToCodePointIndexNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ByteIndexToCodePointIndexNode create() {
            return new ByteIndexToCodePointIndexNodeGen();
        }

        public static ByteIndexToCodePointIndexNode getUncached() {
            return ByteIndexToCodePointIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(ByteIndexToCodePointIndexNode.class)
        private static final class TranslateData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child RawIndexToCodePointIndexNode rawIndexToCodePointIndexNode_;

            TranslateData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ByteIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Uncached extends ByteIndexToCodePointIndexNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
                return ByteIndexToCodePointIndexNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (RawIndexToCodePointIndexNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodePointIndexToByteIndexNode.class)
    static final class CodePointIndexToByteIndexNodeGen extends CodePointIndexToByteIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private TranslateData translate_cache;

        private CodePointIndexToByteIndexNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 translate(AbstractTruffleString, int, int, Encoding, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, CodePointIndexToRawNode) */) {
                TranslateData s0_ = this.translate_cache;
                if (s0_ != null) {
                    return CodePointIndexToByteIndexNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.codePointIndexToRawNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                TranslateData s0_ = super.insert(new TranslateData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.codePointIndexToRawNode_ = s0_.insertAccessor((CodePointIndexToRawNodeGen.create()));
                VarHandle.storeStoreFence();
                this.translate_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 translate(AbstractTruffleString, int, int, Encoding, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, CodePointIndexToRawNode) */;
                lock.unlock();
                hasLock = false;
                return CodePointIndexToByteIndexNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.codePointIndexToRawNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CodePointIndexToByteIndexNode create() {
            return new CodePointIndexToByteIndexNodeGen();
        }

        public static CodePointIndexToByteIndexNode getUncached() {
            return CodePointIndexToByteIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(CodePointIndexToByteIndexNode.class)
        private static final class TranslateData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child CodePointIndexToRawNode codePointIndexToRawNode_;

            TranslateData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CodePointIndexToByteIndexNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointIndexToByteIndexNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value) {
                return CodePointIndexToByteIndexNode.translate(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (CodePointIndexToRawNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodePointAtIndexNode.class)
    static final class CodePointAtIndexNodeGen extends CodePointAtIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ReadCodePointData readCodePoint_cache;

        private CodePointAtIndexNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 readCodePoint(AbstractTruffleString, int, Encoding, ErrorHandling, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, CodePointAtNode) */) {
                ReadCodePointData s0_ = this.readCodePoint_cache;
                if (s0_ != null) {
                    return CodePointAtIndexNode.readCodePoint(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.readCodePointNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                ReadCodePointData s0_ = super.insert(new ReadCodePointData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.readCodePointNode_ = s0_.insertAccessor((CodePointAtNodeGen.create()));
                VarHandle.storeStoreFence();
                this.readCodePoint_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 readCodePoint(AbstractTruffleString, int, Encoding, ErrorHandling, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, CodePointAtNode) */;
                lock.unlock();
                hasLock = false;
                return CodePointAtIndexNode.readCodePoint(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.readCodePointNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CodePointAtIndexNode create() {
            return new CodePointAtIndexNodeGen();
        }

        public static CodePointAtIndexNode getUncached() {
            return CodePointAtIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(CodePointAtIndexNode.class)
        private static final class ReadCodePointData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child CodePointAtNode readCodePointNode_;

            ReadCodePointData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CodePointAtIndexNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtIndexNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
                return CodePointAtIndexNode.readCodePoint(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (CodePointAtNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CodePointAtByteIndexNode.class)
    static final class CodePointAtByteIndexNodeGen extends CodePointAtByteIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ReadCodePointData readCodePoint_cache;

        private CodePointAtByteIndexNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 readCodePoint(AbstractTruffleString, int, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode, CodePointAtRawNode) */) {
                ReadCodePointData s0_ = this.readCodePoint_cache;
                if (s0_ != null) {
                    return CodePointAtByteIndexNode.readCodePoint(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.readCodePointNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                ReadCodePointData s0_ = super.insert(new ReadCodePointData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.readCodePointNode_ = s0_.insertAccessor((CodePointAtRawNodeGen.create()));
                VarHandle.storeStoreFence();
                this.readCodePoint_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 readCodePoint(AbstractTruffleString, int, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode, CodePointAtRawNode) */;
                lock.unlock();
                hasLock = false;
                return CodePointAtByteIndexNode.readCodePoint(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.readCodePointNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CodePointAtByteIndexNode create() {
            return new CodePointAtByteIndexNodeGen();
        }

        public static CodePointAtByteIndexNode getUncached() {
            return CodePointAtByteIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(CodePointAtByteIndexNode.class)
        private static final class ReadCodePointData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child CodePointAtRawNode readCodePointNode_;

            ReadCodePointData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CodePointAtByteIndexNode.class)
        @DenyReplace
        private static final class Uncached extends CodePointAtByteIndexNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value, ErrorHandling arg3Value) {
                return CodePointAtByteIndexNode.readCodePoint(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (CodePointAtRawNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ByteIndexOfAnyByteNode.class)
    static final class ByteIndexOfAnyByteNodeGen extends ByteIndexOfAnyByteNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ToIndexableNode toIndexableNode_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;

        private ByteIndexOfAnyByteNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, byte[] arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 indexOfRaw(AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, GetCodeRangeNode) */) {
                return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.toIndexableNode_, this.getCodeRangeNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, byte[] arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.toIndexableNode_ = super.insert((ToIndexableNode.create()));
                this.getCodeRangeNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 indexOfRaw(AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.toIndexableNode_, this.getCodeRangeNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ByteIndexOfAnyByteNode create() {
            return new ByteIndexOfAnyByteNodeGen();
        }

        public static ByteIndexOfAnyByteNode getUncached() {
            return ByteIndexOfAnyByteNodeGen.UNCACHED;
        }

        @GeneratedBy(ByteIndexOfAnyByteNode.class)
        @DenyReplace
        private static final class Uncached extends ByteIndexOfAnyByteNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, byte[] arg3Value, Encoding arg4Value) {
                return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CharIndexOfAnyCharUTF16Node.class)
    static final class CharIndexOfAnyCharUTF16NodeGen extends CharIndexOfAnyCharUTF16Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfRawData indexOfRaw_cache;

        private CharIndexOfAnyCharUTF16NodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, char[] arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 indexOfRaw(AbstractTruffleString, int, int, char[], ToIndexableNode, GetCodeRangeNode, IndexOfAnyCharNode) */) {
                IndexOfRawData s0_ = this.indexOfRaw_cache;
                if (s0_ != null) {
                    return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, char[] arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfRawData s0_ = super.insert(new IndexOfRawData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfNode_ = s0_.insertAccessor((IndexOfAnyCharNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOfRaw_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 indexOfRaw(AbstractTruffleString, int, int, char[], ToIndexableNode, GetCodeRangeNode, IndexOfAnyCharNode) */;
                lock.unlock();
                hasLock = false;
                return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CharIndexOfAnyCharUTF16Node create() {
            return new CharIndexOfAnyCharUTF16NodeGen();
        }

        public static CharIndexOfAnyCharUTF16Node getUncached() {
            return CharIndexOfAnyCharUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(CharIndexOfAnyCharUTF16Node.class)
        private static final class IndexOfRawData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child IndexOfAnyCharNode indexOfNode_;

            IndexOfRawData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CharIndexOfAnyCharUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends CharIndexOfAnyCharUTF16Node {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, char[] arg3Value) {
                return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (IndexOfAnyCharNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(IntIndexOfAnyIntUTF32Node.class)
    static final class IntIndexOfAnyIntUTF32NodeGen extends IntIndexOfAnyIntUTF32Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfRawData indexOfRaw_cache;

        private IntIndexOfAnyIntUTF32NodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int[] arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 indexOfRaw(AbstractTruffleString, int, int, int[], ToIndexableNode, GetCodeRangeNode, IndexOfAnyIntNode) */) {
                IndexOfRawData s0_ = this.indexOfRaw_cache;
                if (s0_ != null) {
                    return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int[] arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfRawData s0_ = super.insert(new IndexOfRawData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfNode_ = s0_.insertAccessor((IndexOfAnyIntNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOfRaw_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 indexOfRaw(AbstractTruffleString, int, int, int[], ToIndexableNode, GetCodeRangeNode, IndexOfAnyIntNode) */;
                lock.unlock();
                hasLock = false;
                return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static IntIndexOfAnyIntUTF32Node create() {
            return new IntIndexOfAnyIntUTF32NodeGen();
        }

        public static IntIndexOfAnyIntUTF32Node getUncached() {
            return IntIndexOfAnyIntUTF32NodeGen.UNCACHED;
        }

        @GeneratedBy(IntIndexOfAnyIntUTF32Node.class)
        private static final class IndexOfRawData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child IndexOfAnyIntNode indexOfNode_;

            IndexOfRawData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(IntIndexOfAnyIntUTF32Node.class)
        @DenyReplace
        private static final class Uncached extends IntIndexOfAnyIntUTF32Node {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int[] arg3Value) {
                return indexOfRaw(arg0Value, arg1Value, arg2Value, arg3Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (IndexOfAnyIntNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode.class)
    static final class IndexOfCodePointNodeGen extends com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfData indexOf_cache;

        private IndexOfCodePointNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, IndexOfCodePointNode) */) {
                IndexOfData s0_ = this.indexOf_cache;
                if (s0_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfData s0_ = super.insert(new IndexOfData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.IndexOfCodePointNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOf_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, IndexOfCodePointNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.IndexOfCodePointNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode getUncached() {
            return IndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode.class)
        private static final class IndexOfData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfCodePointNode indexOfNode_;

            IndexOfData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
                return com.oracle.truffle.api.strings.TruffleString.IndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.IndexOfCodePointNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ByteIndexOfCodePointNode.class)
    static final class ByteIndexOfCodePointNodeGen extends ByteIndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfData indexOf_cache;

        private ByteIndexOfCodePointNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, IndexOfCodePointRawNode) */) {
                IndexOfData s0_ = this.indexOf_cache;
                if (s0_ != null) {
                    return ByteIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfData s0_ = super.insert(new IndexOfData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfNode_ = s0_.insertAccessor((IndexOfCodePointRawNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOf_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, IndexOfCodePointRawNode) */;
                lock.unlock();
                hasLock = false;
                return ByteIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.indexOfNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ByteIndexOfCodePointNode create() {
            return new ByteIndexOfCodePointNodeGen();
        }

        public static ByteIndexOfCodePointNode getUncached() {
            return ByteIndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(ByteIndexOfCodePointNode.class)
        private static final class IndexOfData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child IndexOfCodePointRawNode indexOfNode_;

            IndexOfData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ByteIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends ByteIndexOfCodePointNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
                return ByteIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (IndexOfCodePointRawNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode.class)
    static final class LastIndexOfCodePointNodeGen extends com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfData indexOf_cache;

        private LastIndexOfCodePointNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, LastIndexOfCodePointNode) */) {
                IndexOfData s0_ = this.indexOf_cache;
                if (s0_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.lastIndexOfNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfData s0_ = super.insert(new IndexOfData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.lastIndexOfNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.LastIndexOfCodePointNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOf_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodePointLengthNode, GetCodeRangeNode, LastIndexOfCodePointNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodePointLengthNode_, s0_.getCodeRangeNode_, s0_.lastIndexOfNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.LastIndexOfCodePointNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode getUncached() {
            return LastIndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode.class)
        private static final class IndexOfData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfCodePointNode lastIndexOfNode_;

            IndexOfData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
                return com.oracle.truffle.api.strings.TruffleString.LastIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.LastIndexOfCodePointNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LastByteIndexOfCodePointNode.class)
    static final class LastByteIndexOfCodePointNodeGen extends LastByteIndexOfCodePointNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfData indexOf_cache;

        private LastByteIndexOfCodePointNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, LastIndexOfCodePointRawNode) */) {
                IndexOfData s0_ = this.indexOf_cache;
                if (s0_ != null) {
                    return LastByteIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.lastIndexOfNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfData s0_ = super.insert(new IndexOfData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.lastIndexOfNode_ = s0_.insertAccessor((LastIndexOfCodePointRawNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOf_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doIndexOf(AbstractTruffleString, int, int, int, Encoding, ToIndexableNode, GetCodeRangeNode, LastIndexOfCodePointRawNode) */;
                lock.unlock();
                hasLock = false;
                return LastByteIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.lastIndexOfNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static LastByteIndexOfCodePointNode create() {
            return new LastByteIndexOfCodePointNodeGen();
        }

        public static LastByteIndexOfCodePointNode getUncached() {
            return LastByteIndexOfCodePointNodeGen.UNCACHED;
        }

        @GeneratedBy(LastByteIndexOfCodePointNode.class)
        private static final class IndexOfData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child LastIndexOfCodePointRawNode lastIndexOfNode_;

            IndexOfData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(LastByteIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached extends LastByteIndexOfCodePointNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
                return LastByteIndexOfCodePointNode.doIndexOf(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (LastIndexOfCodePointRawNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode.class)
    static final class IndexOfStringNodeGen extends com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfStringData indexOfString_cache;

        private IndexOfStringNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 indexOfString(AbstractTruffleString, AbstractTruffleString, int, int, Encoding, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, GetCodeRangeNode, GetCodeRangeNode, IndexOfStringNode) */) {
                IndexOfStringData s0_ = this.indexOfString_cache;
                if (s0_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode.indexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfStringData s0_ = super.insert(new IndexOfStringData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthANode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodePointLengthBNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfStringNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.IndexOfStringNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOfString_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 indexOfString(AbstractTruffleString, AbstractTruffleString, int, int, Encoding, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, GetCodeRangeNode, GetCodeRangeNode, IndexOfStringNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode.indexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.IndexOfStringNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode getUncached() {
            return IndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode.class)
        private static final class IndexOfStringData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child GetCodePointLengthNode getCodePointLengthANode_;
            @Child GetCodePointLengthNode getCodePointLengthBNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.IndexOfStringNode indexOfStringNode_;

            IndexOfStringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
                return com.oracle.truffle.api.strings.TruffleString.IndexOfStringNode.indexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.IndexOfStringNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ByteIndexOfStringNode.class)
    static final class ByteIndexOfStringNodeGen extends ByteIndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private IndexOfStringData indexOfString_cache;

        private ByteIndexOfStringNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, byte[] arg4Value, Encoding arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 indexOfString(AbstractTruffleString, AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode, IndexOfStringRawNode) */) {
                IndexOfStringData s0_ = this.indexOfString_cache;
                if (s0_ != null) {
                    return ByteIndexOfStringNode.indexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, byte[] arg4Value, Encoding arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                IndexOfStringData s0_ = super.insert(new IndexOfStringData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfStringNode_ = s0_.insertAccessor((IndexOfStringRawNodeGen.create()));
                VarHandle.storeStoreFence();
                this.indexOfString_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 indexOfString(AbstractTruffleString, AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode, IndexOfStringRawNode) */;
                lock.unlock();
                hasLock = false;
                return ByteIndexOfStringNode.indexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static ByteIndexOfStringNode create() {
            return new ByteIndexOfStringNodeGen();
        }

        public static ByteIndexOfStringNode getUncached() {
            return ByteIndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(ByteIndexOfStringNode.class)
        private static final class IndexOfStringData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;
            @Child IndexOfStringRawNode indexOfStringNode_;

            IndexOfStringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ByteIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends ByteIndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, byte[] arg4Value, Encoding arg5Value) {
                return ByteIndexOfStringNode.indexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (IndexOfStringRawNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode.class)
    static final class LastIndexOfStringNodeGen extends com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private LastIndexOfStringData lastIndexOfString_cache;

        private LastIndexOfStringNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 lastIndexOfString(AbstractTruffleString, AbstractTruffleString, int, int, Encoding, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, GetCodeRangeNode, GetCodeRangeNode, LastIndexOfStringNode) */) {
                LastIndexOfStringData s0_ = this.lastIndexOfString_cache;
                if (s0_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode.lastIndexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                LastIndexOfStringData s0_ = super.insert(new LastIndexOfStringData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthANode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodePointLengthBNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfStringNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.LastIndexOfStringNodeGen.create()));
                VarHandle.storeStoreFence();
                this.lastIndexOfString_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 lastIndexOfString(AbstractTruffleString, AbstractTruffleString, int, int, Encoding, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, GetCodeRangeNode, GetCodeRangeNode, LastIndexOfStringNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode.lastIndexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.LastIndexOfStringNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode getUncached() {
            return LastIndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode.class)
        private static final class LastIndexOfStringData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child GetCodePointLengthNode getCodePointLengthANode_;
            @Child GetCodePointLengthNode getCodePointLengthBNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.LastIndexOfStringNode indexOfStringNode_;

            LastIndexOfStringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, Encoding arg4Value) {
                return com.oracle.truffle.api.strings.TruffleString.LastIndexOfStringNode.lastIndexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.LastIndexOfStringNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(LastByteIndexOfStringNode.class)
    static final class LastByteIndexOfStringNodeGen extends LastByteIndexOfStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private LastByteIndexOfStringData lastByteIndexOfString_cache;

        private LastByteIndexOfStringNodeGen() {
        }

        @Override
        int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, byte[] arg4Value, Encoding arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 lastByteIndexOfString(AbstractTruffleString, AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode, LastIndexOfStringRawNode) */) {
                LastByteIndexOfStringData s0_ = this.lastByteIndexOfString_cache;
                if (s0_ != null) {
                    return LastByteIndexOfStringNode.lastByteIndexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, byte[] arg4Value, Encoding arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                LastByteIndexOfStringData s0_ = super.insert(new LastByteIndexOfStringData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.indexOfStringNode_ = s0_.insertAccessor((LastIndexOfStringRawNodeGen.create()));
                VarHandle.storeStoreFence();
                this.lastByteIndexOfString_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 lastByteIndexOfString(AbstractTruffleString, AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode, LastIndexOfStringRawNode) */;
                lock.unlock();
                hasLock = false;
                return LastByteIndexOfStringNode.lastByteIndexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.indexOfStringNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static LastByteIndexOfStringNode create() {
            return new LastByteIndexOfStringNodeGen();
        }

        public static LastByteIndexOfStringNode getUncached() {
            return LastByteIndexOfStringNodeGen.UNCACHED;
        }

        @GeneratedBy(LastByteIndexOfStringNode.class)
        private static final class LastByteIndexOfStringData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;
            @Child LastIndexOfStringRawNode indexOfStringNode_;

            LastByteIndexOfStringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(LastByteIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached extends LastByteIndexOfStringNode {

            @TruffleBoundary
            @Override
            int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, int arg2Value, int arg3Value, byte[] arg4Value, Encoding arg5Value) {
                return LastByteIndexOfStringNode.lastByteIndexOfString(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (LastIndexOfStringRawNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CompareBytesNode.class)
    static final class CompareBytesNodeGen extends CompareBytesNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CompareData compare_cache;

        private CompareBytesNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 compare(AbstractTruffleString, AbstractTruffleString, Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */) {
                CompareData s0_ = this.compare_cache;
                if (s0_ != null) {
                    return compare(arg0Value, arg1Value, arg2Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                CompareData s0_ = super.insert(new CompareData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                VarHandle.storeStoreFence();
                this.compare_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 compare(AbstractTruffleString, AbstractTruffleString, Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return compare(arg0Value, arg1Value, arg2Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CompareBytesNode create() {
            return new CompareBytesNodeGen();
        }

        public static CompareBytesNode getUncached() {
            return CompareBytesNodeGen.UNCACHED;
        }

        @GeneratedBy(CompareBytesNode.class)
        private static final class CompareData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;

            CompareData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CompareBytesNode.class)
        @DenyReplace
        private static final class Uncached extends CompareBytesNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                return compare(arg0Value, arg1Value, arg2Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CompareCharsUTF16Node.class)
    static final class CompareCharsUTF16NodeGen extends CompareCharsUTF16Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CompareData compare_cache;

        private CompareCharsUTF16NodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 compare(AbstractTruffleString, AbstractTruffleString, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */) {
                CompareData s0_ = this.compare_cache;
                if (s0_ != null) {
                    return compare(arg0Value, arg1Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                CompareData s0_ = super.insert(new CompareData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                VarHandle.storeStoreFence();
                this.compare_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 compare(AbstractTruffleString, AbstractTruffleString, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return compare(arg0Value, arg1Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CompareCharsUTF16Node create() {
            return new CompareCharsUTF16NodeGen();
        }

        public static CompareCharsUTF16Node getUncached() {
            return CompareCharsUTF16NodeGen.UNCACHED;
        }

        @GeneratedBy(CompareCharsUTF16Node.class)
        private static final class CompareData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;

            CompareData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CompareCharsUTF16Node.class)
        @DenyReplace
        private static final class Uncached extends CompareCharsUTF16Node {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value) {
                return compare(arg0Value, arg1Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CompareIntsUTF32Node.class)
    static final class CompareIntsUTF32NodeGen extends CompareIntsUTF32Node {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CompareData compare_cache;

        private CompareIntsUTF32NodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 compare(AbstractTruffleString, AbstractTruffleString, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */) {
                CompareData s0_ = this.compare_cache;
                if (s0_ != null) {
                    return compare(arg0Value, arg1Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                CompareData s0_ = super.insert(new CompareData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                VarHandle.storeStoreFence();
                this.compare_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 compare(AbstractTruffleString, AbstractTruffleString, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return compare(arg0Value, arg1Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CompareIntsUTF32Node create() {
            return new CompareIntsUTF32NodeGen();
        }

        public static CompareIntsUTF32Node getUncached() {
            return CompareIntsUTF32NodeGen.UNCACHED;
        }

        @GeneratedBy(CompareIntsUTF32Node.class)
        private static final class CompareData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;

            CompareData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CompareIntsUTF32Node.class)
        @DenyReplace
        private static final class Uncached extends CompareIntsUTF32Node {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value) {
                return compare(arg0Value, arg1Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RegionEqualNode.class)
    static final class RegionEqualNodeGen extends RegionEqualNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RegionEqualsData regionEquals_cache;

        private RegionEqualNodeGen() {
        }

        @Override
        public boolean execute(AbstractTruffleString arg0Value, int arg1Value, AbstractTruffleString arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 regionEquals(AbstractTruffleString, int, AbstractTruffleString, int, int, Encoding, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, GetCodeRangeNode, GetCodeRangeNode, RegionEqualsNode) */) {
                RegionEqualsData s0_ = this.regionEquals_cache;
                if (s0_ != null) {
                    return RegionEqualNode.regionEquals(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.regionEqualsNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, AbstractTruffleString arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                RegionEqualsData s0_ = super.insert(new RegionEqualsData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodePointLengthANode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodePointLengthBNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.regionEqualsNode_ = s0_.insertAccessor((RegionEqualsNodeGen.create()));
                VarHandle.storeStoreFence();
                this.regionEquals_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 regionEquals(AbstractTruffleString, int, AbstractTruffleString, int, int, Encoding, ToIndexableNode, ToIndexableNode, GetCodePointLengthNode, GetCodePointLengthNode, GetCodeRangeNode, GetCodeRangeNode, RegionEqualsNode) */;
                lock.unlock();
                hasLock = false;
                return RegionEqualNode.regionEquals(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodePointLengthANode_, s0_.getCodePointLengthBNode_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_, s0_.regionEqualsNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static RegionEqualNode create() {
            return new RegionEqualNodeGen();
        }

        public static RegionEqualNode getUncached() {
            return RegionEqualNodeGen.UNCACHED;
        }

        @GeneratedBy(RegionEqualNode.class)
        private static final class RegionEqualsData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child GetCodePointLengthNode getCodePointLengthANode_;
            @Child GetCodePointLengthNode getCodePointLengthBNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;
            @Child RegionEqualsNode regionEqualsNode_;

            RegionEqualsData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(RegionEqualNode.class)
        @DenyReplace
        private static final class Uncached extends RegionEqualNode {

            @TruffleBoundary
            @Override
            public boolean execute(AbstractTruffleString arg0Value, int arg1Value, AbstractTruffleString arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
                return RegionEqualNode.regionEquals(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (GetCodePointLengthNode.getUncached()), (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (RegionEqualsNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RegionEqualByteIndexNode.class)
    static final class RegionEqualByteIndexNodeGen extends RegionEqualByteIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RegionEqualsData regionEquals_cache;

        private RegionEqualByteIndexNodeGen() {
        }

        @Override
        boolean execute(AbstractTruffleString arg0Value, int arg1Value, AbstractTruffleString arg2Value, int arg3Value, int arg4Value, byte[] arg5Value, Encoding arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 regionEquals(AbstractTruffleString, int, AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */) {
                RegionEqualsData s0_ = this.regionEquals_cache;
                if (s0_ != null) {
                    return regionEquals(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, AbstractTruffleString arg2Value, int arg3Value, int arg4Value, byte[] arg5Value, Encoding arg6Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                RegionEqualsData s0_ = super.insert(new RegionEqualsData());
                s0_.toIndexableNodeA_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.toIndexableNodeB_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodeRangeBNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                VarHandle.storeStoreFence();
                this.regionEquals_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 regionEquals(AbstractTruffleString, int, AbstractTruffleString, int, int, byte[], Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return regionEquals(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s0_.toIndexableNodeA_, s0_.toIndexableNodeB_, s0_.getCodeRangeANode_, s0_.getCodeRangeBNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static RegionEqualByteIndexNode create() {
            return new RegionEqualByteIndexNodeGen();
        }

        public static RegionEqualByteIndexNode getUncached() {
            return RegionEqualByteIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(RegionEqualByteIndexNode.class)
        private static final class RegionEqualsData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;

            RegionEqualsData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(RegionEqualByteIndexNode.class)
        @DenyReplace
        private static final class Uncached extends RegionEqualByteIndexNode {

            @TruffleBoundary
            @Override
            boolean execute(AbstractTruffleString arg0Value, int arg1Value, AbstractTruffleString arg2Value, int arg3Value, int arg4Value, byte[] arg5Value, Encoding arg6Value) {
                return regionEquals(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ConcatNode.class)
    static final class ConcatNodeGen extends ConcatNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private AEmptyMutableData aEmptyMutable_cache;
        @Child private BEmptyMutableData bEmptyMutable_cache;
        @Child private ConcatData concat_cache;

        private ConcatNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value, boolean arg3Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 aEmpty(AbstractTruffleString, TruffleString, Encoding, boolean) || aEmptyMutable(AbstractTruffleString, MutableTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) || bEmpty(TruffleString, AbstractTruffleString, Encoding, boolean) || bEmptyMutable(MutableTruffleString, AbstractTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) || doConcat(AbstractTruffleString, AbstractTruffleString, Encoding, boolean, GetCodeRangeNode, GetCodeRangeNode, StrideFromCodeRangeNode, ConcatEagerNode, AsTruffleStringNode, AsTruffleStringNode, BranchProfile, ConditionProfile) */) {
                if ((state_0 & 0b11) != 0 /* is-state_0 aEmpty(AbstractTruffleString, TruffleString, Encoding, boolean) || aEmptyMutable(AbstractTruffleString, MutableTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */) {
                    if ((state_0 & 0b1) != 0 /* is-state_0 aEmpty(AbstractTruffleString, TruffleString, Encoding, boolean) */ && arg1Value instanceof TruffleString) {
                        TruffleString arg1Value_ = (TruffleString) arg1Value;
                        if ((TStringGuards.isEmpty(arg0Value))) {
                            return ConcatNode.aEmpty(arg0Value, arg1Value_, arg2Value, arg3Value);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is-state_0 aEmptyMutable(AbstractTruffleString, MutableTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */ && arg1Value instanceof MutableTruffleString) {
                        MutableTruffleString arg1Value_ = (MutableTruffleString) arg1Value;
                        AEmptyMutableData s1_ = this.aEmptyMutable_cache;
                        if (s1_ != null) {
                            if ((TStringGuards.isEmpty(arg0Value))) {
                                return ConcatNode.aEmptyMutable(arg0Value, arg1Value_, arg2Value, arg3Value, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.fromBufferWithStringCompactionNode_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b11100) != 0 /* is-state_0 bEmpty(TruffleString, AbstractTruffleString, Encoding, boolean) || bEmptyMutable(MutableTruffleString, AbstractTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) || doConcat(AbstractTruffleString, AbstractTruffleString, Encoding, boolean, GetCodeRangeNode, GetCodeRangeNode, StrideFromCodeRangeNode, ConcatEagerNode, AsTruffleStringNode, AsTruffleStringNode, BranchProfile, ConditionProfile) */) {
                    if ((state_0 & 0b100) != 0 /* is-state_0 bEmpty(TruffleString, AbstractTruffleString, Encoding, boolean) */ && arg0Value instanceof TruffleString) {
                        TruffleString arg0Value_ = (TruffleString) arg0Value;
                        if ((TStringGuards.isEmpty(arg1Value))) {
                            return ConcatNode.bEmpty(arg0Value_, arg1Value, arg2Value, arg3Value);
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is-state_0 bEmptyMutable(MutableTruffleString, AbstractTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */ && arg0Value instanceof MutableTruffleString) {
                        MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                        BEmptyMutableData s3_ = this.bEmptyMutable_cache;
                        if (s3_ != null) {
                            if ((TStringGuards.isEmpty(arg1Value))) {
                                return ConcatNode.bEmptyMutable(arg0Value_, arg1Value, arg2Value, arg3Value, s3_.getCodePointLengthNode_, s3_.getCodeRangeNode_, s3_.fromBufferWithStringCompactionNode_);
                            }
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is-state_0 doConcat(AbstractTruffleString, AbstractTruffleString, Encoding, boolean, GetCodeRangeNode, GetCodeRangeNode, StrideFromCodeRangeNode, ConcatEagerNode, AsTruffleStringNode, AsTruffleStringNode, BranchProfile, ConditionProfile) */) {
                        ConcatData s4_ = this.concat_cache;
                        if (s4_ != null) {
                            if ((!(TStringGuards.isEmpty(arg0Value))) && (!(TStringGuards.isEmpty(arg1Value)))) {
                                return ConcatNode.doConcat(arg0Value, arg1Value, arg2Value, arg3Value, s4_.getCodeRangeANode_, s4_.getCodeRangeBNode_, s4_.getStrideNode_, s4_.concatEagerNode_, s4_.asTruffleStringANode_, s4_.asTruffleStringBNode_, s4_.outOfMemoryProfile_, s4_.lazyProfile_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value, boolean arg3Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((TStringGuards.isEmpty(arg0Value))) {
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 aEmpty(AbstractTruffleString, TruffleString, Encoding, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return ConcatNode.aEmpty(arg0Value, arg1Value_, arg2Value, arg3Value);
                    }
                }
                if (arg1Value instanceof MutableTruffleString) {
                    MutableTruffleString arg1Value_ = (MutableTruffleString) arg1Value;
                    if ((TStringGuards.isEmpty(arg0Value))) {
                        AEmptyMutableData s1_ = super.insert(new AEmptyMutableData());
                        s1_.getCodePointLengthNode_ = s1_.insertAccessor((GetCodePointLengthNodeGen.create()));
                        s1_.getCodeRangeNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                        s1_.fromBufferWithStringCompactionNode_ = s1_.insertAccessor((FromBufferWithStringCompactionKnownAttributesNodeGen.create()));
                        VarHandle.storeStoreFence();
                        this.aEmptyMutable_cache = s1_;
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 aEmptyMutable(AbstractTruffleString, MutableTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */;
                        lock.unlock();
                        hasLock = false;
                        return ConcatNode.aEmptyMutable(arg0Value, arg1Value_, arg2Value, arg3Value, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.fromBufferWithStringCompactionNode_);
                    }
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((TStringGuards.isEmpty(arg1Value))) {
                        this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 bEmpty(TruffleString, AbstractTruffleString, Encoding, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return ConcatNode.bEmpty(arg0Value_, arg1Value, arg2Value, arg3Value);
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((TStringGuards.isEmpty(arg1Value))) {
                        BEmptyMutableData s3_ = super.insert(new BEmptyMutableData());
                        s3_.getCodePointLengthNode_ = s3_.insertAccessor((GetCodePointLengthNodeGen.create()));
                        s3_.getCodeRangeNode_ = s3_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                        s3_.fromBufferWithStringCompactionNode_ = s3_.insertAccessor((FromBufferWithStringCompactionKnownAttributesNodeGen.create()));
                        VarHandle.storeStoreFence();
                        this.bEmptyMutable_cache = s3_;
                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 bEmptyMutable(MutableTruffleString, AbstractTruffleString, Encoding, boolean, GetCodePointLengthNode, GetCodeRangeNode, FromBufferWithStringCompactionKnownAttributesNode) */;
                        lock.unlock();
                        hasLock = false;
                        return ConcatNode.bEmptyMutable(arg0Value_, arg1Value, arg2Value, arg3Value, s3_.getCodePointLengthNode_, s3_.getCodeRangeNode_, s3_.fromBufferWithStringCompactionNode_);
                    }
                }
                if ((!(TStringGuards.isEmpty(arg0Value))) && (!(TStringGuards.isEmpty(arg1Value)))) {
                    ConcatData s4_ = super.insert(new ConcatData());
                    s4_.getCodeRangeANode_ = s4_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s4_.getCodeRangeBNode_ = s4_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s4_.getStrideNode_ = s4_.insertAccessor((StrideFromCodeRangeNodeGen.create()));
                    s4_.concatEagerNode_ = s4_.insertAccessor((ConcatEagerNodeGen.create()));
                    s4_.asTruffleStringANode_ = s4_.insertAccessor((AsTruffleStringNode.create()));
                    s4_.asTruffleStringBNode_ = s4_.insertAccessor((AsTruffleStringNode.create()));
                    s4_.outOfMemoryProfile_ = (BranchProfile.create());
                    s4_.lazyProfile_ = (ConditionProfile.create());
                    VarHandle.storeStoreFence();
                    this.concat_cache = s4_;
                    this.state_0_ = state_0 = state_0 | 0b10000 /* add-state_0 doConcat(AbstractTruffleString, AbstractTruffleString, Encoding, boolean, GetCodeRangeNode, GetCodeRangeNode, StrideFromCodeRangeNode, ConcatEagerNode, AsTruffleStringNode, AsTruffleStringNode, BranchProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return ConcatNode.doConcat(arg0Value, arg1Value, arg2Value, arg3Value, s4_.getCodeRangeANode_, s4_.getCodeRangeBNode_, s4_.getStrideNode_, s4_.concatEagerNode_, s4_.asTruffleStringANode_, s4_.asTruffleStringBNode_, s4_.outOfMemoryProfile_, s4_.lazyProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ConcatNode create() {
            return new ConcatNodeGen();
        }

        public static ConcatNode getUncached() {
            return ConcatNodeGen.UNCACHED;
        }

        @GeneratedBy(ConcatNode.class)
        private static final class AEmptyMutableData extends Node {

            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child FromBufferWithStringCompactionKnownAttributesNode fromBufferWithStringCompactionNode_;

            AEmptyMutableData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ConcatNode.class)
        private static final class BEmptyMutableData extends Node {

            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child FromBufferWithStringCompactionKnownAttributesNode fromBufferWithStringCompactionNode_;

            BEmptyMutableData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ConcatNode.class)
        private static final class ConcatData extends Node {

            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;
            @Child StrideFromCodeRangeNode getStrideNode_;
            @Child ConcatEagerNode concatEagerNode_;
            @Child AsTruffleStringNode asTruffleStringANode_;
            @Child AsTruffleStringNode asTruffleStringBNode_;
            @CompilationFinal BranchProfile outOfMemoryProfile_;
            @CompilationFinal ConditionProfile lazyProfile_;

            ConcatData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ConcatNode.class)
        @DenyReplace
        private static final class Uncached extends ConcatNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value, boolean arg3Value) {
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((TStringGuards.isEmpty(arg0Value))) {
                        return ConcatNode.aEmpty(arg0Value, arg1Value_, arg2Value, arg3Value);
                    }
                }
                if (arg1Value instanceof MutableTruffleString) {
                    MutableTruffleString arg1Value_ = (MutableTruffleString) arg1Value;
                    if ((TStringGuards.isEmpty(arg0Value))) {
                        return ConcatNode.aEmptyMutable(arg0Value, arg1Value_, arg2Value, arg3Value, (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (FromBufferWithStringCompactionKnownAttributesNode.getUncached()));
                    }
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((TStringGuards.isEmpty(arg1Value))) {
                        return ConcatNode.bEmpty(arg0Value_, arg1Value, arg2Value, arg3Value);
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((TStringGuards.isEmpty(arg1Value))) {
                        return ConcatNode.bEmptyMutable(arg0Value_, arg1Value, arg2Value, arg3Value, (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (FromBufferWithStringCompactionKnownAttributesNode.getUncached()));
                    }
                }
                if ((!(TStringGuards.isEmpty(arg0Value))) && (!(TStringGuards.isEmpty(arg1Value)))) {
                    return ConcatNode.doConcat(arg0Value, arg1Value, arg2Value, arg3Value, (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (StrideFromCodeRangeNodeGen.getUncached()), (ConcatEagerNodeGen.getUncached()), (AsTruffleStringNode.getUncached()), (AsTruffleStringNode.getUncached()), (BranchProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(RepeatNode.class)
    static final class RepeatNodeGen extends RepeatNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private RepeatData repeat_cache;

        private RepeatNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 repeat(AbstractTruffleString, int, Encoding, AsTruffleStringNode, ToIndexableNode, GetCodeRangeNode, GetCodePointLengthNode, CalcStringAttributesNode, ConditionProfile, BranchProfile) */) {
                RepeatData s0_ = this.repeat_cache;
                if (s0_ != null) {
                    return repeat(arg0Value, arg1Value, arg2Value, s0_.asTruffleStringNode_, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.getCodePointLengthNode_, s0_.calcStringAttributesNode_, s0_.brokenProfile_, s0_.outOfMemoryProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                RepeatData s0_ = super.insert(new RepeatData());
                s0_.asTruffleStringNode_ = s0_.insertAccessor((AsTruffleStringNode.create()));
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.calcStringAttributesNode_ = s0_.insertAccessor((CalcStringAttributesNodeGen.create()));
                s0_.brokenProfile_ = (ConditionProfile.create());
                s0_.outOfMemoryProfile_ = (BranchProfile.create());
                VarHandle.storeStoreFence();
                this.repeat_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 repeat(AbstractTruffleString, int, Encoding, AsTruffleStringNode, ToIndexableNode, GetCodeRangeNode, GetCodePointLengthNode, CalcStringAttributesNode, ConditionProfile, BranchProfile) */;
                lock.unlock();
                hasLock = false;
                return repeat(arg0Value, arg1Value, arg2Value, s0_.asTruffleStringNode_, s0_.toIndexableNode_, s0_.getCodeRangeNode_, s0_.getCodePointLengthNode_, s0_.calcStringAttributesNode_, s0_.brokenProfile_, s0_.outOfMemoryProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static RepeatNode create() {
            return new RepeatNodeGen();
        }

        public static RepeatNode getUncached() {
            return RepeatNodeGen.UNCACHED;
        }

        @GeneratedBy(RepeatNode.class)
        private static final class RepeatData extends Node {

            @Child AsTruffleStringNode asTruffleStringNode_;
            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child CalcStringAttributesNode calcStringAttributesNode_;
            @CompilationFinal ConditionProfile brokenProfile_;
            @CompilationFinal BranchProfile outOfMemoryProfile_;

            RepeatData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(RepeatNode.class)
        @DenyReplace
        private static final class Uncached extends RepeatNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, int arg1Value, Encoding arg2Value) {
                return repeat(arg0Value, arg1Value, arg2Value, (AsTruffleStringNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (GetCodePointLengthNode.getUncached()), (CalcStringAttributesNode.getUncached()), (ConditionProfile.getUncached()), (BranchProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.SubstringNode.class)
    static final class SubstringNodeGen extends com.oracle.truffle.api.strings.TruffleString.SubstringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private SubstringData substring_cache;

        private SubstringNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 substring(AbstractTruffleString, int, int, Encoding, boolean, ToIndexableNode, GetCodeRangeNode, GetCodePointLengthNode, CodePointIndexToRawNode, SubstringNode) */) {
                SubstringData s0_ = this.substring_cache;
                if (s0_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.SubstringNode.substring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodeRangeANode_, s0_.getCodePointLengthNode_, s0_.translateIndexNode_, s0_.substringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                SubstringData s0_ = super.insert(new SubstringData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.getCodeRangeANode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                s0_.getCodePointLengthNode_ = s0_.insertAccessor((GetCodePointLengthNodeGen.create()));
                s0_.translateIndexNode_ = s0_.insertAccessor((CodePointIndexToRawNodeGen.create()));
                s0_.substringNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.SubstringNodeGen.create()));
                VarHandle.storeStoreFence();
                this.substring_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 substring(AbstractTruffleString, int, int, Encoding, boolean, ToIndexableNode, GetCodeRangeNode, GetCodePointLengthNode, CodePointIndexToRawNode, SubstringNode) */;
                lock.unlock();
                hasLock = false;
                return com.oracle.truffle.api.strings.TruffleString.SubstringNode.substring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s0_.toIndexableNode_, s0_.getCodeRangeANode_, s0_.getCodePointLengthNode_, s0_.translateIndexNode_, s0_.substringNode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static com.oracle.truffle.api.strings.TruffleString.SubstringNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.SubstringNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.SubstringNode getUncached() {
            return SubstringNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.SubstringNode.class)
        private static final class SubstringData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child CodePointIndexToRawNode translateIndexNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.SubstringNode substringNode_;

            SubstringData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.SubstringNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.SubstringNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                return com.oracle.truffle.api.strings.TruffleString.SubstringNode.substring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (GetCodePointLengthNode.getUncached()), (CodePointIndexToRawNodeGen.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.SubstringNodeGen.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(SubstringByteIndexNode.class)
    static final class SubstringByteIndexNodeGen extends SubstringByteIndexNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private SubstringRawData substringRaw_cache;

        private SubstringByteIndexNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 substringEmpty(AbstractTruffleString, int, int, Encoding, boolean) || substringRaw(AbstractTruffleString, int, int, Encoding, boolean, ToIndexableNode, GetCodeRangeNode, SubstringNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 substringEmpty(AbstractTruffleString, int, int, Encoding, boolean) */) {
                    if ((SubstringByteIndexNode.isSame(arg2Value, 0))) {
                        return SubstringByteIndexNode.substringEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 substringRaw(AbstractTruffleString, int, int, Encoding, boolean, ToIndexableNode, GetCodeRangeNode, SubstringNode) */) {
                    SubstringRawData s1_ = this.substringRaw_cache;
                    if (s1_ != null) {
                        if ((arg2Value != 0)) {
                            return SubstringByteIndexNode.substringRaw(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.toIndexableNode_, s1_.getCodeRangeANode_, s1_.substringNode_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((SubstringByteIndexNode.isSame(arg2Value, 0))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 substringEmpty(AbstractTruffleString, int, int, Encoding, boolean) */;
                    lock.unlock();
                    hasLock = false;
                    return SubstringByteIndexNode.substringEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((arg2Value != 0)) {
                    SubstringRawData s1_ = super.insert(new SubstringRawData());
                    s1_.toIndexableNode_ = s1_.insertAccessor((ToIndexableNode.create()));
                    s1_.getCodeRangeANode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.substringNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.SubstringNodeGen.create()));
                    VarHandle.storeStoreFence();
                    this.substringRaw_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 substringRaw(AbstractTruffleString, int, int, Encoding, boolean, ToIndexableNode, GetCodeRangeNode, SubstringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return SubstringByteIndexNode.substringRaw(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.toIndexableNode_, s1_.getCodeRangeANode_, s1_.substringNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SubstringByteIndexNode create() {
            return new SubstringByteIndexNodeGen();
        }

        public static SubstringByteIndexNode getUncached() {
            return SubstringByteIndexNodeGen.UNCACHED;
        }

        @GeneratedBy(SubstringByteIndexNode.class)
        private static final class SubstringRawData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.SubstringNode substringNode_;

            SubstringRawData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(SubstringByteIndexNode.class)
        @DenyReplace
        private static final class Uncached extends SubstringByteIndexNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, int arg1Value, int arg2Value, Encoding arg3Value, boolean arg4Value) {
                if ((SubstringByteIndexNode.isSame(arg2Value, 0))) {
                    return SubstringByteIndexNode.substringEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
                }
                if ((arg2Value != 0)) {
                    return SubstringByteIndexNode.substringRaw(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.SubstringNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(EqualNode.class)
    static final class EqualNodeGen extends EqualNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CheckData check_cache;

        private EqualNodeGen() {
        }

        @Override
        public boolean execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 sameObject(AbstractTruffleString, AbstractTruffleString, Encoding) || check(AbstractTruffleString, AbstractTruffleString, Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode, ConditionProfile, BranchProfile, ConditionProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 sameObject(AbstractTruffleString, AbstractTruffleString, Encoding) */) {
                    if ((TStringGuards.identical(arg0Value, arg1Value))) {
                        return EqualNode.sameObject(arg0Value, arg1Value, arg2Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 check(AbstractTruffleString, AbstractTruffleString, Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode, ConditionProfile, BranchProfile, ConditionProfile) */) {
                    CheckData s1_ = this.check_cache;
                    if (s1_ != null) {
                        if ((!(TStringGuards.identical(arg0Value, arg1Value)))) {
                            return check(arg0Value, arg1Value, arg2Value, s1_.toIndexableNodeA_, s1_.toIndexableNodeB_, s1_.getCodeRangeANode_, s1_.getCodeRangeBNode_, s1_.lengthAndCodeRangeCheckProfile_, s1_.compareHashProfile_, s1_.checkFirstByteProfile_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private boolean executeAndSpecialize(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((TStringGuards.identical(arg0Value, arg1Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 sameObject(AbstractTruffleString, AbstractTruffleString, Encoding) */;
                    lock.unlock();
                    hasLock = false;
                    return EqualNode.sameObject(arg0Value, arg1Value, arg2Value);
                }
                if ((!(TStringGuards.identical(arg0Value, arg1Value)))) {
                    CheckData s1_ = super.insert(new CheckData());
                    s1_.toIndexableNodeA_ = s1_.insertAccessor((ToIndexableNode.create()));
                    s1_.toIndexableNodeB_ = s1_.insertAccessor((ToIndexableNode.create()));
                    s1_.getCodeRangeANode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.getCodeRangeBNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.lengthAndCodeRangeCheckProfile_ = (ConditionProfile.create());
                    s1_.compareHashProfile_ = (BranchProfile.create());
                    s1_.checkFirstByteProfile_ = (ConditionProfile.create());
                    VarHandle.storeStoreFence();
                    this.check_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 check(AbstractTruffleString, AbstractTruffleString, Encoding, ToIndexableNode, ToIndexableNode, GetCodeRangeNode, GetCodeRangeNode, ConditionProfile, BranchProfile, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return check(arg0Value, arg1Value, arg2Value, s1_.toIndexableNodeA_, s1_.toIndexableNodeB_, s1_.getCodeRangeANode_, s1_.getCodeRangeBNode_, s1_.lengthAndCodeRangeCheckProfile_, s1_.compareHashProfile_, s1_.checkFirstByteProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static EqualNode create() {
            return new EqualNodeGen();
        }

        public static EqualNode getUncached() {
            return EqualNodeGen.UNCACHED;
        }

        @GeneratedBy(EqualNode.class)
        private static final class CheckData extends Node {

            @Child ToIndexableNode toIndexableNodeA_;
            @Child ToIndexableNode toIndexableNodeB_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeBNode_;
            @CompilationFinal ConditionProfile lengthAndCodeRangeCheckProfile_;
            @CompilationFinal BranchProfile compareHashProfile_;
            @CompilationFinal ConditionProfile checkFirstByteProfile_;

            CheckData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(EqualNode.class)
        @DenyReplace
        private static final class Uncached extends EqualNode {

            @TruffleBoundary
            @Override
            public boolean execute(AbstractTruffleString arg0Value, AbstractTruffleString arg1Value, Encoding arg2Value) {
                if ((TStringGuards.identical(arg0Value, arg1Value))) {
                    return EqualNode.sameObject(arg0Value, arg1Value, arg2Value);
                }
                if ((!(TStringGuards.identical(arg0Value, arg1Value)))) {
                    return check(arg0Value, arg1Value, arg2Value, (ToIndexableNode.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (ConditionProfile.getUncached()), (BranchProfile.getUncached()), (ConditionProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseIntNode.class)
    static final class ParseIntNodeGen extends com.oracle.truffle.api.strings.TruffleString.ParseIntNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @CompilationFinal private BranchProfile lazyLong_errorProfile_;
        @Child private ParseData parse_cache;

        private ParseIntNodeGen() {
        }

        @Override
        public int execute(AbstractTruffleString arg0Value, int arg1Value) throws NumberFormatException {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doLazyLong(AbstractTruffleString, int, BranchProfile) || doParse(AbstractTruffleString, int, ToIndexableNode, GetCodeRangeNode, ParseIntNode, IntValueProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doLazyLong(AbstractTruffleString, int, BranchProfile) */) {
                    if ((arg0Value.isLazyLong()) && (arg1Value == 10)) {
                        return com.oracle.truffle.api.strings.TruffleString.ParseIntNode.doLazyLong(arg0Value, arg1Value, this.lazyLong_errorProfile_);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doParse(AbstractTruffleString, int, ToIndexableNode, GetCodeRangeNode, ParseIntNode, IntValueProfile) */) {
                    ParseData s1_ = this.parse_cache;
                    if (s1_ != null) {
                        if ((!(arg0Value.isLazyLong()) || arg1Value != 10)) {
                            return com.oracle.truffle.api.strings.TruffleString.ParseIntNode.doParse(arg0Value, arg1Value, s1_.toIndexableNode_, s1_.getCodeRangeANode_, s1_.parseIntNode_, s1_.radixProfile_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private int executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value) throws NumberFormatException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((arg0Value.isLazyLong()) && (arg1Value == 10)) {
                    this.lazyLong_errorProfile_ = (BranchProfile.create());
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doLazyLong(AbstractTruffleString, int, BranchProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ParseIntNode.doLazyLong(arg0Value, arg1Value, this.lazyLong_errorProfile_);
                }
                if ((!(arg0Value.isLazyLong()) || arg1Value != 10)) {
                    ParseData s1_ = super.insert(new ParseData());
                    s1_.toIndexableNode_ = s1_.insertAccessor((ToIndexableNode.create()));
                    s1_.getCodeRangeANode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.parseIntNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.ParseIntNodeGen.create()));
                    s1_.radixProfile_ = (IntValueProfile.createIdentityProfile());
                    VarHandle.storeStoreFence();
                    this.parse_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doParse(AbstractTruffleString, int, ToIndexableNode, GetCodeRangeNode, ParseIntNode, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ParseIntNode.doParse(arg0Value, arg1Value, s1_.toIndexableNode_, s1_.getCodeRangeANode_, s1_.parseIntNode_, s1_.radixProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static com.oracle.truffle.api.strings.TruffleString.ParseIntNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.ParseIntNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.ParseIntNode getUncached() {
            return ParseIntNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseIntNode.class)
        private static final class ParseData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.ParseIntNode parseIntNode_;
            @CompilationFinal IntValueProfile radixProfile_;

            ParseData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseIntNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.ParseIntNode {

            @TruffleBoundary
            @Override
            public int execute(AbstractTruffleString arg0Value, int arg1Value) throws NumberFormatException {
                if ((arg0Value.isLazyLong()) && (arg1Value == 10)) {
                    return com.oracle.truffle.api.strings.TruffleString.ParseIntNode.doLazyLong(arg0Value, arg1Value, (BranchProfile.getUncached()));
                }
                if ((!(arg0Value.isLazyLong()) || arg1Value != 10)) {
                    return com.oracle.truffle.api.strings.TruffleString.ParseIntNode.doParse(arg0Value, arg1Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.ParseIntNodeGen.getUncached()), (IntValueProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseLongNode.class)
    static final class ParseLongNodeGen extends com.oracle.truffle.api.strings.TruffleString.ParseLongNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ParseData parse_cache;

        private ParseLongNodeGen() {
        }

        @Override
        public long execute(AbstractTruffleString arg0Value, int arg1Value) throws NumberFormatException {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doLazyLong(AbstractTruffleString, int) || doParse(AbstractTruffleString, int, ToIndexableNode, GetCodeRangeNode, ParseLongNode, IntValueProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doLazyLong(AbstractTruffleString, int) */) {
                    if ((arg0Value.isLazyLong()) && (arg1Value == 10)) {
                        return com.oracle.truffle.api.strings.TruffleString.ParseLongNode.doLazyLong(arg0Value, arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 doParse(AbstractTruffleString, int, ToIndexableNode, GetCodeRangeNode, ParseLongNode, IntValueProfile) */) {
                    ParseData s1_ = this.parse_cache;
                    if (s1_ != null) {
                        if ((!(arg0Value.isLazyLong()) || arg1Value != 10)) {
                            return com.oracle.truffle.api.strings.TruffleString.ParseLongNode.doParse(arg0Value, arg1Value, s1_.toIndexableNode_, s1_.getCodeRangeANode_, s1_.parseLongNode_, s1_.radixProfile_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private long executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value) throws NumberFormatException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((arg0Value.isLazyLong()) && (arg1Value == 10)) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doLazyLong(AbstractTruffleString, int) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ParseLongNode.doLazyLong(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isLazyLong()) || arg1Value != 10)) {
                    ParseData s1_ = super.insert(new ParseData());
                    s1_.toIndexableNode_ = s1_.insertAccessor((ToIndexableNode.create()));
                    s1_.getCodeRangeANode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.parseLongNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.ParseLongNodeGen.create()));
                    s1_.radixProfile_ = (IntValueProfile.createIdentityProfile());
                    VarHandle.storeStoreFence();
                    this.parse_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doParse(AbstractTruffleString, int, ToIndexableNode, GetCodeRangeNode, ParseLongNode, IntValueProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ParseLongNode.doParse(arg0Value, arg1Value, s1_.toIndexableNode_, s1_.getCodeRangeANode_, s1_.parseLongNode_, s1_.radixProfile_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static com.oracle.truffle.api.strings.TruffleString.ParseLongNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.ParseLongNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.ParseLongNode getUncached() {
            return ParseLongNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseLongNode.class)
        private static final class ParseData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.ParseLongNode parseLongNode_;
            @CompilationFinal IntValueProfile radixProfile_;

            ParseData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseLongNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.ParseLongNode {

            @TruffleBoundary
            @Override
            public long execute(AbstractTruffleString arg0Value, int arg1Value) throws NumberFormatException {
                if ((arg0Value.isLazyLong()) && (arg1Value == 10)) {
                    return com.oracle.truffle.api.strings.TruffleString.ParseLongNode.doLazyLong(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isLazyLong()) || arg1Value != 10)) {
                    return com.oracle.truffle.api.strings.TruffleString.ParseLongNode.doParse(arg0Value, arg1Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.ParseLongNodeGen.getUncached()), (IntValueProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.class)
    static final class ParseDoubleNodeGen extends com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ToIndexableNode parseDouble_toIndexableNode_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.ParseDoubleNode parseDouble_parseDoubleNode_;

        private ParseDoubleNodeGen() {
        }

        @Override
        public double execute(AbstractTruffleString arg0Value) throws NumberFormatException {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doLazyLong(AbstractTruffleString) || parseDouble(AbstractTruffleString, ToIndexableNode, ParseDoubleNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 doLazyLong(AbstractTruffleString) */) {
                    if ((com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.isLazyLongSafeInteger(arg0Value))) {
                        return com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.doLazyLong(arg0Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 parseDouble(AbstractTruffleString, ToIndexableNode, ParseDoubleNode) */) {
                    if ((!(com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.isLazyLongSafeInteger(arg0Value)))) {
                        return com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.parseDouble(arg0Value, this.parseDouble_toIndexableNode_, this.parseDouble_parseDoubleNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private double executeAndSpecialize(AbstractTruffleString arg0Value) throws NumberFormatException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if ((com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.isLazyLongSafeInteger(arg0Value))) {
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doLazyLong(AbstractTruffleString) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.doLazyLong(arg0Value);
                }
                if ((!(com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.isLazyLongSafeInteger(arg0Value)))) {
                    this.parseDouble_toIndexableNode_ = super.insert((ToIndexableNode.create()));
                    this.parseDouble_parseDoubleNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.ParseDoubleNodeGen.create()));
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 parseDouble(AbstractTruffleString, ToIndexableNode, ParseDoubleNode) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.parseDouble(arg0Value, this.parseDouble_toIndexableNode_, this.parseDouble_parseDoubleNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.ParseDoubleNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode getUncached() {
            return ParseDoubleNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode {

            @TruffleBoundary
            @Override
            public double execute(AbstractTruffleString arg0Value) throws NumberFormatException {
                if ((com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.isLazyLongSafeInteger(arg0Value))) {
                    return com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.doLazyLong(arg0Value);
                }
                if ((!(com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.isLazyLongSafeInteger(arg0Value)))) {
                    return com.oracle.truffle.api.strings.TruffleString.ParseDoubleNode.parseDouble(arg0Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.ParseDoubleNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(GetInternalByteArrayNode.class)
    static final class GetInternalByteArrayNodeGen extends GetInternalByteArrayNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private GetInternalByteArrayData getInternalByteArray_cache;

        private GetInternalByteArrayNodeGen() {
        }

        @Override
        public InternalByteArray execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 getInternalByteArray(AbstractTruffleString, Encoding, ToIndexableNode, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                GetInternalByteArrayData s0_ = this.getInternalByteArray_cache;
                if (s0_ != null) {
                    return getInternalByteArray(arg0Value, arg1Value, s0_.toIndexableNode_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_, s0_.isByteArrayProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private InternalByteArray executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                GetInternalByteArrayData s0_ = super.insert(new GetInternalByteArrayData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf16S0Profile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.utf32S0Profile_ = (ConditionProfile.create());
                s0_.utf32S1Profile_ = (ConditionProfile.create());
                s0_.isByteArrayProfile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.getInternalByteArray_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 getInternalByteArray(AbstractTruffleString, Encoding, ToIndexableNode, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                return getInternalByteArray(arg0Value, arg1Value, s0_.toIndexableNode_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_, s0_.isByteArrayProfile_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static GetInternalByteArrayNode create() {
            return new GetInternalByteArrayNodeGen();
        }

        public static GetInternalByteArrayNode getUncached() {
            return GetInternalByteArrayNodeGen.UNCACHED;
        }

        @GeneratedBy(GetInternalByteArrayNode.class)
        private static final class GetInternalByteArrayData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf16S0Profile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile utf32S0Profile_;
            @CompilationFinal ConditionProfile utf32S1Profile_;
            @CompilationFinal ConditionProfile isByteArrayProfile_;

            GetInternalByteArrayData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(GetInternalByteArrayNode.class)
        @DenyReplace
        private static final class Uncached extends GetInternalByteArrayNode {

            @TruffleBoundary
            @Override
            public InternalByteArray execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                return getInternalByteArray(arg0Value, arg1Value, (ToIndexableNode.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(GetInternalNativePointerNode.class)
    static final class GetInternalNativePointerNodeGen extends GetInternalNativePointerNode {

        private static final Uncached UNCACHED = new Uncached();

        private GetInternalNativePointerNodeGen() {
        }

        @Override
        public Object execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            return GetInternalNativePointerNode.getNativePointer(arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public static GetInternalNativePointerNode create() {
            return new GetInternalNativePointerNodeGen();
        }

        public static GetInternalNativePointerNode getUncached() {
            return GetInternalNativePointerNodeGen.UNCACHED;
        }

        @GeneratedBy(GetInternalNativePointerNode.class)
        @DenyReplace
        private static final class Uncached extends GetInternalNativePointerNode {

            @TruffleBoundary
            @Override
            public Object execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                return GetInternalNativePointerNode.getNativePointer(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CopyToByteArrayNode.class)
    static final class CopyToByteArrayNodeGen extends CopyToByteArrayNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CopyData copy_cache;

        private CopyToByteArrayNodeGen() {
        }

        @Override
        public void execute(AbstractTruffleString arg0Value, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doCopy(AbstractTruffleString, int, byte[], int, int, Encoding, ToIndexableNode, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                CopyData s0_ = this.copy_cache;
                if (s0_ != null) {
                    doCopy(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNode_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            return;
        }

        private void executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                CopyData s0_ = super.insert(new CopyData());
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf16S0Profile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.utf32S0Profile_ = (ConditionProfile.create());
                s0_.utf32S1Profile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.copy_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCopy(AbstractTruffleString, int, byte[], int, int, Encoding, ToIndexableNode, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                doCopy(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.toIndexableNode_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CopyToByteArrayNode create() {
            return new CopyToByteArrayNodeGen();
        }

        public static CopyToByteArrayNode getUncached() {
            return CopyToByteArrayNodeGen.UNCACHED;
        }

        @GeneratedBy(CopyToByteArrayNode.class)
        private static final class CopyData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf16S0Profile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile utf32S0Profile_;
            @CompilationFinal ConditionProfile utf32S1Profile_;

            CopyData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CopyToByteArrayNode.class)
        @DenyReplace
        private static final class Uncached extends CopyToByteArrayNode {

            @TruffleBoundary
            @Override
            public void execute(AbstractTruffleString arg0Value, int arg1Value, byte[] arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
                doCopy(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (ToIndexableNode.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CopyToNativeMemoryNode.class)
    static final class CopyToNativeMemoryNodeGen extends CopyToNativeMemoryNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private CopyData copy_cache;

        private CopyToNativeMemoryNodeGen() {
        }

        @Override
        public void execute(AbstractTruffleString arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 doCopy(AbstractTruffleString, int, Object, int, int, Encoding, Node, ToIndexableNode, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */) {
                CopyData s0_ = this.copy_cache;
                if (s0_ != null) {
                    doCopy(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.interopLibrary_, s0_.toIndexableNode_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            return;
        }

        private void executeAndSpecialize(AbstractTruffleString arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                CopyData s0_ = super.insert(new CopyData());
                s0_.interopLibrary_ = s0_.insertAccessor((TStringAccessor.createInteropLibrary()));
                s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                s0_.utf16Profile_ = (ConditionProfile.create());
                s0_.utf16S0Profile_ = (ConditionProfile.create());
                s0_.utf32Profile_ = (ConditionProfile.create());
                s0_.utf32S0Profile_ = (ConditionProfile.create());
                s0_.utf32S1Profile_ = (ConditionProfile.create());
                VarHandle.storeStoreFence();
                this.copy_cache = s0_;
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doCopy(AbstractTruffleString, int, Object, int, int, Encoding, Node, ToIndexableNode, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile, ConditionProfile) */;
                lock.unlock();
                hasLock = false;
                doCopy(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, s0_.interopLibrary_, s0_.toIndexableNode_, s0_.utf16Profile_, s0_.utf16S0Profile_, s0_.utf32Profile_, s0_.utf32S0Profile_, s0_.utf32S1Profile_);
                return;
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CopyToNativeMemoryNode create() {
            return new CopyToNativeMemoryNodeGen();
        }

        public static CopyToNativeMemoryNode getUncached() {
            return CopyToNativeMemoryNodeGen.UNCACHED;
        }

        @GeneratedBy(CopyToNativeMemoryNode.class)
        private static final class CopyData extends Node {

            @Child Node interopLibrary_;
            @Child ToIndexableNode toIndexableNode_;
            @CompilationFinal ConditionProfile utf16Profile_;
            @CompilationFinal ConditionProfile utf16S0Profile_;
            @CompilationFinal ConditionProfile utf32Profile_;
            @CompilationFinal ConditionProfile utf32S0Profile_;
            @CompilationFinal ConditionProfile utf32S1Profile_;

            CopyData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(CopyToNativeMemoryNode.class)
        @DenyReplace
        private static final class Uncached extends CopyToNativeMemoryNode {

            @TruffleBoundary
            @Override
            public void execute(AbstractTruffleString arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value, Encoding arg5Value) {
                doCopy(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (TStringAccessor.getUncachedInteropLibrary()), (ToIndexableNode.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()));
                return;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.class)
    static final class ToJavaStringNodeGen extends com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private UTF16Data uTF16_cache;
        @Child private MutableData mutable_cache;

        private ToJavaStringNodeGen() {
        }

        @Override
        public String execute(AbstractTruffleString arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is-state_0 doUTF16(TruffleString, ConditionProfile, ToIndexableNode, ToJavaStringNode) */ && arg0Value instanceof TruffleString) {
                TruffleString arg0Value_ = (TruffleString) arg0Value;
                UTF16Data s0_ = this.uTF16_cache;
                if (s0_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.doUTF16(arg0Value_, s0_.cacheHit_, s0_.toIndexableNode_, s0_.toJavaStringNode_);
                }
            }
            if ((state_0 & 0b10) != 0 /* is-state_0 doMutable(MutableTruffleString, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, CreateJavaStringNode) */ && arg0Value instanceof MutableTruffleString) {
                MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                MutableData s1_ = this.mutable_cache;
                if (s1_ != null) {
                    return com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.doMutable(arg0Value_, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.transCodeNode_, s1_.createJavaStringNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private String executeAndSpecialize(AbstractTruffleString arg0Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    UTF16Data s0_ = super.insert(new UTF16Data());
                    s0_.cacheHit_ = (ConditionProfile.create());
                    s0_.toIndexableNode_ = s0_.insertAccessor((ToIndexableNode.create()));
                    s0_.toJavaStringNode_ = s0_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.ToJavaStringNodeGen.create()));
                    VarHandle.storeStoreFence();
                    this.uTF16_cache = s0_;
                    this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 doUTF16(TruffleString, ConditionProfile, ToIndexableNode, ToJavaStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.doUTF16(arg0Value_, s0_.cacheHit_, s0_.toIndexableNode_, s0_.toJavaStringNode_);
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    MutableData s1_ = super.insert(new MutableData());
                    s1_.getCodePointLengthNode_ = s1_.insertAccessor((GetCodePointLengthNodeGen.create()));
                    s1_.getCodeRangeNode_ = s1_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                    s1_.transCodeNode_ = s1_.insertAccessor((TransCodeNodeGen.create()));
                    s1_.createJavaStringNode_ = s1_.insertAccessor((CreateJavaStringNodeGen.create()));
                    VarHandle.storeStoreFence();
                    this.mutable_cache = s1_;
                    this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 doMutable(MutableTruffleString, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, CreateJavaStringNode) */;
                    lock.unlock();
                    hasLock = false;
                    return com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.doMutable(arg0Value_, s1_.getCodePointLengthNode_, s1_.getCodeRangeNode_, s1_.transCodeNode_, s1_.createJavaStringNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode create() {
            return new com.oracle.truffle.api.strings.TruffleStringFactory.ToJavaStringNodeGen();
        }

        public static com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode getUncached() {
            return ToJavaStringNodeGen.UNCACHED;
        }

        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.class)
        private static final class UTF16Data extends Node {

            @CompilationFinal ConditionProfile cacheHit_;
            @Child ToIndexableNode toIndexableNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.ToJavaStringNode toJavaStringNode_;

            UTF16Data() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.class)
        private static final class MutableData extends Node {

            @Child GetCodePointLengthNode getCodePointLengthNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeNode_;
            @Child TransCodeNode transCodeNode_;
            @Child CreateJavaStringNode createJavaStringNode_;

            MutableData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.class)
        @DenyReplace
        private static final class Uncached extends com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode {

            @TruffleBoundary
            @Override
            public String execute(AbstractTruffleString arg0Value) {
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    return com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.doUTF16(arg0Value_, (ConditionProfile.getUncached()), (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.ToJavaStringNodeGen.getUncached()));
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    return com.oracle.truffle.api.strings.TruffleString.ToJavaStringNode.doMutable(arg0Value_, (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (TransCodeNodeGen.getUncached()), (CreateJavaStringNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(SwitchEncodingNode.class)
    static final class SwitchEncodingNodeGen extends SwitchEncodingNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private TransCodeNode transCodeNode;
        @Child private AsTruffleStringNode compatibleMutable_asTruffleStringNode_;
        @CompilationFinal private ConditionProfile transCode_cacheHit_;
        @Child private ToIndexableNode transCode_toIndexableNode_;
        @Child private GetCodePointLengthNode transCodeMutable_getCodePointLengthNode_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode transCodeMutable_getCodeRangeNode_;
        @CompilationFinal private ConditionProfile transCodeMutable_isCompatibleProfile_;

        private SwitchEncodingNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 compatibleImmutable(TruffleString, Encoding) || compatibleMutable(MutableTruffleString, Encoding, AsTruffleStringNode) || transCode(TruffleString, Encoding, ConditionProfile, ToIndexableNode, TransCodeNode) || transCodeMutable(MutableTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, ConditionProfile) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 compatibleImmutable(TruffleString, Encoding) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        return SwitchEncodingNode.compatibleImmutable(arg0Value_, arg1Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 compatibleMutable(MutableTruffleString, Encoding, AsTruffleStringNode) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        return SwitchEncodingNode.compatibleMutable(arg0Value_, arg1Value, this.compatibleMutable_asTruffleStringNode_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 transCode(TruffleString, Encoding, ConditionProfile, ToIndexableNode, TransCodeNode) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((!(arg0Value_.isCompatibleTo(arg1Value)))) {
                        return SwitchEncodingNode.transCode(arg0Value_, arg1Value, this.transCode_cacheHit_, this.transCode_toIndexableNode_, this.transCodeNode);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is-state_0 transCodeMutable(MutableTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, ConditionProfile) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(arg0Value_.isCompatibleTo(arg1Value)))) {
                        return transCodeMutable(arg0Value_, arg1Value, this.transCodeMutable_getCodePointLengthNode_, this.transCodeMutable_getCodeRangeNode_, this.transCodeNode, this.transCodeMutable_isCompatibleProfile_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 compatibleImmutable(TruffleString, Encoding) */;
                        lock.unlock();
                        hasLock = false;
                        return SwitchEncodingNode.compatibleImmutable(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        this.compatibleMutable_asTruffleStringNode_ = super.insert((AsTruffleStringNode.create()));
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 compatibleMutable(MutableTruffleString, Encoding, AsTruffleStringNode) */;
                        lock.unlock();
                        hasLock = false;
                        return SwitchEncodingNode.compatibleMutable(arg0Value_, arg1Value, this.compatibleMutable_asTruffleStringNode_);
                    }
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((!(arg0Value_.isCompatibleTo(arg1Value)))) {
                        this.transCode_cacheHit_ = (ConditionProfile.create());
                        this.transCode_toIndexableNode_ = super.insert((ToIndexableNode.create()));
                        this.transCodeNode = super.insert(this.transCodeNode == null ? ((TransCodeNodeGen.create())) : this.transCodeNode);
                        this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 transCode(TruffleString, Encoding, ConditionProfile, ToIndexableNode, TransCodeNode) */;
                        lock.unlock();
                        hasLock = false;
                        return SwitchEncodingNode.transCode(arg0Value_, arg1Value, this.transCode_cacheHit_, this.transCode_toIndexableNode_, this.transCodeNode);
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(arg0Value_.isCompatibleTo(arg1Value)))) {
                        this.transCodeMutable_getCodePointLengthNode_ = super.insert((GetCodePointLengthNodeGen.create()));
                        this.transCodeMutable_getCodeRangeNode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                        this.transCodeNode = super.insert(this.transCodeNode == null ? ((TransCodeNodeGen.create())) : this.transCodeNode);
                        this.transCodeMutable_isCompatibleProfile_ = (ConditionProfile.create());
                        this.state_0_ = state_0 = state_0 | 0b1000 /* add-state_0 transCodeMutable(MutableTruffleString, Encoding, GetCodePointLengthNode, GetCodeRangeNode, TransCodeNode, ConditionProfile) */;
                        lock.unlock();
                        hasLock = false;
                        return transCodeMutable(arg0Value_, arg1Value, this.transCodeMutable_getCodePointLengthNode_, this.transCodeMutable_getCodeRangeNode_, this.transCodeNode, this.transCodeMutable_isCompatibleProfile_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static SwitchEncodingNode create() {
            return new SwitchEncodingNodeGen();
        }

        public static SwitchEncodingNode getUncached() {
            return SwitchEncodingNodeGen.UNCACHED;
        }

        @GeneratedBy(SwitchEncodingNode.class)
        @DenyReplace
        private static final class Uncached extends SwitchEncodingNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value) {
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        return SwitchEncodingNode.compatibleImmutable(arg0Value_, arg1Value);
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((arg0Value_.isCompatibleTo(arg1Value))) {
                        return SwitchEncodingNode.compatibleMutable(arg0Value_, arg1Value, (AsTruffleStringNode.getUncached()));
                    }
                }
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((!(arg0Value_.isCompatibleTo(arg1Value)))) {
                        return SwitchEncodingNode.transCode(arg0Value_, arg1Value, (ConditionProfile.getUncached()), (ToIndexableNode.getUncached()), (TransCodeNodeGen.getUncached()));
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((!(arg0Value_.isCompatibleTo(arg1Value)))) {
                        return transCodeMutable(arg0Value_, arg1Value, (GetCodePointLengthNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()), (TransCodeNodeGen.getUncached()), (ConditionProfile.getUncached()));
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ForceEncodingNode.class)
    static final class ForceEncodingNodeGen extends ForceEncodingNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private AsTruffleStringNode compatibleMutable_asTruffleStringNode_;
        @Child private ReinterpretData reinterpret_cache;

        private ForceEncodingNodeGen() {
        }

        @Override
        public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value, Encoding arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 compatibleImmutable(TruffleString, Encoding, Encoding) || compatibleMutable(MutableTruffleString, Encoding, Encoding, AsTruffleStringNode) || reinterpret(AbstractTruffleString, Encoding, Encoding, ToIndexableNode, ConditionProfile, ConditionProfile, CopyToByteArrayNode, FromBufferWithStringCompactionNode, FromNativePointerNode) */) {
                if ((state_0 & 0b1) != 0 /* is-state_0 compatibleImmutable(TruffleString, Encoding, Encoding) */ && arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value_, arg1Value, arg2Value))) {
                        return ForceEncodingNode.compatibleImmutable(arg0Value_, arg1Value, arg2Value);
                    }
                }
                if ((state_0 & 0b10) != 0 /* is-state_0 compatibleMutable(MutableTruffleString, Encoding, Encoding, AsTruffleStringNode) */ && arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value_, arg1Value, arg2Value))) {
                        return ForceEncodingNode.compatibleMutable(arg0Value_, arg1Value, arg2Value, this.compatibleMutable_asTruffleStringNode_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is-state_0 reinterpret(AbstractTruffleString, Encoding, Encoding, ToIndexableNode, ConditionProfile, ConditionProfile, CopyToByteArrayNode, FromBufferWithStringCompactionNode, FromNativePointerNode) */) {
                    ReinterpretData s2_ = this.reinterpret_cache;
                    if (s2_ != null) {
                        if ((!(ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value, arg1Value, arg2Value)))) {
                            return ForceEncodingNode.reinterpret(arg0Value, arg1Value, arg2Value, s2_.toIndexableNode_, s2_.managedProfile_, s2_.inflateProfile_, s2_.copyToByteArrayNode_, s2_.fromBufferWithStringCompactionNode_, s2_.fromNativePointerNode_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleString executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value, Encoding arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value_, arg1Value, arg2Value))) {
                        this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 compatibleImmutable(TruffleString, Encoding, Encoding) */;
                        lock.unlock();
                        hasLock = false;
                        return ForceEncodingNode.compatibleImmutable(arg0Value_, arg1Value, arg2Value);
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value_, arg1Value, arg2Value))) {
                        this.compatibleMutable_asTruffleStringNode_ = super.insert((AsTruffleStringNode.create()));
                        this.state_0_ = state_0 = state_0 | 0b10 /* add-state_0 compatibleMutable(MutableTruffleString, Encoding, Encoding, AsTruffleStringNode) */;
                        lock.unlock();
                        hasLock = false;
                        return ForceEncodingNode.compatibleMutable(arg0Value_, arg1Value, arg2Value, this.compatibleMutable_asTruffleStringNode_);
                    }
                }
                if ((!(ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value, arg1Value, arg2Value)))) {
                    ReinterpretData s2_ = super.insert(new ReinterpretData());
                    s2_.toIndexableNode_ = s2_.insertAccessor((ToIndexableNode.create()));
                    s2_.managedProfile_ = (ConditionProfile.create());
                    s2_.inflateProfile_ = (ConditionProfile.create());
                    s2_.copyToByteArrayNode_ = s2_.insertAccessor((CopyToByteArrayNode.create()));
                    s2_.fromBufferWithStringCompactionNode_ = s2_.insertAccessor((FromBufferWithStringCompactionNodeGen.create()));
                    s2_.fromNativePointerNode_ = s2_.insertAccessor((com.oracle.truffle.api.strings.TStringInternalNodesFactory.FromNativePointerNodeGen.create()));
                    VarHandle.storeStoreFence();
                    this.reinterpret_cache = s2_;
                    this.state_0_ = state_0 = state_0 | 0b100 /* add-state_0 reinterpret(AbstractTruffleString, Encoding, Encoding, ToIndexableNode, ConditionProfile, ConditionProfile, CopyToByteArrayNode, FromBufferWithStringCompactionNode, FromNativePointerNode) */;
                    lock.unlock();
                    hasLock = false;
                    return ForceEncodingNode.reinterpret(arg0Value, arg1Value, arg2Value, s2_.toIndexableNode_, s2_.managedProfile_, s2_.inflateProfile_, s2_.copyToByteArrayNode_, s2_.fromBufferWithStringCompactionNode_, s2_.fromNativePointerNode_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                if ((state_0 & (state_0 - 1)) == 0 /* is-single-state_0  */) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ForceEncodingNode create() {
            return new ForceEncodingNodeGen();
        }

        public static ForceEncodingNode getUncached() {
            return ForceEncodingNodeGen.UNCACHED;
        }

        @GeneratedBy(ForceEncodingNode.class)
        private static final class ReinterpretData extends Node {

            @Child ToIndexableNode toIndexableNode_;
            @CompilationFinal ConditionProfile managedProfile_;
            @CompilationFinal ConditionProfile inflateProfile_;
            @Child CopyToByteArrayNode copyToByteArrayNode_;
            @Child FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode_;
            @Child com.oracle.truffle.api.strings.TStringInternalNodes.FromNativePointerNode fromNativePointerNode_;

            ReinterpretData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }

        }
        @GeneratedBy(ForceEncodingNode.class)
        @DenyReplace
        private static final class Uncached extends ForceEncodingNode {

            @TruffleBoundary
            @Override
            public TruffleString execute(AbstractTruffleString arg0Value, Encoding arg1Value, Encoding arg2Value) {
                if (arg0Value instanceof TruffleString) {
                    TruffleString arg0Value_ = (TruffleString) arg0Value;
                    if ((ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value_, arg1Value, arg2Value))) {
                        return ForceEncodingNode.compatibleImmutable(arg0Value_, arg1Value, arg2Value);
                    }
                }
                if (arg0Value instanceof MutableTruffleString) {
                    MutableTruffleString arg0Value_ = (MutableTruffleString) arg0Value;
                    if ((ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value_, arg1Value, arg2Value))) {
                        return ForceEncodingNode.compatibleMutable(arg0Value_, arg1Value, arg2Value, (AsTruffleStringNode.getUncached()));
                    }
                }
                if ((!(ForceEncodingNode.isCompatibleAndNotCompacted(arg0Value, arg1Value, arg2Value)))) {
                    return ForceEncodingNode.reinterpret(arg0Value, arg1Value, arg2Value, (ToIndexableNode.getUncached()), (ConditionProfile.getUncached()), (ConditionProfile.getUncached()), (CopyToByteArrayNode.getUncached()), (FromBufferWithStringCompactionNodeGen.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodesFactory.FromNativePointerNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CreateCodePointIteratorNode.class)
    static final class CreateCodePointIteratorNodeGen extends CreateCodePointIteratorNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ToIndexableNode toIndexableNode_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;

        private CreateCodePointIteratorNodeGen() {
        }

        @Override
        public TruffleStringIterator execute(AbstractTruffleString arg0Value, Encoding arg1Value, ErrorHandling arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 createIterator(AbstractTruffleString, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode) */) {
                return CreateCodePointIteratorNode.createIterator(arg0Value, arg1Value, arg2Value, this.toIndexableNode_, this.getCodeRangeANode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleStringIterator executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value, ErrorHandling arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.toIndexableNode_ = super.insert((ToIndexableNode.create()));
                this.getCodeRangeANode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 createIterator(AbstractTruffleString, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return CreateCodePointIteratorNode.createIterator(arg0Value, arg1Value, arg2Value, this.toIndexableNode_, this.getCodeRangeANode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CreateCodePointIteratorNode create() {
            return new CreateCodePointIteratorNodeGen();
        }

        public static CreateCodePointIteratorNode getUncached() {
            return CreateCodePointIteratorNodeGen.UNCACHED;
        }

        @GeneratedBy(CreateCodePointIteratorNode.class)
        @DenyReplace
        private static final class Uncached extends CreateCodePointIteratorNode {

            @TruffleBoundary
            @Override
            public TruffleStringIterator execute(AbstractTruffleString arg0Value, Encoding arg1Value, ErrorHandling arg2Value) {
                return CreateCodePointIteratorNode.createIterator(arg0Value, arg1Value, arg2Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(CreateBackwardCodePointIteratorNode.class)
    static final class CreateBackwardCodePointIteratorNodeGen extends CreateBackwardCodePointIteratorNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private volatile int state_0_;
        @Child private ToIndexableNode toIndexableNode_;
        @Child private com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode getCodeRangeANode_;

        private CreateBackwardCodePointIteratorNodeGen() {
        }

        @Override
        public TruffleStringIterator execute(AbstractTruffleString arg0Value, Encoding arg1Value, ErrorHandling arg2Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0 /* is-state_0 createIterator(AbstractTruffleString, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode) */) {
                return CreateBackwardCodePointIteratorNode.createIterator(arg0Value, arg1Value, arg2Value, this.toIndexableNode_, this.getCodeRangeANode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        private TruffleStringIterator executeAndSpecialize(AbstractTruffleString arg0Value, Encoding arg1Value, ErrorHandling arg2Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            try {
                int state_0 = this.state_0_;
                this.toIndexableNode_ = super.insert((ToIndexableNode.create()));
                this.getCodeRangeANode_ = super.insert((com.oracle.truffle.api.strings.TStringInternalNodesFactory.GetCodeRangeNodeGen.create()));
                this.state_0_ = state_0 = state_0 | 0b1 /* add-state_0 createIterator(AbstractTruffleString, Encoding, ErrorHandling, ToIndexableNode, GetCodeRangeNode) */;
                lock.unlock();
                hasLock = false;
                return CreateBackwardCodePointIteratorNode.createIterator(arg0Value, arg1Value, arg2Value, this.toIndexableNode_, this.getCodeRangeANode_);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            } else {
                return NodeCost.MONOMORPHIC;
            }
        }

        public static CreateBackwardCodePointIteratorNode create() {
            return new CreateBackwardCodePointIteratorNodeGen();
        }

        public static CreateBackwardCodePointIteratorNode getUncached() {
            return CreateBackwardCodePointIteratorNodeGen.UNCACHED;
        }

        @GeneratedBy(CreateBackwardCodePointIteratorNode.class)
        @DenyReplace
        private static final class Uncached extends CreateBackwardCodePointIteratorNode {

            @TruffleBoundary
            @Override
            public TruffleStringIterator execute(AbstractTruffleString arg0Value, Encoding arg1Value, ErrorHandling arg2Value) {
                return CreateBackwardCodePointIteratorNode.createIterator(arg0Value, arg1Value, arg2Value, (ToIndexableNode.getUncached()), (com.oracle.truffle.api.strings.TStringInternalNodes.GetCodeRangeNode.getUncached()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
