/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerNode;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.InsertableNode;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.StepConfig;
import com.oracle.truffle.api.debug.SteppingStrategy;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspendedContext;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SuspendedEvent {
    private final SourceSection sourceSection;
    private final SuspendAnchor suspendAnchor;
    private final Thread thread;
    private DebuggerSession session;
    private SuspendedContext context;
    private MaterializedFrame materializedFrame;
    private InsertableNode insertableNode;
    private List<Breakpoint> breakpoints;
    private DebuggerNode.InputValuesProvider inputValuesProvider;
    private volatile Object returnValue;
    private DebugException exception;
    private volatile boolean disposed;
    private volatile SteppingStrategy nextStrategy;
    private final Map<Breakpoint, Throwable> conditionFailures;
    private DebugStackFrameIterable cachedFrames;

    SuspendedEvent(DebuggerSession session, Thread thread, SuspendedContext context, MaterializedFrame frame, SuspendAnchor suspendAnchor, InsertableNode insertableNode, DebuggerNode.InputValuesProvider inputValuesProvider, Object returnValue, DebugException exception, List<Breakpoint> breakpoints, Map<Breakpoint, Throwable> conditionFailures) {
        this.session = session;
        this.context = context;
        this.suspendAnchor = suspendAnchor;
        this.materializedFrame = frame;
        this.insertableNode = insertableNode;
        this.inputValuesProvider = inputValuesProvider;
        this.returnValue = returnValue;
        this.exception = exception;
        this.conditionFailures = conditionFailures;
        this.breakpoints = breakpoints == null ? Collections.emptyList() : Collections.unmodifiableList(breakpoints);
        this.thread = thread;
        this.sourceSection = context.getInstrumentedSourceSection();
    }

    boolean isDisposed() {
        return this.disposed;
    }

    void clearLeakingReferences() {
        this.disposed = true;
        this.inputValuesProvider = null;
        this.returnValue = null;
        this.exception = null;
        this.breakpoints = null;
        this.materializedFrame = null;
        this.cachedFrames = null;
        this.session = null;
        this.context = null;
        this.insertableNode = null;
    }

    void verifyValidState(boolean allowDifferentThread) {
        if (this.disposed) {
            throw new IllegalStateException("Not in a suspended state.");
        }
        if (!allowDifferentThread && Thread.currentThread() != this.thread) {
            throw new IllegalStateException("Illegal thread access.");
        }
    }

    SteppingStrategy getNextStrategy() {
        SteppingStrategy strategy = this.nextStrategy;
        if (strategy == null) {
            return SteppingStrategy.createContinue();
        }
        return strategy;
    }

    private synchronized void setNextStrategy(SteppingStrategy nextStrategy) {
        this.verifyValidState(true);
        if (this.nextStrategy == null) {
            this.nextStrategy = nextStrategy;
        } else {
            if (this.nextStrategy.isKill()) {
                throw new IllegalStateException("Calls to prepareKill() cannot be followed by any other preparation call.");
            }
            if (this.nextStrategy.isDone()) {
                throw new IllegalStateException("Calls to prepareContinue() cannot be followed by any other preparation call.");
            }
            if (this.nextStrategy.isComposable()) {
                this.nextStrategy.add(nextStrategy);
            } else {
                this.nextStrategy = SteppingStrategy.createComposed(this.nextStrategy, nextStrategy);
            }
        }
    }

    public DebuggerSession getSession() {
        this.verifyValidState(true);
        return this.session;
    }

    Thread getThread() {
        return this.thread;
    }

    SuspendedContext getContext() {
        return this.context;
    }

    InsertableNode getInsertableNode() {
        return this.insertableNode;
    }

    public SourceSection getSourceSection() {
        this.verifyValidState(true);
        return this.session.resolveSection(this.sourceSection);
    }

    public SuspendAnchor getSuspendAnchor() {
        this.verifyValidState(true);
        return this.suspendAnchor;
    }

    public boolean hasSourceElement(SourceElement sourceElement) {
        return this.context.hasTag(sourceElement.getTag());
    }

    public boolean isLanguageContextInitialized() {
        this.verifyValidState(true);
        return this.context.isLanguageContextInitialized();
    }

    public DebugValue[] getInputValues() {
        if (this.inputValuesProvider == null) {
            return null;
        }
        Object[] inputValues = this.inputValuesProvider.getDebugInputValues(this.materializedFrame);
        int n = inputValues.length;
        DebugValue[] values = new DebugValue[n];
        for (int i = 0; i < n; ++i) {
            values[i] = inputValues[i] != null ? this.getTopStackFrame().wrapHeapValue(inputValues[i]) : null;
        }
        return values;
    }

    public DebugValue getReturnValue() {
        this.verifyValidState(false);
        Object ret = this.returnValue;
        if (ret == null) {
            return null;
        }
        return this.getTopStackFrame().wrapHeapValue(ret);
    }

    Object getReturnObject() {
        return this.returnValue;
    }

    public void setReturnValue(DebugValue newValue) {
        this.verifyValidState(false);
        if (this.returnValue == null) {
            throw new IllegalStateException("Can not set return value when there is no current return value.");
        }
        this.returnValue = newValue.get();
    }

    public DebugException getException() {
        return this.exception;
    }

    MaterializedFrame getMaterializedFrame() {
        return this.materializedFrame;
    }

    public Throwable getBreakpointConditionException(Breakpoint breakpoint) {
        this.verifyValidState(true);
        if (this.conditionFailures == null) {
            return null;
        }
        return this.conditionFailures.get(breakpoint);
    }

    public List<Breakpoint> getBreakpoints() {
        this.verifyValidState(true);
        return this.breakpoints;
    }

    public DebugStackFrame getTopStackFrame() {
        return this.getStackFrames().iterator().next();
    }

    public Iterable<DebugStackFrame> getStackFrames() {
        this.verifyValidState(false);
        if (this.cachedFrames == null) {
            this.cachedFrames = new DebugStackFrameIterable();
        }
        return this.cachedFrames;
    }

    static boolean isEvalRootStackFrame(DebuggerSession session, FrameInstance instance) {
        CallTarget target = instance.getCallTarget();
        RootNode root = null;
        if (target instanceof RootCallTarget) {
            root = ((RootCallTarget)target).getRootNode();
        }
        return root != null && session.getDebugger().getEnv().isEngineRoot(root);
    }

    public void prepareContinue() {
        this.setNextStrategy(SteppingStrategy.createContinue());
    }

    public SuspendedEvent prepareStepInto(int stepCount) {
        return this.prepareStepInto(StepConfig.newBuilder().count(stepCount).build());
    }

    public SuspendedEvent prepareStepOut(int stepCount) {
        return this.prepareStepOut(StepConfig.newBuilder().count(stepCount).build());
    }

    public SuspendedEvent prepareStepOver(int stepCount) {
        return this.prepareStepOver(StepConfig.newBuilder().count(stepCount).build());
    }

    public SuspendedEvent prepareStepInto(StepConfig stepConfig) {
        this.verifyConfig(stepConfig);
        this.setNextStrategy(SteppingStrategy.createStepInto(this.session, stepConfig));
        return this;
    }

    public SuspendedEvent prepareStepOut(StepConfig stepConfig) {
        this.verifyConfig(stepConfig);
        this.setNextStrategy(SteppingStrategy.createStepOut(this.session, stepConfig));
        return this;
    }

    public SuspendedEvent prepareStepOver(StepConfig stepConfig) {
        this.verifyConfig(stepConfig);
        this.setNextStrategy(SteppingStrategy.createStepOver(this.session, stepConfig));
        return this;
    }

    private void verifyConfig(StepConfig stepConfig) {
        Set<SourceElement> sessionElements = this.session.getSourceElements();
        if (sessionElements.isEmpty()) {
            throw new IllegalStateException("No source elements are enabled for stepping in the debugger session.");
        }
        Set<SourceElement> stepElements = stepConfig.getSourceElements();
        if (stepElements != null && !sessionElements.containsAll(stepElements)) {
            HashSet<SourceElement> extraElements = new HashSet<SourceElement>(stepElements);
            extraElements.removeAll(sessionElements);
            throw new IllegalArgumentException("The step source elements " + extraElements + " are not enabled in the session.");
        }
    }

    public void prepareUnwindFrame(DebugStackFrame frame) throws IllegalArgumentException {
        if (frame.event != this) {
            throw new IllegalArgumentException("The stack frame is not in the scope of this event.");
        }
        this.setNextStrategy(SteppingStrategy.createUnwind(frame.getDepth()));
    }

    public void prepareKill() {
        this.setNextStrategy(SteppingStrategy.createKill());
    }

    public String toString() {
        return "Suspended at " + this.getSourceSection() + " for thread " + this.getThread();
    }

    private final class DebugStackFrameIterable
    implements Iterable<DebugStackFrame> {
        private DebugStackFrame topStackFrame;
        private List<DebugStackFrame> otherFrames;

        private DebugStackFrameIterable() {
        }

        private DebugStackFrame getTopStackFrame() {
            if (this.topStackFrame == null) {
                this.topStackFrame = new DebugStackFrame(SuspendedEvent.this, null, 0);
            }
            return this.topStackFrame;
        }

        private List<DebugStackFrame> getOtherFrames() {
            if (this.otherFrames == null) {
                final ArrayList<DebugStackFrame> frameInstances = new ArrayList<DebugStackFrame>();
                Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){
                    private int depth;
                    {
                        this.depth = -SuspendedEvent.this.context.getStackDepth() - 1 + DebugStackFrameIterable.this.getTopFrameIndex();
                    }

                    @Override
                    public FrameInstance visitFrame(FrameInstance frameInstance) {
                        if (SuspendedEvent.isEvalRootStackFrame(SuspendedEvent.this.session, frameInstance)) {
                            return frameInstance;
                        }
                        Node callNode = frameInstance.getCallNode();
                        if (callNode != null && !DebugStackFrameIterable.this.hasRootTag(callNode)) {
                            return null;
                        }
                        if (++this.depth <= 0) {
                            return null;
                        }
                        frameInstances.add(new DebugStackFrame(SuspendedEvent.this, frameInstance, this.depth));
                        return null;
                    }
                });
                this.otherFrames = frameInstances;
            }
            return this.otherFrames;
        }

        private boolean hasRootTag(Node callNode) {
            Node node = callNode;
            do {
                if (!(node instanceof InstrumentableNode) || !((InstrumentableNode)((Object)node)).hasTag(StandardTags.RootTag.class)) continue;
                return true;
            } while ((node = node.getParent()) != null);
            return false;
        }

        private int getTopFrameIndex() {
            if (SuspendedEvent.this.context.getStackDepth() == 0) {
                return 0;
            }
            if (this.hasRootTag(SuspendedEvent.this.context.getInstrumentedNode())) {
                return 0;
            }
            return 1;
        }

        @Override
        public Iterator<DebugStackFrame> iterator() {
            return new Iterator<DebugStackFrame>(){
                private int index;
                private Iterator<DebugStackFrame> otherIterator;
                {
                    this.index = DebugStackFrameIterable.this.getTopFrameIndex();
                }

                @Override
                public boolean hasNext() {
                    SuspendedEvent.this.verifyValidState(false);
                    if (this.index == 0) {
                        return true;
                    }
                    return this.getOtherStackFrames().hasNext();
                }

                @Override
                public DebugStackFrame next() {
                    SuspendedEvent.this.verifyValidState(false);
                    if (this.index == 0) {
                        ++this.index;
                        return DebugStackFrameIterable.this.getTopStackFrame();
                    }
                    return this.getOtherStackFrames().next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private Iterator<DebugStackFrame> getOtherStackFrames() {
                    if (this.otherIterator == null) {
                        this.otherIterator = DebugStackFrameIterable.this.getOtherFrames().iterator();
                    }
                    return this.otherIterator;
                }
            };
        }
    }
}

