/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedHandles;
import com.oracle.svm.graal.isolated.IsolatedObjectProxy;
import java.net.URI;
import java.net.URISyntaxException;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedTruffleSourceLanguagePosition
extends IsolatedObjectProxy<TruffleSourceLanguagePosition>
implements TruffleSourceLanguagePosition {
    private final int lineNumber;
    private final int offsetStart;
    private final int offsetEnd;
    private final int nodeId;

    IsolatedTruffleSourceLanguagePosition(ClientHandle<TruffleSourceLanguagePosition> handle, int lineNumber, int offsetStart, int offsetEnd, int nodeId) {
        super(handle);
        this.lineNumber = lineNumber;
        this.offsetStart = offsetStart;
        this.offsetEnd = offsetEnd;
        this.nodeId = nodeId;
    }

    public String getDescription() {
        CompilerHandle<String> descriptionHandle = IsolatedTruffleSourceLanguagePosition.getDescription0(IsolatedCompileContext.get().getClient(), this.handle);
        return IsolatedCompileContext.get().unhand(descriptionHandle);
    }

    public int getOffsetEnd() {
        return this.offsetEnd;
    }

    public int getOffsetStart() {
        return this.offsetStart;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public URI getURI() {
        CompilerHandle<String> uriStringHandle = IsolatedTruffleSourceLanguagePosition.getURIString0(IsolatedCompileContext.get().getClient(), this.handle);
        String uriString = IsolatedCompileContext.get().unhand(uriStringHandle);
        try {
            return uriString != null ? new URI(uriString) : null;
        }
        catch (URISyntaxException e) {
            throw VMError.shouldNotReachHere("URI string should always be parseable", e);
        }
    }

    public String getLanguage() {
        CompilerHandle<String> languageHandle = IsolatedTruffleSourceLanguagePosition.getLanguage0(IsolatedCompileContext.get().getClient(), this.handle);
        return IsolatedCompileContext.get().unhand(languageHandle);
    }

    public String getNodeClassName() {
        CompilerHandle<String> nodeClassName = IsolatedTruffleSourceLanguagePosition.getLanguage0(IsolatedCompileContext.get().getClient(), this.handle);
        return IsolatedCompileContext.get().unhand(nodeClassName);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<String> getDescription0(ClientIsolateThread client, ClientHandle<TruffleSourceLanguagePosition> positionHandle) {
        String description = IsolatedCompileClient.get().unhand(positionHandle).getDescription();
        return IsolatedCompileClient.get().createStringInCompiler(description);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<String> getURIString0(ClientIsolateThread client, ClientHandle<TruffleSourceLanguagePosition> positionHandle) {
        URI uri = IsolatedCompileClient.get().unhand(positionHandle).getURI();
        return uri != null ? IsolatedCompileClient.get().createStringInCompiler(uri.toString()) : (CompilerHandle<String>)IsolatedHandles.nullHandle();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<String> getLanguage0(ClientIsolateThread client, ClientHandle<TruffleSourceLanguagePosition> positionHandle) {
        String language = IsolatedCompileClient.get().unhand(positionHandle).getLanguage();
        return IsolatedCompileClient.get().createStringInCompiler(language);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static CompilerHandle<String> getNodeClassName0(ClientIsolateThread client, ClientHandle<TruffleSourceLanguagePosition> positionHandle) {
        String language = IsolatedCompileClient.get().unhand(positionHandle).getNodeClassName();
        return IsolatedCompileClient.get().createStringInCompiler(language);
    }
}

