/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.sampler.SamplerBuffer;
import com.oracle.svm.core.sampler.SamplerBufferAccess;
import com.oracle.svm.core.sampler.SamplerSampleWriterData;
import com.oracle.svm.core.sampler.SamplerThreadLocal;
import com.oracle.svm.core.sampler.SubstrateSigprofHandler;
import com.oracle.svm.core.util.VMError;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class SamplerSampleWriter {
    private static final int END_MARKER_SIZE = 8;
    private static final long END_MARKER = -1L;

    private SamplerSampleWriter() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean putLong(SamplerSampleWriterData data, long value) {
        if (SamplerSampleWriter.ensureSize(data, 8)) {
            data.getCurrentPos().writeLong(0, value);
            SamplerSampleWriter.increaseCurrentPos(data, WordFactory.unsigned((int)8));
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void commit(SamplerSampleWriterData data) {
        SamplerBuffer buffer = data.getSamplerBuffer();
        VMError.guarantee(SamplerSampleWriter.getAvailableSize(data).aboveOrEqual(8));
        data.getCurrentPos().writeLong(0, -1L);
        SamplerSampleWriter.increaseCurrentPos(data, WordFactory.unsigned((int)8));
        buffer.setPos(data.getCurrentPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean ensureSize(SamplerSampleWriterData data, int requested) {
        assert (requested > 0);
        int totalRequested = requested + 8;
        if (SamplerSampleWriter.getAvailableSize(data).belowThan(totalRequested) && !SamplerSampleWriter.accommodate(data, SamplerSampleWriter.getUncommittedSize(data))) {
            return false;
        }
        assert (SamplerSampleWriter.getAvailableSize(data).aboveOrEqual(totalRequested));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean accommodate(SamplerSampleWriterData data, UnsignedWord uncommitted) {
        if (SamplerBufferAccess.isEmpty(data.getSamplerBuffer())) {
            SamplerThreadLocal.increaseMissedSamples();
            return false;
        }
        SamplerBuffer newBuffer = SubstrateSigprofHandler.singleton().availableBuffers().popBuffer();
        if (newBuffer.isNull()) {
            SamplerThreadLocal.increaseMissedSamples();
            return false;
        }
        SamplerThreadLocal.setThreadLocalBuffer(newBuffer);
        UnmanagedMemoryUtil.copy(data.getStartPos(), SamplerBufferAccess.getDataStart(newBuffer), uncommitted);
        SamplerBuffer oldBuffer = data.getSamplerBuffer();
        SubstrateSigprofHandler.singleton().fullBuffers().pushBuffer(oldBuffer);
        data.setSamplerBuffer(newBuffer);
        SamplerSampleWriter.reset(data);
        SamplerSampleWriter.increaseCurrentPos(data, uncommitted);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getAvailableSize(SamplerSampleWriterData data) {
        return data.getEndPos().subtract((UnsignedWord)data.getCurrentPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getUncommittedSize(SamplerSampleWriterData data) {
        return data.getCurrentPos().subtract((UnsignedWord)data.getStartPos());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void increaseCurrentPos(SamplerSampleWriterData data, UnsignedWord delta) {
        data.setCurrentPos(data.getCurrentPos().add(delta));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void reset(SamplerSampleWriterData data) {
        SamplerBuffer buffer = data.getSamplerBuffer();
        data.setStartPos(buffer.getPos());
        data.setCurrentPos(buffer.getPos());
        data.setEndPos(SamplerBufferAccess.getDataEnd(buffer));
    }
}

